/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.ComparisonOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;

public class UnaryComparisonOp
extends ComparisonOp {
    private String operator;
    private String negatedOperator;

    public UnaryComparisonOp(String operator, String negatedOperator, int target1, int target2) {
        super(target1, target2);
        this.operator = operator;
        this.negatedOperator = negatedOperator;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        if (mayNeedParen) {
            stream.print("(");
        }
        node.getChild(0).printOn(stream, true);
        stream.print(" " + (this.isNegated ? this.negatedOperator : this.operator));
        if (mayNeedParen) {
            stream.print(")");
        }
    }

    @Override
    public boolean simplify(Node node, MethodInfo method) {
        if (node.getChild(0).getOp().getType().getTypes()[0].equals("Z")) {
            if (this.operator.equals("== 0")) {
                this.operator = "== false";
            }
            if (this.operator.equals("!= 0")) {
                this.operator = "== true";
            }
            if (this.negatedOperator.equals("== 0")) {
                this.negatedOperator = "== false";
            }
            if (this.negatedOperator.equals("!= 0")) {
                this.negatedOperator = "== true";
            }
        }
        return super.simplify(node, method);
    }
}

