/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;

public class UnaryOp
extends NodeOp {
    private final String operator;

    public UnaryOp(String operator, Type type) {
        super(type);
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        if (mayNeedParen) {
            stream.print("(");
        }
        stream.print(this.operator);
        node.getChild(0).printOn(stream, true);
        if (mayNeedParen) {
            stream.print(")");
        }
    }

    @Override
    public boolean simplify(Node node, MethodInfo method) {
        if (this.operator.equals("return ") && method.signature.endsWith(")Z")) {
            node.getChild(0).getOp().makeBoolean();
        }
        return super.simplify(node, method);
    }
}

