/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.exceptions.AssignmentException;
import com.sap.jvm.debugging.impl.types.ClassHandleImpl;
import com.sap.jvm.debugging.impl.types.ValueHelper;
import com.sap.jvm.debugging.types.ArrayHandle;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.jdi.ArrayReference;
import com.sap.jvm.jdi.ArrayType;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.tracing.Trace;
import java.util.List;
import java.util.Map;

public class ArrayHandleImpl
implements ArrayHandle {
    private final ArrayReference array;

    public ArrayHandleImpl(ArrayReference ref) {
        this.array = ref;
    }

    @Override
    public long getId() {
        return this.array == null ? 0L : this.array.uniqueID();
    }

    ObjectReference object() {
        return this.array;
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayHandleImpl) {
            ArrayHandleImpl other = (ArrayHandleImpl)obj;
            if (this.array == null) {
                return other.array == null;
            }
            return this.array.equals(other.array);
        }
        return false;
    }

    @Override
    public ClassHandle getClassHandle() {
        return new ClassHandleImpl(this.array.referenceType());
    }

    @Override
    public int getLength() {
        return this.array == null ? 0 : this.array.length();
    }

    @Override
    public ValueHandle getValue(int index) {
        return ValueHelper.convert(this.array.getValue(index));
    }

    @Override
    public ValueHandle[] getValues(int index, int length) {
        List<Value> values = this.array.getValues(index, length);
        ValueHandle[] result = new ValueHandle[values.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ValueHelper.convert(values.get(i));
        }
        return result;
    }

    @Override
    public void setValue(int index, ValueHandle value, boolean throwException) {
        Value valueToSet = ValueHelper.convert(this.array.virtualMachine(), value);
        try {
            this.array.setValue(index, valueToSet);
        }
        catch (InvalidTypeException e) {
            if (throwException) {
                String valueType = value == null ? "java.lang.Object" : value.getTypeName();
                throw new AssignmentException(this.getComponentTypeName(), valueType, e);
            }
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.array.virtualMachine().getTraceContext()).debug((Throwable)e, () -> "Invalid type while setting array element at index " + index);
        }
        catch (ClassNotLoadedException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.array.virtualMachine().getTraceContext()).debug((Throwable)e, () -> "Class not loaded while setting array element at index " + index);
        }
    }

    @Override
    public String invokeToString(ThreadHandle thread, Map<String, String> detailFormatters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getComponentTypeName() {
        ArrayType type = (ArrayType)this.array.referenceType();
        return type.componentTypeName();
    }

    @Override
    public String getTypeName() {
        return this.array == null ? "java.lang.Object[]" : this.array.referenceType().name();
    }

    @Override
    public void retain() {
        if (this.array != null) {
            this.array.disableCollection();
        }
    }

    @Override
    public void release() {
        if (this.array != null) {
            this.array.enableCollection();
        }
    }
}

