/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.impl.types.FieldHandleImpl;
import com.sap.jvm.debugging.impl.types.ObjectHandleImpl;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.FieldHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.InterfaceType;
import com.sap.jvm.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ClassHandleImpl
extends ObjectHandleImpl
implements ClassHandle {
    private final String name;
    private final String packageName;
    private final FieldHandle[] fields;
    private final ReferenceType type;
    private final boolean hasStaticFields;
    private final boolean hasInstanceFields;
    private final boolean hasConstantFields;

    public ClassHandleImpl(ReferenceType type) {
        super(type.classObject());
        int lastDotIndex = type.name().lastIndexOf(46);
        if (lastDotIndex > 0) {
            this.name = type.name().substring(lastDotIndex + 1, type.name().length());
            this.packageName = type.name().substring(0, type.name().length() - this.name.length() - 1);
        } else {
            this.name = type.name();
            this.packageName = "";
        }
        List<Field> allFields = type.allFields();
        Collections.sort(allFields, new FieldComparator());
        this.fields = new FieldHandle[allFields.size()];
        boolean hasStatics = false;
        boolean hasNonStatics = false;
        boolean hasConstants = false;
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new FieldHandleImpl(allFields.get(i));
            hasStatics |= this.fields[i].isStatic() && !this.fields[i].isFinal();
            hasNonStatics |= !this.fields[i].isStatic();
            hasConstants |= this.fields[i].isStatic() && this.fields[i].isFinal();
        }
        this.type = type;
        this.hasStaticFields = hasStatics;
        this.hasInstanceFields = hasNonStatics;
        this.hasConstantFields = hasConstants;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPackage() {
        return this.packageName;
    }

    @Override
    public String getDisplayName() {
        if (this.packageName.length() > 0) {
            return this.packageName + "." + this.name;
        }
        return this.name;
    }

    @Override
    public ClassHandle getSuperClassHandle() {
        if (this.type instanceof ClassType) {
            ClassType clazz = (ClassType)this.type;
            ClassType superclass = clazz.superclass();
            if (superclass == null) {
                return null;
            }
            return new ClassHandleImpl(superclass);
        }
        if (this.type instanceof InterfaceType) {
            InterfaceType clazz = (InterfaceType)this.type;
            List<InterfaceType> superclasses = clazz.superinterfaces();
            if (superclasses.size() == 0) {
                return null;
            }
            if (superclasses.size() > 1) {
                throw new UnsupportedOperationException("More than one super class: " + superclasses);
            }
            return new ClassHandleImpl(superclasses.get(0));
        }
        return null;
    }

    @Override
    public ClassHandle[] getAllSuperClassHandles() {
        ReferenceType clazz;
        ArrayList<ClassHandleImpl> result = new ArrayList<ClassHandleImpl>();
        if (this.type instanceof ClassType) {
            clazz = (ClassType)this.type;
            for (ClassType superclass = clazz.superclass(); superclass != null; superclass = superclass.superclass()) {
                result.add(new ClassHandleImpl(superclass));
            }
            for (InterfaceType interf : clazz.allInterfaces()) {
                result.add(new ClassHandleImpl(interf));
            }
        }
        if (this.type instanceof InterfaceType) {
            clazz = (InterfaceType)this.type;
            HashSet<InterfaceType> allInterfaces = new HashSet<InterfaceType>();
            HashSet<Object> superInterfaces = new HashSet();
            HashSet<InterfaceType> tmpInterfaces = new HashSet<InterfaceType>(clazz.superinterfaces());
            while (!tmpInterfaces.isEmpty()) {
                for (InterfaceType interf : tmpInterfaces) {
                    if (allInterfaces.contains(interf)) continue;
                    result.add(new ClassHandleImpl(interf));
                    allInterfaces.add(interf);
                    superInterfaces.addAll(interf.superinterfaces());
                }
                tmpInterfaces.clear();
                HashSet<InterfaceType> tmp = tmpInterfaces;
                tmpInterfaces = superInterfaces;
                superInterfaces = tmp;
            }
        }
        return result.toArray(new ClassHandle[result.size()]);
    }

    @Override
    public boolean isInterface() {
        return this.type instanceof InterfaceType;
    }

    @Override
    public boolean isEnum() {
        return this.type instanceof ClassType && ((ClassType)this.type).isEnum();
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public ObjectHandle getClassLoaderHandle() {
        return this.type.classLoader() == null ? null : new ObjectHandleImpl(this.type.classLoader());
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public FieldHandle getField(int index) {
        return this.fields[index];
    }

    @Override
    public boolean hasStaticFields() {
        return this.hasStaticFields;
    }

    @Override
    public boolean hasInstanceFields() {
        return this.hasInstanceFields;
    }

    @Override
    public boolean hasConstantFields() {
        return this.hasConstantFields;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public ReferenceType getReferenceType() {
        return this.type;
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field f1, Field f2) {
            return f1.name().compareTo(f2.name());
        }
    }
}

