/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.exceptions.AssignmentException;
import com.sap.jvm.debugging.impl.types.ObjectHandleImpl;
import com.sap.jvm.debugging.impl.types.ValueHelper;
import com.sap.jvm.debugging.types.FieldHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.tracing.Trace;

public class FieldHandleImpl
implements FieldHandle {
    private final Field field;

    public FieldHandleImpl(Field field) {
        this.field = field;
    }

    @Override
    public String getName() {
        return this.field.name();
    }

    @Override
    public ValueHandle getValue(ObjectHandle object) {
        ObjectHandleImpl o = (ObjectHandleImpl)object;
        return ValueHelper.convert(o.object().getValue(this.field));
    }

    @Override
    public void setValue(ObjectHandle object, ValueHandle value, boolean throwException) {
        ObjectHandleImpl o = (ObjectHandleImpl)object;
        try {
            o.object().setValue(this.field, ValueHelper.convert(this.field.virtualMachine(), value));
        }
        catch (InvalidTypeException e) {
            if (throwException) {
                String valueType = value == null ? "java.lang.Object" : value.getTypeName();
                throw new AssignmentException(this.field.typeName(), valueType, e);
            }
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.field.virtualMachine().getTraceContext()).debug((Throwable)e, () -> "Invalid type while setting field '" + this.getName() + "'");
        }
        catch (ClassNotLoadedException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.field.virtualMachine().getTraceContext()).debug((Throwable)e, () -> "Class not loaded while setting field '" + this.getName() + "'");
        }
    }

    @Override
    public boolean isStatic() {
        return this.field.isStatic();
    }

    @Override
    public boolean isFinal() {
        return this.field.isFinal();
    }

    @Override
    public String getTypeName() {
        return this.field.typeName();
    }

    @Override
    public boolean isPublic() {
        return this.field.isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.field.isProtected();
    }

    @Override
    public boolean isPackagePrivate() {
        return this.field.isPackagePrivate();
    }

    @Override
    public boolean isPrivate() {
        return this.field.isPrivate();
    }
}

