/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.breakpoints.BreakpointLocation;
import com.sap.jvm.debugging.exceptions.AssignmentException;
import com.sap.jvm.debugging.exceptions.EvaluationException;
import com.sap.jvm.debugging.impl.DebuggerImpl;
import com.sap.jvm.debugging.impl.StackTrackerHelper;
import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ByteCodeReader;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.StackType;
import com.sap.jvm.debugging.impl.decompiler.TrackingStack;
import com.sap.jvm.debugging.impl.decompiler.TrackingStackCreator;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import com.sap.jvm.debugging.impl.types.MethodHandleImpl;
import com.sap.jvm.debugging.impl.types.ObjectHandleImpl;
import com.sap.jvm.debugging.impl.types.StackFrameWithAdaptedThis;
import com.sap.jvm.debugging.impl.types.ThreadHandleImpl;
import com.sap.jvm.debugging.impl.types.ValueHelper;
import com.sap.jvm.debugging.impl.types.VariableHandleImpl;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.MethodHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.StringHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.debugging.types.ValueFactory;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.debugging.types.VariableHandle;
import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.InternalException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.LocalVariable;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.Mirror;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.tools.example.debug.expr.ExpressionParser;
import com.sap.jvm.tools.jdi.StackTracker;
import com.sap.jvm.tools.jdi.StackTrackerEntry;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.misc.SignatureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FrameHandleImpl
implements FrameHandle {
    private final MethodHandleImpl method;
    private final ThreadHandleImpl thread;
    private final StackFrame frame;
    private final int bci;
    private final int lineNr;
    private final String sourceFile;
    private final String sourcePrefix;
    private static final boolean includeParseExceptionClass = "true".equals(System.getProperty("com.sap.jvm.debugging.includeParseExceptionClass"));

    public FrameHandleImpl(ThreadHandleImpl thread, StackFrame frame) {
        this.thread = thread;
        this.frame = frame;
        this.method = new MethodHandleImpl(frame.location().method());
        this.bci = (int)frame.location().codeIndex();
        this.lineNr = frame.location().lineNumber();
        String tmpSource = "";
        String tmpPrefix = "";
        try {
            tmpSource = frame.location().sourceName();
            tmpPrefix = frame.location().sourcePath();
            tmpPrefix = tmpPrefix.replace('\\', '/');
            int index = tmpPrefix.lastIndexOf(tmpSource);
            if (index >= 0 && (tmpPrefix = tmpPrefix.substring(0, index)).length() > 0 && tmpPrefix.charAt(tmpPrefix.length() - 1) == '/') {
                tmpPrefix = tmpPrefix.substring(0, tmpPrefix.length() - 1);
            }
        }
        catch (AbsentInformationException index) {
            // empty catch block
        }
        if (tmpSource.length() == 0) {
            String className = frame.location().method().declaringType().name();
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex > 0) {
                tmpSource = className.substring(lastDotIndex + 1) + ".java";
                tmpPrefix = className.substring(0, lastDotIndex).replace('.', '/');
            } else {
                tmpSource = className + ".java";
                tmpPrefix = "";
            }
        }
        this.sourceFile = tmpSource;
        this.sourcePrefix = tmpPrefix;
    }

    @Override
    public MethodHandle getMethodHandle() {
        return this.method;
    }

    @Override
    public ThreadHandle getThreadHandle() {
        return this.thread;
    }

    @Override
    public int getBci() {
        return this.bci;
    }

    @Override
    public int getLineNr() {
        return this.lineNr;
    }

    @Override
    public String getSourceName() {
        return this.sourceFile;
    }

    @Override
    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    public String toString() {
        return this.method + ":" + this.lineNr;
    }

    private TrackingStackCreator addReturnValues(List<VariableHandle> variables, Set<Integer> bcisAlreadyHandled) {
        StackTracker tracker;
        DebuggerImpl debugger = this.thread.getThreadManager().getDebugger();
        TrackingStackCreator tsc = null;
        if (debugger.includeReturnValues() && (tracker = this.thread.getStackTracker(this)) != null && (tsc = this.method.getTrackingStackCreator()) != null) {
            final LinkedHashMap<String, StackTrackerEntry> entries = StackTrackerHelper.getEntriesForStackTracker(tsc, tracker, false, debugger);
            String[] sortedKeys = entries.keySet().toArray(new String[entries.size()]);
            Arrays.sort(sortedKeys, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int bci1 = ((StackTrackerEntry)entries.get(s1)).getBci();
                    int bci2 = ((StackTrackerEntry)entries.get(s2)).getBci();
                    return Integer.valueOf(bci1).compareTo(bci2);
                }
            });
            for (String name : sortedKeys) {
                StackTrackerEntry entry = entries.get(name);
                bcisAlreadyHandled.add(entry.getBci());
                ValueHandle handle = ValueHelper.convert(entry.getValue());
                String type = new StackType(entry.getType()).getType().toString();
                variables.add(new VariableHandleImpl(name, handle, type));
            }
        }
        return tsc;
    }

    private void addSpecialVariables(TrackingStackCreator initialTsc, List<VariableHandle> variables, Set<Integer> bcisAlreadyHandled) {
        DebuggerImpl debugger = this.thread.getThreadManager().getDebugger();
        if (this.thread.canAccessStack() && this.thread.getFrames()[0] == this && debugger.includeReturnValues()) {
            int prevCode;
            ArrayList<Integer> prevs;
            TrackingStackCreator tsc = initialTsc;
            if (tsc == null) {
                tsc = this.method.getTrackingStackCreator();
            }
            int prevBci = -1;
            TrackingStack stack = null;
            if (tsc != null && tsc.getStack(this.bci).size() > 0 && (prevs = tsc.getPrevBcis(this.bci)).size() == 1 && ((prevCode = tsc.getByteCode(prevs.get(0))) == 185 || prevCode == 183 || prevCode == 184 || prevCode == 182)) {
                prevBci = prevs.get(0);
                stack = tsc.getStack(this.bci);
            }
            if (prevBci >= 0 && stack.size() > 0 && stack.get(0)[0] == prevBci) {
                StackType stackType = tsc.getStack(this.bci).getTypes(0)[0];
                com.sap.jvm.jdi.Type jdiType = ValueHelper.getBasicType(this.frame.virtualMachine(), stackType.getInternalType());
                if (this.frame.virtualMachine().canUseSapExtensions() && !bcisAlreadyHandled.contains(this.bci)) {
                    try {
                        int slot = stack.size() - (stackType.isSecondSlotType() ? 2 : 1);
                        ValueHandle handle = ValueHelper.convert(this.frame.getStackValue(slot, jdiType));
                        ByteCodeReader reader = new ByteCodeReader(tsc.getMethodInfo().getCode(), prevBci + ByteCode.getByteCodeParameterOffset(prevBci));
                        int cpSlot = reader.readUint16();
                        ConstantPoolEntry cpEntry = tsc.getMethodInfo().getCpEntry(cpSlot);
                        StackTrackerHelper.ReturnKey key = new StackTrackerHelper.ReturnKey(cpEntry, prevBci);
                        if (debugger.shouldShowReturnValue(key.full)) {
                            String methodName = cpEntry.getReferenceName();
                            String fullClassName = cpEntry.getReferenceClass().replace('/', '.');
                            String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
                            String fullSig = SignatureHelper.toExternalSignature((String)cpEntry.getReferenceType());
                            String funcSuffix = fullSig.startsWith("()") ? "()" : "(...)";
                            variables.add(new VariableHandleImpl("<" + shortClassName + "." + methodName + funcSuffix + " returns>", handle, stackType.getType().toString()));
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public VariableHandle[] getVariables() {
        ObjectReference exception;
        ObjectHandleImpl waitingMonitor;
        ObjectHandleImpl contendedMonitor;
        String typename;
        ObjectHandleImpl[] ownedMonitors;
        HashSet<Integer> bcisAlreadyHandled;
        ArrayList<VariableHandle> result;
        block15: {
            result = new ArrayList<VariableHandle>();
            bcisAlreadyHandled = new HashSet<Integer>();
            ObjectReference thisObject = this.frame.thisObject();
            if (thisObject != null) {
                result.add(new VariableHandleImpl("this", ValueHelper.convert(thisObject), thisObject.type().name()));
            }
            boolean hasArguments = false;
            try {
                List<LocalVariable> list = this.frame.visibleVariables();
                Map<LocalVariable, Value> map = this.frame.getValues(list);
                for (LocalVariable local : list) {
                    ValueHandle handle = ValueHelper.convert(map.get(local));
                    result.add(new VariableHandleImpl(local.name(), handle, local.typeName()));
                    hasArguments = true;
                }
            }
            catch (AbsentInformationException list) {
                // empty catch block
            }
            if (!(hasArguments || this.method.isNative() || this.method.getSignature().startsWith("()"))) {
                int index = 0;
                String signature = this.method.getSignature();
                int start = signature.indexOf(40);
                int end = signature.lastIndexOf(41);
                String argumentTypes = signature.substring(start + 1, end);
                Type[] types = Type.createTypes(argumentTypes);
                try {
                    for (Value arg : this.frame.getArgumentValues()) {
                        ValueHandle handle = ValueHelper.convert(arg);
                        result.add(new VariableHandleImpl("arg" + index, handle, types[index].toString()));
                        ++index;
                    }
                }
                catch (InternalException e) {
                    if (e.errorCode() == 35) break block15;
                    throw e;
                }
            }
        }
        if ((ownedMonitors = this.thread.getOwnedMonitors()).length > 0 && this.thread.getFrames() != null && this.thread.getFrames()[0] == this) {
            for (int i = ownedMonitors.length - 1; i >= 0; --i) {
                typename = ownedMonitors[i].object().type().name();
                result.add(new VariableHandleImpl("<Monitor " + (ownedMonitors.length - i) + ": " + typename + ">", ValueHelper.convert(ownedMonitors[i].object()), typename));
            }
        }
        if ((contendedMonitor = this.thread.getContendedMonitor()) != null && this.thread.getFrames() != null && this.thread.getFrames()[0] == this) {
            typename = contendedMonitor.object().type().name();
            result.add(new VariableHandleImpl("<Contended Monitor: " + typename + ">", ValueHelper.convert(contendedMonitor.object()), typename));
        }
        if ((waitingMonitor = this.thread.getWaitingMonitor()) != null && this.thread.getFrames() != null && this.thread.getFrames()[0] == this) {
            String typename2 = waitingMonitor.object().type().name();
            result.add(new VariableHandleImpl("<Waiting Monitor: " + typename2 + ">", ValueHelper.convert(waitingMonitor.object()), typename2));
        }
        if ((exception = this.thread.getException()) != null && this.thread.getFrames() != null && this.thread.getFrames()[0] == this) {
            String typename3 = exception.type().name();
            result.add(new VariableHandleImpl("<" + typename3 + ">", new ObjectHandleImpl(exception), typename3));
        }
        try {
            TrackingStackCreator tsc = this.addReturnValues(result, bcisAlreadyHandled);
            this.addSpecialVariables(tsc, result, bcisAlreadyHandled);
        }
        catch (Throwable e) {
            Trace.warn((Throwable)e, (String)"Could not add special variables");
        }
        return result.toArray(new VariableHandle[result.size()]);
    }

    @Override
    public void setVariable(String name, ValueHandle value, boolean throwException) {
        LocalVariable variable = null;
        try {
            variable = this.frame.visibleVariableByName(name);
            if (variable == null) {
                if (!"this".equals(name)) {
                    Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.frame.virtualMachine().getTraceContext()).debug(() -> "Local variable '" + name + "' not found.");
                }
                return;
            }
            this.frame.setValue(variable, ValueHelper.convert(this.frame.virtualMachine(), value));
        }
        catch (AbsentInformationException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.frame.virtualMachine().getTraceContext()).debug((Throwable)e, () -> "Missing information while searching for local variable '" + name + "'");
        }
        catch (InvalidTypeException e) {
            if (throwException) {
                assert (variable != null);
                String valueType = value == null ? "java.lang.Object" : value.getTypeName();
                throw new AssignmentException(variable.typeName(), valueType, e);
            }
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.frame.virtualMachine().getTraceContext()).debug((Throwable)e, () -> "Invalid type while setting local variable '" + name + "'");
        }
        catch (ClassNotLoadedException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.frame.virtualMachine().getTraceContext()).debug((Throwable)e, () -> "Class not loaded while setting local variable '" + name + "'");
        }
    }

    private String getSanitizedExpresion(String expression) {
        int second;
        String realExpression = expression;
        if (realExpression.startsWith("#") && (second = realExpression.substring(1).indexOf(35)) >= 0) {
            realExpression = realExpression.substring(second + 2);
        }
        return realExpression;
    }

    @Override
    public VariableHandle evaluateExpression(String expression, boolean throwException) {
        String realExpression = this.getSanitizedExpresion(expression);
        FrameHandle[] stack = this.thread.getFrames();
        int currentFrame = -1;
        for (int i = 0; i < stack.length; ++i) {
            if (stack[i] != this) continue;
            currentFrame = i;
            break;
        }
        if (currentFrame < 0) {
            throw new IllegalStateException("Stack frame not found");
        }
        final int frameIndex = currentFrame;
        try {
            Value value = this.thread.getThreadManager().getExpressionManager().evaluate(realExpression, this.frame.virtualMachine(), new ExpressionParser.GetFrame(){

                @Override
                public StackFrame get() throws IncompatibleThreadStateException {
                    FrameHandleImpl.this.thread.refresh();
                    return ((FrameHandleImpl)FrameHandleImpl.this.thread.getFrames()[frameIndex]).frame;
                }

                @Override
                public Value getVisibleSyntheticVariableByName(StackFrame stackFrame, String name) {
                    return FrameHandleImpl.getVisibleSyntheticVariableByName(stackFrame, name);
                }
            }, this.thread.getId());
            ValueHandle handle = ValueHelper.convert(value);
            String typeName = value == null ? "null" : value.type().name();
            return new VariableHandleImpl(expression, handle, typeName);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new EvaluationException(e);
            }
            String message = "<error(s) during evaluation: " + (includeParseExceptionClass ? e.getClass().getName() + " " : "") + (e.getMessage() == null ? "unknown reason" : e.getMessage()) + ">";
            StringHandle result = ValueFactory.create(this.frame.virtualMachine(), message);
            return new VariableHandleImpl(expression, result, result.getTypeName());
        }
    }

    @Override
    public VariableHandle evaluateExpressionWithContext(String expression, ObjectHandle context, boolean throwException) {
        String realExpression = this.getSanitizedExpresion(expression);
        try {
            final ThreadReference t = this.thread.getReference();
            final ObjectReference object = ((ObjectHandleImpl)context).object();
            Value value = this.thread.getThreadManager().getExpressionManager().evaluate(realExpression, this.frame.virtualMachine(), new ExpressionParser.GetFrame(){

                @Override
                public StackFrame get() throws IncompatibleThreadStateException {
                    return new StackFrameWithAdaptedThis(t.frame(0), object);
                }

                @Override
                public Value getVisibleSyntheticVariableByName(StackFrame stackFrame, String name) {
                    return FrameHandleImpl.getVisibleSyntheticVariableByName(stackFrame, name);
                }
            }, this.thread.getId());
            ValueHandle handle = ValueHelper.convert(value);
            String typeName = value == null ? "null" : value.type().name();
            return new VariableHandleImpl(expression, handle, typeName);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new EvaluationException(e);
            }
            String message = "<error(s) during evaluation: " + (includeParseExceptionClass ? e.getClass().getName() + " " : "") + (e.getMessage() == null ? "unknown reason" : e.getMessage()) + ">";
            StringHandle result = ValueFactory.create(this.frame.virtualMachine(), message);
            return new VariableHandleImpl(expression, result, result.getTypeName());
        }
    }

    @Override
    public Mirror getMirror() {
        return this.frame;
    }

    @Override
    public BreakpointLocation getLocation() {
        return new BreakpointLocation(this.frame.location());
    }

    public boolean equalsLocation(FrameHandleImpl other) {
        return this.bci == other.bci && this.lineNr == other.lineNr && this.toString().equals(other.toString());
    }

    public StackFrame getFrame() {
        return this.frame;
    }

    public static Value getVisibleSyntheticVariableByName(StackFrame stackFrame, String name) {
        int index = 0;
        Method method = stackFrame.location().method();
        if (name.length() > 0 && name.charAt(0) == '$') {
            if (name.equals("$class")) {
                return method.declaringType().classObject();
            }
            if (name.equals("$bci")) {
                return stackFrame.virtualMachine().mirrorOf(stackFrame.location().codeIndex());
            }
            if (name.equals("$line")) {
                return stackFrame.virtualMachine().mirrorOf(stackFrame.location().lineNumber());
            }
        }
        if (!name.startsWith("arg")) {
            return null;
        }
        if (method.isNative()) {
            return null;
        }
        if (method.signature().startsWith("()")) {
            return null;
        }
        boolean hasArguments = false;
        try {
            for (LocalVariable local : stackFrame.visibleVariables()) {
                stackFrame.getValue(local);
                hasArguments = true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        if (hasArguments) {
            return null;
        }
        for (Value arg : stackFrame.getArgumentValues()) {
            String curr = "arg" + index;
            if (curr.equals(name)) {
                return arg;
            }
            ++index;
        }
        return null;
    }
}

