/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.Decompiler;
import com.sap.jvm.debugging.impl.decompiler.ExceptionTableEntry;
import com.sap.jvm.debugging.impl.decompiler.LocalVariableTableEntry;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.TrackingStackCreator;
import com.sap.jvm.debugging.impl.types.ClassHandleImpl;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.MethodHandle;
import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class MethodHandleImpl
implements MethodHandle {
    private final String name;
    private final String signature;
    private final ClassHandle clazz;
    private final boolean isNative;
    private final Method method;
    private volatile TrackingStackCreator tsc;

    public MethodHandleImpl(Method method) {
        this.method = method;
        this.name = method.name();
        this.signature = method.signature();
        this.clazz = new ClassHandleImpl(method.declaringType());
        this.isNative = method.isNative();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public boolean isNative() {
        return this.isNative;
    }

    @Override
    public ClassHandle getClassHandle() {
        return this.clazz;
    }

    public String toString() {
        return this.clazz + "." + this.name + this.getExternalSignature();
    }

    public synchronized TrackingStackCreator getTrackingStackCreator() {
        if (this.method.isNative()) {
            return null;
        }
        if (!this.method.virtualMachine().canUseSapExtensions()) {
            return null;
        }
        if (this.tsc == null) {
            ReferenceType cls = this.method.declaringType();
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(cls.constantPool()));
            try {
                ConstantPoolEntry[] cp = Decompiler.readConstantPool(cls.constantPoolCount(), di);
                MethodInfo methodInfo = new MethodInfo(this.getClassHandle().getDisplayName(), this.getName(), this.getSignature(), 0, 0, 0, this.method.bytecodes(), cp, new ExceptionTableEntry[0], new LocalVariableTableEntry[0], new String[0]);
                this.tsc = new TrackingStackCreator(methodInfo, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.tsc;
    }

    private String getExternalSignature() {
        StringBuilder result = new StringBuilder();
        boolean isInClass = false;
        int arrayDim = 0;
        boolean needsComma = false;
        for (char c : this.signature.toCharArray()) {
            if (c == ')') {
                needsComma = false;
                result.append(c);
            } else {
                if (needsComma) {
                    result.append(", ");
                    needsComma = false;
                }
                if (isInClass) {
                    if (c == '/') {
                        result.append('.');
                    } else if (c == ';') {
                        isInClass = false;
                        needsComma = true;
                    } else {
                        result.append(c);
                    }
                } else {
                    needsComma = true;
                    switch (c) {
                        case 'Z': {
                            result.append("boolean");
                            break;
                        }
                        case 'B': {
                            result.append("byte");
                            break;
                        }
                        case 'S': {
                            result.append("short");
                            break;
                        }
                        case 'C': {
                            result.append("char");
                            break;
                        }
                        case 'I': {
                            result.append("int");
                            break;
                        }
                        case 'J': {
                            result.append("long");
                            break;
                        }
                        case 'F': {
                            result.append("float");
                            break;
                        }
                        case 'D': {
                            result.append("double");
                            break;
                        }
                        case 'V': {
                            result.append("void");
                            break;
                        }
                        case '[': {
                            ++arrayDim;
                            needsComma = false;
                            break;
                        }
                        case 'L': {
                            isInClass = true;
                            needsComma = false;
                            break;
                        }
                        case '(': {
                            needsComma = false;
                            result.append(c);
                            break;
                        }
                        default: {
                            needsComma = false;
                        }
                    }
                }
            }
            if (!needsComma) continue;
            for (int i = 0; i < arrayDim; ++i) {
                result.append("[]");
            }
            arrayDim = 0;
        }
        return result.toString();
    }

    @Override
    public int[] getBcisOnSameLine(int bci) {
        Location loc = this.method.locationOfCodeIndex(bci);
        if (loc == null) {
            return new int[]{bci};
        }
        int lineNr = loc.lineNumber();
        int maxBci = this.method.bytecodes().length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        HashMap<Integer, Integer> bciToLineMapping = new HashMap<Integer, Integer>();
        try {
            if (this.getTrackingStackCreator() == null) {
                return new int[]{bci};
            }
            MethodInfo methodInfo = this.tsc.getMethodInfo();
            for (Location c : this.method.allLineLocations()) {
                bciToLineMapping.put((int)c.codeIndex(), c.lineNumber());
            }
            for (Location c : this.method.allLineLocations()) {
                Integer currLine;
                if (c.lineNumber() != lineNr) continue;
                for (int b = (int)c.codeIndex(); b < maxBci && ((currLine = (Integer)bciToLineMapping.get(b)) == null || currLine == lineNr); b += ByteCode.getSize(b, methodInfo)) {
                    result.add(b);
                }
            }
        }
        catch (AbsentInformationException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.method.virtualMachine().getTraceContext()).warn((Throwable)e, "Could not get line numbers");
        }
        int[] resultArray = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return resultArray;
    }

    @Override
    public long getMethodId() {
        return this.method.getMethodId();
    }
}

