/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.impl.types.ClassHandleImpl;
import com.sap.jvm.debugging.impl.types.FrameHandleImpl;
import com.sap.jvm.debugging.impl.types.StackFrameWithAdaptedThis;
import com.sap.jvm.debugging.impl.types.ThreadHandleImpl;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.InvocationException;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.StringReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.tools.example.debug.expr.ExpressionParser;
import com.sap.jvm.tracing.Trace;
import java.util.ArrayList;
import java.util.Map;

public class ObjectHandleImpl
implements ObjectHandle {
    private final ObjectReference object;

    public ObjectHandleImpl(ObjectReference ref) {
        this.object = ref;
    }

    @Override
    public long getId() {
        return this.object == null ? 0L : this.object.uniqueID();
    }

    ObjectReference object() {
        return this.object;
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectHandleImpl) {
            ObjectHandleImpl other = (ObjectHandleImpl)obj;
            if (this.object == null) {
                return other.object == null;
            }
            return this.object.equals(other.object);
        }
        return false;
    }

    @Override
    public ClassHandle getClassHandle() {
        return new ClassHandleImpl(this.object.referenceType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String invokeToString(ThreadHandle thread, Map<String, String> detailFormatters) {
        if (this.object == null || thread == null || !thread.isSuspended() || !(thread instanceof ThreadHandleImpl)) {
            return "";
        }
        ThreadHandleImpl t = (ThreadHandleImpl)thread;
        ClassType type = (ClassType)this.object.type();
        ObjectReference objectRef = this.object;
        if (this.hasDetailFormatter(detailFormatters)) {
            String expression = detailFormatters.get(type.name());
            final ThreadReference threadRef = t.getReference();
            try {
                if (threadRef.hasTopNativeFrame()) {
                    String string = "";
                    return string;
                }
                Value value = t.getThreadManager().getExpressionManager().evaluate(expression, threadRef.virtualMachine(), new ExpressionParser.GetFrame(){

                    @Override
                    public StackFrame get() throws IncompatibleThreadStateException {
                        return new StackFrameWithAdaptedThis(threadRef.frame(0), ObjectHandleImpl.this.object);
                    }

                    @Override
                    public Value getVisibleSyntheticVariableByName(StackFrame frame, String name) {
                        return FrameHandleImpl.getVisibleSyntheticVariableByName(frame, name);
                    }
                }, threadRef.uniqueID());
                if (value == null) {
                    String string = "null";
                    return string;
                }
                if (!(value instanceof ObjectReference)) {
                    String string = value.toString();
                    return string;
                }
                objectRef = (ObjectReference)value;
                type = (ClassType)objectRef.type();
            }
            catch (Throwable e) {
                ClassType typeL = type;
                Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.object.virtualMachine().getTraceContext()).debug(e, () -> "Error in detail formatter for class " + typeL.name());
                String string = e.getClass().getName() + ": " + e.getMessage();
                return string;
            }
            finally {
                thread.refresh();
            }
        }
        Method toString = type.concreteMethodByName("toString", "()Ljava/lang/String;");
        try {
            if (t.getReference().hasTopNativeFrame()) {
                return "";
            }
            StringReference result = (StringReference)t.getThreadManager().getExpressionManager().invokeMethod(objectRef, t.getReference(), toString, new ArrayList());
            thread.refresh();
            if (result == null) {
                return "null";
            }
            int len = result.getLength();
            if (len < 1000) {
                return result.substring(0, len);
            }
            return result.substring(0, 1000) + "...";
        }
        catch (InvalidTypeException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.object.virtualMachine().getTraceContext()).debug((Throwable)e, "Invalid type in toString call");
        }
        catch (ClassNotLoadedException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.object.virtualMachine().getTraceContext()).debug((Throwable)e, "Class not loaded in toString call");
        }
        catch (IncompatibleThreadStateException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.object.virtualMachine().getTraceContext()).debug((Throwable)e, "Thread not suspended in toString call");
            thread.refresh();
            return "This thread has been manually suspended and therefore object details are unavailable.";
        }
        catch (InvocationException e) {
            Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.object.virtualMachine().getTraceContext()).debug((Throwable)e, "Exception during toString call");
        }
        return "";
    }

    public boolean hasDetailFormatter(Map<String, String> detailFormatters) {
        return detailFormatters != null && detailFormatters.size() > 0 && this.object != null && detailFormatters.containsKey(this.object.type().name());
    }

    @Override
    public String getTypeName() {
        return this.object == null ? "java.lang.Object" : this.object.referenceType().name();
    }

    @Override
    public void retain() {
        if (this.object != null) {
            this.object.disableCollection();
        }
    }

    @Override
    public void release() {
        if (this.object != null) {
            this.object.enableCollection();
        }
    }
}

