/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.LocalVariable;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class StackFrameWithAdaptedThis
implements StackFrame {
    private final StackFrame frame;
    private final ObjectReference thisObject;

    public StackFrameWithAdaptedThis(StackFrame frame, ObjectReference thisObject) {
        this.frame = frame;
        this.thisObject = thisObject;
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this.frame.virtualMachine();
    }

    @Override
    public Location location() {
        return this.frame.location();
    }

    @Override
    public ThreadReference thread() {
        return this.frame.thread();
    }

    @Override
    public ObjectReference thisObject() {
        return this.thisObject;
    }

    @Override
    public List<LocalVariable> visibleVariables() throws AbsentInformationException {
        return Collections.emptyList();
    }

    @Override
    public LocalVariable visibleVariableByName(String name) throws AbsentInformationException {
        return null;
    }

    @Override
    public Value getValue(LocalVariable variable) {
        return this.frame.getValue(variable);
    }

    @Override
    public Map<LocalVariable, Value> getValues(List<? extends LocalVariable> variables) {
        throw new IllegalArgumentException("No variables visible");
    }

    @Override
    public void setValue(LocalVariable variable, Value value) throws InvalidTypeException, ClassNotLoadedException {
    }

    @Override
    public List<Value> getArgumentValues() {
        return Collections.emptyList();
    }

    @Override
    public Value getStackValue(int slot, Type type) {
        throw new IllegalArgumentException("No stack values visible");
    }

    @Override
    public Map<Integer, Value> getStackValues(Map<Integer, Type> variables) {
        throw new IllegalArgumentException("No stack values visible");
    }
}

