/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.impl.types.ObjectHandleImpl;
import com.sap.jvm.debugging.types.StringHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.jdi.StringReference;
import java.util.Map;

public class StringHandleImpl
extends ObjectHandleImpl
implements StringHandle {
    public StringHandleImpl(StringReference ref) {
        super(ref);
    }

    @Override
    public String get() {
        return ((StringReference)this.object()).value();
    }

    @Override
    public String invokeToString(ThreadHandle thread, Map<String, String> detailFormatters) {
        if (this.hasDetailFormatter(detailFormatters)) {
            return super.invokeToString(thread, detailFormatters);
        }
        int len = this.length();
        if (len > 1000) {
            return this.substring(0, 1000) + "...";
        }
        return this.get();
    }

    @Override
    public int length() {
        return ((StringReference)this.object()).getLength();
    }

    @Override
    public String substring(int start, int end) {
        return ((StringReference)this.object()).substring(start, end);
    }
}

