/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.types.ThreadGroupHandle;
import com.sap.jvm.jdi.ThreadGroupReference;

public final class ThreadGroupHandleImpl
implements ThreadGroupHandle {
    private final long id;
    private final String name;
    private final ThreadGroupHandleImpl parent;

    public ThreadGroupHandleImpl(ThreadGroupReference group) {
        if (group == null) {
            this.id = 0L;
            this.name = "<unknown>";
            this.parent = null;
            return;
        }
        this.id = group.uniqueID();
        this.name = group.name();
        ThreadGroupReference parentGroup = group.parent();
        this.parent = parentGroup == null ? null : new ThreadGroupHandleImpl(parentGroup);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ThreadGroupHandle getParent() {
        return this.parent;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadGroupHandleImpl other = (ThreadGroupHandleImpl)obj;
        return this.id == other.id;
    }
}

