/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.breakpoints.LineBreakpoint;
import com.sap.jvm.debugging.breakpoints.MethodBreakpoint;
import com.sap.jvm.debugging.impl.DebuggerImpl;
import com.sap.jvm.debugging.impl.ExpressionEvaluationManager;
import com.sap.jvm.debugging.impl.StackTrackerHelper;
import com.sap.jvm.debugging.impl.ThreadManager;
import com.sap.jvm.debugging.impl.decompiler.TrackingStackCreator;
import com.sap.jvm.debugging.impl.types.FrameHandleImpl;
import com.sap.jvm.debugging.impl.types.MethodHandleImpl;
import com.sap.jvm.debugging.impl.types.ObjectHandleImpl;
import com.sap.jvm.debugging.impl.types.OmittingFrameHandleImpl;
import com.sap.jvm.debugging.impl.types.ThreadGroupHandleImpl;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.ThreadGroupHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.tools.jdi.StackTracker;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class ThreadHandleImpl
extends ObjectHandleImpl
implements ThreadHandle {
    public static final int MAX_TOP_STACK_FRAME_NR = 200;
    public static final int MAX_BOTTOM_STACK_FRAME_NR = 200;
    private static final FrameHandleImpl[] EMPTY_FRAMES = new FrameHandleImpl[0];
    private static final Breakpoint[] EMPTY_BREAKPOINTS = new Breakpoint[0];
    private static final ObjectHandleImpl[] EMPTY_OBJECTS = new ObjectHandleImpl[0];
    private final boolean isSuspended;
    private boolean isStepping;
    private final boolean isDaemon;
    private final boolean isSystem;
    private final String name;
    private FrameHandleImpl[] frames;
    private final ThreadReference ref;
    private Breakpoint[] breakpoints;
    private final ThreadManager manager;
    private ObjectReference exception;
    private final ObjectHandleImpl contendedMonitor;
    private final ObjectHandleImpl waitingMonitor;
    private final ObjectHandleImpl[] ownedMonitors;
    private final boolean hasEndedStep;
    private final ThreadGroupHandleImpl group;

    public ThreadHandleImpl(ThreadManager manager, ThreadReference thread, boolean asRunning, ObjectReference exception, boolean stepping, boolean hasEndedStep) {
        super(thread);
        this.manager = manager;
        this.isSuspended = asRunning ? false : thread.isSuspended();
        this.isStepping = stepping;
        this.hasEndedStep = hasEndedStep;
        this.name = thread.name();
        this.ref = thread;
        this.refreshFrames();
        this.breakpoints = EMPTY_BREAKPOINTS;
        this.exception = exception;
        ObjectHandleImpl contended = null;
        ObjectHandleImpl waiting = null;
        ObjectHandleImpl[] owned = EMPTY_OBJECTS;
        if (this.isSuspended) {
            try {
                List<ObjectReference> objectMonitors;
                ObjectReference monitor2 = thread.currentContendedMonitor();
                if (monitor2 != null) {
                    int status = thread.status();
                    if (status == 3) {
                        contended = new ObjectHandleImpl(monitor2);
                    } else if (status == 4) {
                        waiting = new ObjectHandleImpl(monitor2);
                    }
                }
                if ((objectMonitors = thread.ownedMonitors()).size() > 0) {
                    owned = new ObjectHandleImpl[objectMonitors.size()];
                    for (int i = 0; i < owned.length; ++i) {
                        owned[i] = new ObjectHandleImpl(objectMonitors.get(i));
                    }
                }
            }
            catch (IncompatibleThreadStateException e) {
                Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)thread.virtualMachine().getTraceContext()).warn((Throwable)e, () -> "Thread \"" + this.name + "\" in incompatible state");
            }
        }
        this.contendedMonitor = contended;
        this.waitingMonitor = waiting;
        this.ownedMonitors = owned;
        this.isDaemon = manager.isDaemonThread(thread);
        this.group = new ThreadGroupHandleImpl(this.ref.threadGroup());
        this.isSystem = this.group.getParent() == null && "system".equals(this.group.getName());
    }

    public void setBreakpointsHit(Breakpoint[] breakpoints) {
        this.breakpoints = breakpoints;
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public boolean isStepping() {
        return this.isStepping;
    }

    @Override
    public boolean hasEndedStep() {
        return this.hasEndedStep;
    }

    public void setStepping(boolean stepping) {
        this.isStepping = stepping;
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }

    @Override
    public boolean isSystem() {
        return this.isSystem;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FrameHandle[] getFrames() {
        return this.frames;
    }

    public void suspendImpl() {
        this.ref.suspend();
    }

    public void resumeByVmImpl() {
        while (this.ref.suspendCount() > 1) {
            this.ref.resume();
        }
    }

    public void resumeImpl() {
        this.ref.resume();
    }

    public ThreadReference getReference() {
        return this.ref;
    }

    public ThreadManager getThreadManager() {
        return this.manager;
    }

    public ObjectReference getException() {
        return this.exception;
    }

    public void setException(ObjectReference exception) {
        this.exception = exception;
    }

    @Override
    public void suspend() {
        this.manager.suspendThread(this);
    }

    @Override
    public void resume() {
        this.ref.setStackTracker(new StackTracker());
        this.manager.resumeThread(this);
    }

    @Override
    public Breakpoint[] getBreakpointsHit() {
        return this.breakpoints;
    }

    @Override
    public void stepMinInto() {
        this.ref.setStackTracker(new StackTracker());
        this.manager.stepThread(this, -1, 1);
    }

    @Override
    public void stepInto() {
        this.ref.setStackTracker(new StackTracker());
        this.manager.stepThread(this, -2, 1);
    }

    @Override
    public void stepMinOver() {
        this.setStackTrackerForStepOver();
        this.manager.stepThread(this, -1, 2);
    }

    @Override
    public void stepOver() {
        this.setStackTrackerForStepOver();
        this.manager.stepThread(this, -2, 2);
    }

    private void setStackTrackerForStepOver() {
        MethodHandleImpl method;
        TrackingStackCreator tsc;
        DebuggerImpl debugger = this.manager.getDebugger();
        if (this.isSuspended && debugger.includeReturnValues() && this.frames != null && this.frames.length > 0 && (tsc = (method = (MethodHandleImpl)this.frames[0].getMethodHandle()).getTrackingStackCreator()) != null) {
            int bci = this.frames[0].getBci();
            int[] bcis = method.getBcisOnSameLine(bci);
            this.setStackTracker(StackTrackerHelper.getStackTrackerForBcis(tsc, bcis, false, debugger));
        }
    }

    @Override
    public void stepOut() {
        this.ref.setStackTracker(new StackTracker());
        this.manager.stepThread(this, -2, 3);
    }

    @Override
    public void refresh() {
        assert (this.isSuspended == this.ref.isSuspended());
        this.refreshFrames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFrames() {
        FrameHandleImpl[] tmpFrames = null;
        if (this.isSuspended) {
            int maxFrames = 400;
            ExpressionEvaluationManager expressionManager = this.manager.getExpressionManager();
            Lock lock = expressionManager.getEvaluationLock(this.getId());
            expressionManager.lockEvaluationLock(lock);
            try {
                int iter = 0;
                while (true) {
                    ++iter;
                    try {
                        int frameCount = this.ref.frameCount();
                        if (frameCount <= 400) {
                            tmpFrames = new FrameHandleImpl[this.ref.frameCount()];
                            this.ref.frames();
                            for (int i = 0; i < tmpFrames.length; ++i) {
                                tmpFrames[i] = new FrameHandleImpl(this, this.ref.frame(i));
                            }
                        } else {
                            tmpFrames = new FrameHandleImpl[401];
                            this.ref.frames(0, 201);
                            for (int i = 0; i < tmpFrames.length; ++i) {
                                int actualIndex;
                                if (i < 200) {
                                    actualIndex = i;
                                } else {
                                    if (i == 200) {
                                        int omitted = frameCount - 200 - 200;
                                        tmpFrames[i] = new OmittingFrameHandleImpl(this, this.ref.frame(i), omitted);
                                        this.ref.frames(frameCount - 200, 200);
                                        continue;
                                    }
                                    assert (i > 200);
                                    actualIndex = frameCount - 200 + (i - 200 - 1);
                                }
                                tmpFrames[i] = new FrameHandleImpl(this, this.ref.frame(actualIndex));
                            }
                        }
                    }
                    catch (IncompatibleThreadStateException e) {
                        Tracer tracer = Trace.get((String)"com.sap.jvm.debugging.core.types", (Object)this.ref.virtualMachine().getTraceContext());
                        if (iter >= 10) {
                            tracer.error((Throwable)e, "Aborting refreshing frames of thread \"%s\" after %d iterations", new Object[]{this.name, iter});
                            tmpFrames = null;
                            break;
                        }
                        tracer.warn((Throwable)e, "Thread \"%s\" in incompatible state while setting frames (iteration %d)", new Object[]{this.name, iter});
                        continue;
                    }
                    break;
                }
            }
            finally {
                expressionManager.unlockEvaluationLock(lock);
            }
        }
        if (tmpFrames == null) {
            tmpFrames = EMPTY_FRAMES;
        }
        this.frames = tmpFrames;
    }

    @Override
    public ObjectHandleImpl getContendedMonitor() {
        return this.contendedMonitor;
    }

    @Override
    public ObjectHandleImpl getWaitingMonitor() {
        return this.waitingMonitor;
    }

    public ObjectHandleImpl[] getOwnedMonitors() {
        return this.ownedMonitors.length > 0 ? (ObjectHandleImpl[])this.ownedMonitors.clone() : this.ownedMonitors;
    }

    @Override
    public boolean canAccessStack() {
        if (this.hasEndedStep) {
            return true;
        }
        for (Breakpoint bp : this.breakpoints) {
            if (!(bp instanceof LineBreakpoint) || !(bp instanceof MethodBreakpoint)) continue;
            return true;
        }
        return false;
    }

    public void setStackTracker(StackTracker tracker) {
        this.ref.setStackTracker(tracker);
    }

    public StackTracker getStackTracker(FrameHandle frame) {
        if (this.frames.length == 0 || this.frames[0] != frame) {
            return null;
        }
        StackTracker result = this.ref.getStackTracker();
        if (result == null) {
            return null;
        }
        if (result.getStackDepth() != this.frames.length) {
            return null;
        }
        if (result.getMethodId() != this.frames[0].getMethodHandle().getMethodId()) {
            return null;
        }
        return result;
    }

    public boolean equalsLocation(ThreadHandleImpl other) {
        if (this.frames.length != other.frames.length) {
            return false;
        }
        for (int i = 0; i < this.frames.length; ++i) {
            if (this.frames[i].equalsLocation(other.frames[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public ThreadGroupHandle getThreadGroup() {
        return this.group;
    }

    @Override
    public boolean equalsThread(ThreadHandle other) {
        if (other instanceof ThreadHandleImpl && this.equals(other)) {
            ThreadHandleImpl thread = (ThreadHandleImpl)other;
            if (this.isSuspended != thread.isSuspended || !this.equalsLocation(thread) || this.breakpoints.length != thread.breakpoints.length || !Arrays.equals(this.ownedMonitors, thread.ownedMonitors)) {
                return false;
            }
            for (int i = 0; i < this.breakpoints.length; ++i) {
                if (this.breakpoints[i].toString().equals(thread.breakpoints[i].toString())) continue;
                return false;
            }
            if (this.contendedMonitor == null && thread.contendedMonitor != null || this.contendedMonitor != null && !this.contendedMonitor.equals(thread.contendedMonitor)) {
                return false;
            }
            return (this.waitingMonitor != null || thread.waitingMonitor == null) && (this.waitingMonitor == null || this.waitingMonitor.equals(thread.waitingMonitor));
        }
        return false;
    }

    public String toString() {
        return this.getName() + " (" + this.getId() + ")";
    }
}

