/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.types;

import com.sap.jvm.debugging.impl.types.ArrayHandleImpl;
import com.sap.jvm.debugging.impl.types.BooleanHandleImpl;
import com.sap.jvm.debugging.impl.types.ByteHandleImpl;
import com.sap.jvm.debugging.impl.types.CharacterHandleImpl;
import com.sap.jvm.debugging.impl.types.DoubleHandleImpl;
import com.sap.jvm.debugging.impl.types.FloatHandleImpl;
import com.sap.jvm.debugging.impl.types.IntegerHandleImpl;
import com.sap.jvm.debugging.impl.types.LongHandleImpl;
import com.sap.jvm.debugging.impl.types.ObjectHandleImpl;
import com.sap.jvm.debugging.impl.types.ShortHandleImpl;
import com.sap.jvm.debugging.impl.types.StringHandleImpl;
import com.sap.jvm.debugging.impl.types.VoidHandleImpl;
import com.sap.jvm.debugging.types.ArrayHandle;
import com.sap.jvm.debugging.types.BooleanHandle;
import com.sap.jvm.debugging.types.ByteHandle;
import com.sap.jvm.debugging.types.CharacterHandle;
import com.sap.jvm.debugging.types.DoubleHandle;
import com.sap.jvm.debugging.types.FloatHandle;
import com.sap.jvm.debugging.types.IntegerHandle;
import com.sap.jvm.debugging.types.LongHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.ShortHandle;
import com.sap.jvm.debugging.types.StringHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.debugging.types.VoidHandle;
import com.sap.jvm.jdi.ArrayReference;
import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.ByteValue;
import com.sap.jvm.jdi.CharValue;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.DoubleValue;
import com.sap.jvm.jdi.FloatValue;
import com.sap.jvm.jdi.IntegerValue;
import com.sap.jvm.jdi.LongValue;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.PrimitiveValue;
import com.sap.jvm.jdi.ShortValue;
import com.sap.jvm.jdi.StringReference;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.VoidValue;

public final class ValueHelper {
    public static ValueHandle convert(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ArrayReference) {
            return new ArrayHandleImpl((ArrayReference)value);
        }
        if (value instanceof StringReference) {
            return new StringHandleImpl((StringReference)value);
        }
        if (value instanceof ObjectReference) {
            return new ObjectHandleImpl((ObjectReference)value);
        }
        if (value instanceof VoidValue) {
            return new VoidHandleImpl();
        }
        if (value instanceof BooleanValue) {
            return new BooleanHandleImpl(((PrimitiveValue)value).booleanValue());
        }
        if (value instanceof ByteValue) {
            return new ByteHandleImpl(((PrimitiveValue)value).byteValue());
        }
        if (value instanceof CharValue) {
            return new CharacterHandleImpl(((PrimitiveValue)value).charValue());
        }
        if (value instanceof ShortValue) {
            return new ShortHandleImpl(((PrimitiveValue)value).shortValue());
        }
        if (value instanceof IntegerValue) {
            return new IntegerHandleImpl(((PrimitiveValue)value).intValue());
        }
        if (value instanceof LongValue) {
            return new LongHandleImpl(((PrimitiveValue)value).longValue());
        }
        if (value instanceof DoubleValue) {
            return new DoubleHandleImpl(((PrimitiveValue)value).doubleValue());
        }
        assert (value instanceof FloatValue);
        return new FloatHandleImpl(((PrimitiveValue)value).floatValue());
    }

    public static Value convert(VirtualMachine vm, ValueHandle handle) {
        if (handle == null) {
            return null;
        }
        if (handle instanceof BooleanHandle) {
            return vm.mirrorOf(((BooleanHandle)handle).get());
        }
        if (handle instanceof ByteHandle) {
            return vm.mirrorOf(((ByteHandle)handle).get());
        }
        if (handle instanceof CharacterHandle) {
            return vm.mirrorOf(((CharacterHandle)handle).get());
        }
        if (handle instanceof ShortHandle) {
            return vm.mirrorOf(((ShortHandle)handle).get());
        }
        if (handle instanceof IntegerHandle) {
            return vm.mirrorOf(((IntegerHandle)handle).get());
        }
        if (handle instanceof LongHandle) {
            return vm.mirrorOf(((LongHandle)handle).get());
        }
        if (handle instanceof DoubleHandle) {
            return vm.mirrorOf(((DoubleHandle)handle).get());
        }
        if (handle instanceof FloatHandle) {
            return vm.mirrorOf(((FloatHandle)handle).get());
        }
        if (handle instanceof StringHandle) {
            return vm.mirrorOf(((StringHandle)handle).get());
        }
        if (handle instanceof ArrayHandle) {
            return ((ArrayHandleImpl)handle).object();
        }
        if (handle instanceof ObjectHandle) {
            return ((ObjectHandleImpl)handle).object();
        }
        if (handle instanceof VoidHandle) {
            return vm.mirrorOfVoid();
        }
        throw new IllegalArgumentException("Unknown handle: " + handle);
    }

    public static Type getBasicType(VirtualMachine vm, String type) {
        if (type.startsWith("[") || type.startsWith("L")) {
            return ((ClassType)vm.mirrorOf("").type()).superclass();
        }
        if (type.equals("Z")) {
            return vm.mirrorOf(false).type();
        }
        if (type.equals("B")) {
            return vm.mirrorOf((byte)0).type();
        }
        if (type.equals("S")) {
            return vm.mirrorOf((short)0).type();
        }
        if (type.equals("C")) {
            return vm.mirrorOf('A').type();
        }
        if (type.equals("I")) {
            return vm.mirrorOf(0).type();
        }
        if (type.equals("J")) {
            return vm.mirrorOf(0L).type();
        }
        if (type.equals("F")) {
            return vm.mirrorOf(0.0f).type();
        }
        if (type.equals("D")) {
            return vm.mirrorOf(0.0).type();
        }
        return null;
    }
}

