/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import com.sap.jvm.debugging.presentation.LogicalStructureDefinition;
import com.sap.jvm.debugging.presentation.ThreadRegistry;
import com.sap.jvm.debugging.presentation.Variable;
import com.sap.jvm.debugging.presentation.VariableTreeNode;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.ArrayVariable;
import com.sap.jvm.debugging.presentation.impl.ObjectVariable;
import com.sap.jvm.debugging.presentation.impl.PrimitiveVariable;
import com.sap.jvm.debugging.presentation.impl.SyntheticArrayVariable;
import com.sap.jvm.debugging.presentation.impl.VariableHelper;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.debugging.types.VariableHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractVariableTreeModel {
    private static final TreeNode[] NO_CHILDREN = new TreeNode[0];
    protected static final String SYNTHETIC_VARIABLE_PREFIX = "<";
    protected static final String SYNTHETIC_VARIABLE_SUFFIX = ">";
    private static final String NO_METHOD = "<none>";
    private TreeNode[] unfilteredRoots = NO_CHILDREN;
    private TreeNode[] roots = NO_CHILDREN;
    private Set<TreeNode> selection = new HashSet<TreeNode>();
    private long threadId = 0L;
    private int frameIndex = -1;
    private String methodName = "<none>";
    private boolean showStatics = false;
    private boolean showConstants = false;
    private boolean showSynthetics = true;
    private boolean showLogicalStructures = false;
    private boolean showReturnValues = true;
    private final Map<String, LogicalStructureDefinition> logicalStructureDefinitions = new HashMap<String, LogicalStructureDefinition>();
    private final Map<String, LogicalStructureDefinition> logicalStructureDefinitionsWithSubtypes = new HashMap<String, LogicalStructureDefinition>();
    private final ThreadRegistry threadRegistry;
    private final List<Variable> retainedLogicalValues = new ArrayList<Variable>();
    private final Map<String, String> detailFormatters = new HashMap<String, String>();
    private final Map<String, String> detailFormattersView = Collections.unmodifiableMap(this.detailFormatters);

    protected AbstractVariableTreeModel(ThreadRegistry threadRegistry) {
        this.threadRegistry = threadRegistry;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int getRootCount() {
        return this.roots.length;
    }

    public TreeNode getRoot(int index) {
        return this.roots[index];
    }

    public void update(long thread, int frame, FrameHandle frameHandle) {
        Memento memento;
        String newMethodName;
        ArrayList<Variable> toBeReleased = new ArrayList<Variable>(this.retainedLogicalValues);
        this.retainedLogicalValues.clear();
        TreeNode[] oldRoots = NO_CHILDREN;
        Set oldSelection = null;
        String string = newMethodName = frameHandle == null ? NO_METHOD : frameHandle.getMethodHandle().toString();
        if (this.methodName != NO_METHOD) {
            this.saveOldState(this.methodName, new Memento(this.unfilteredRoots, this.selection));
        }
        if ((memento = this.retrieveOldState(newMethodName)) != null) {
            oldRoots = memento.oldRoots;
            oldSelection = memento.oldSelection;
        }
        this.unfilteredRoots = NO_CHILDREN;
        this.roots = NO_CHILDREN;
        this.selection.clear();
        if (frameHandle != null) {
            ArrayList<TreeNode> rootList = new ArrayList<TreeNode>();
            VariableHandle[] variables = this.getVariables(frameHandle, oldRoots);
            ArrayList<TreeNode> nodes2Expand = new ArrayList<TreeNode>();
            HashMap<TreeNode, Integer> nodes2Index = new HashMap<TreeNode, Integer>();
            for (VariableHandle var : variables) {
                Variable v = VariableHelper.convert(var.getName(), var.getValue(), var.getTypeName(), false, false, this.getVisibilityType(var.getName()));
                TreeNode node = new TreeNode(null, v);
                rootList.add(node);
                nodes2Expand.add(node);
                nodes2Index.put(node, rootList.size() - 1);
            }
            this.unfilteredRoots = rootList.toArray(new TreeNode[rootList.size()]);
            this.expandNodes(nodes2Expand, nodes2Index, oldRoots, oldSelection);
        }
        this.threadId = thread;
        this.frameIndex = frame;
        this.methodName = newMethodName;
        this.filter(this.showStatics, this.showConstants, this.showSynthetics, this.showLogicalStructures, this.showReturnValues);
        for (Variable var : toBeReleased) {
            var.release();
        }
    }

    protected abstract void saveOldState(String var1, Memento var2);

    protected abstract Memento retrieveOldState(String var1);

    protected abstract VariableHandle[] getVariables(FrameHandle var1, TreeNode[] var2);

    protected abstract VisibilityType getVisibilityType(String var1);

    private void expandNodes(List<TreeNode> nodes2Expand, Map<TreeNode, Integer> nodes2Index, TreeNode[] oldRoots, Set<TreeNode> oldSelection) {
        HashMap<TreeNode, TreeNode> new2OldParent = new HashMap<TreeNode, TreeNode>();
        HashMap<TreeNode, TreeNode[]> parent2Child = new HashMap<TreeNode, TreeNode[]>();
        TreeNode[] oldRootsArray = oldRoots;
        parent2Child.put(null, oldRootsArray);
        while (!nodes2Expand.isEmpty()) {
            TreeNode[] tmpNodes = nodes2Expand.toArray(new TreeNode[nodes2Expand.size()]);
            nodes2Expand.clear();
            for (TreeNode node : tmpNodes) {
                int i;
                int index = nodes2Index.remove(node);
                TreeNode oldNode = null;
                TreeNode oldParent = (TreeNode)new2OldParent.get(node);
                TreeNode[] oldParentsChildren = (TreeNode[])parent2Child.get(oldParent);
                if (oldParentsChildren == null) {
                    parent2Child.put(oldParent, oldParent.unfilteredChildren);
                    oldParentsChildren = oldParent.unfilteredChildren;
                }
                if (index >= 0 && index < oldParentsChildren.length) {
                    oldNode = oldParentsChildren[index];
                    if (!node.value.getName().equals(oldNode.value.getName())) {
                        oldNode = null;
                    }
                }
                if (oldNode == null && node.value.getName().startsWith(SYNTHETIC_VARIABLE_PREFIX)) {
                    TreeNode n;
                    for (i = index - 1; i >= 0; --i) {
                        if (i >= oldParentsChildren.length) continue;
                        n = oldParentsChildren[i];
                        if (node.value.getName().equals(n.value.getName())) {
                            oldNode = n;
                            break;
                        }
                        if (!n.value.getName().startsWith(SYNTHETIC_VARIABLE_PREFIX)) break;
                    }
                    for (i = index + 1; oldNode == null && i < oldParentsChildren.length; ++i) {
                        n = oldParentsChildren[i];
                        if (!node.value.getName().equals(n.value.getName())) continue;
                        oldNode = n;
                        break;
                    }
                }
                if (oldNode != null) {
                    if (oldNode.isExpanded()) {
                        node.expand();
                        for (i = 0; i < node.unfilteredChildren.length; ++i) {
                            TreeNode child = node.unfilteredChildren[i];
                            new2OldParent.put(child, oldNode);
                            nodes2Expand.add(child);
                            nodes2Index.put(child, i);
                        }
                    }
                    if (oldNode.isSelected()) {
                        assert (oldSelection.contains(oldNode));
                        node.select();
                    }
                }
                new2OldParent.remove(node);
            }
        }
        assert (nodes2Index.isEmpty());
    }

    public void filter(boolean statics, boolean constants, boolean synthetics, boolean logicals, boolean returnValues) {
        boolean logicalStructureChange = this.showLogicalStructures != logicals;
        boolean returnValueChange = this.showReturnValues != returnValues;
        this.showStatics = statics;
        this.showConstants = constants;
        this.showSynthetics = synthetics;
        this.showLogicalStructures = logicals;
        this.showReturnValues = returnValues;
        this.roots = this.filter(this.unfilteredRoots);
        ArrayList<TreeNode> toBeFiltered = new ArrayList<TreeNode>(Arrays.asList(this.roots));
        ArrayList<TreeNode> tmpFiltered = new ArrayList<TreeNode>();
        while (!toBeFiltered.isEmpty()) {
            tmpFiltered.addAll(toBeFiltered);
            toBeFiltered.clear();
            for (int i = 0; i < tmpFiltered.size(); ++i) {
                TreeNode n = (TreeNode)tmpFiltered.get(i);
                n.filter();
                toBeFiltered.addAll(Arrays.asList(n.children));
            }
            tmpFiltered.clear();
        }
        if ((logicalStructureChange || returnValueChange) && this.threadId != 0L) {
            FrameHandle[] frames;
            ThreadHandle thread = this.threadRegistry.get(this.threadId);
            if (thread == null) {
                throw new IllegalStateException("Unknown thread with id " + this.threadId);
            }
            int index = Math.max(0, this.frameIndex);
            if (index >= (frames = thread.getFrames()).length && frames.length != 0) {
                throw new IllegalStateException("Unknown frame index " + this.frameIndex);
            }
            FrameHandle frame = frames.length == 0 ? null : frames[index];
            this.update(this.threadId, this.frameIndex, frame);
        }
    }

    private TreeNode[] filter(TreeNode[] unfiltered) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (int i = 0; i < unfiltered.length; ++i) {
            TreeNode n = unfiltered[i];
            if (n.value.isStatic()) {
                if (n.value.isFinal()) {
                    if (!this.showConstants) {
                        n = null;
                    }
                } else if (!this.showStatics) {
                    n = null;
                }
            }
            if (n != null && !this.showSynthetics && n.value.getName().startsWith(SYNTHETIC_VARIABLE_PREFIX) && n.value.getName().endsWith(SYNTHETIC_VARIABLE_SUFFIX)) {
                n = null;
            }
            if (n == null) continue;
            nodes.add(n);
        }
        return nodes.toArray(new TreeNode[nodes.size()]);
    }

    public void expand(long thread, int frame, VariableTreeNode[] path) {
        TreeNode node = this.findNode(path, path.length);
        if (thread != this.threadId || frame != this.frameIndex || node == null || node.isExpanded()) {
            return;
        }
        node.expand();
    }

    public void collapse(long thread, int frame, VariableTreeNode[] path) {
        TreeNode node = this.findNode(path, path.length);
        if (thread != this.threadId || frame != this.frameIndex || node == null || !node.isExpanded()) {
            return;
        }
        node.collapse();
    }

    public void select(long thread, int frame, VariableTreeNode[] path) {
        TreeNode node = this.findNode(path, path.length);
        if (thread != this.threadId || frame != this.frameIndex || node == null || node.isSelected()) {
            return;
        }
        node.select();
    }

    public void deselect(long thread, int frame, VariableTreeNode[] path) {
        TreeNode node = this.findNode(path, path.length);
        if (thread != this.threadId || frame != this.frameIndex || node == null || !node.isSelected()) {
            return;
        }
        node.deselect();
    }

    public void clearSelection(long thread, int frame) {
        if (thread != this.threadId || frame != this.frameIndex) {
            return;
        }
        for (TreeNode node : this.selection.toArray(new TreeNode[this.selection.size()])) {
            node.deselect();
        }
        assert (this.selection.isEmpty());
    }

    public Variable[] getSelection() {
        Variable[] result = new Variable[this.selection.size()];
        int i = 0;
        for (TreeNode node : this.selection) {
            result[i++] = node.value;
        }
        return result;
    }

    public void setValue(ThreadHandle thread, int frame, VariableTreeNode[] path, String value) {
        this.setValueOrExpression(thread, frame, path, value, false);
    }

    public void setExpression(ThreadHandle thread, int frame, VariableTreeNode[] path, String value) {
        this.setValueOrExpression(thread, frame, path, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueOrExpression(ThreadHandle thread, int frame, VariableTreeNode[] path, String value, boolean isExpression) {
        FrameHandle handle;
        TreeNode parent = this.findNode(path, path.length - 1);
        TreeNode field = this.findNode(path, path.length);
        if (thread == null || thread.getId() != this.threadId || frame != this.frameIndex || field == null) {
            return;
        }
        int f = Math.max(frame, 0);
        FrameHandle[] stack = thread.getFrames();
        FrameHandle frameHandle = handle = stack != null && f >= 0 && f < stack.length ? stack[f] : null;
        if (handle == null) {
            return;
        }
        ValueHandle v = null;
        if (isExpression) {
            try {
                VariableHandle expression = handle.evaluateExpression(value, true);
                v = expression.getValue();
            }
            finally {
                thread.refresh();
                handle = thread.getFrames()[f];
            }
        }
        if (parent == null) {
            assert (Arrays.asList(this.roots).contains(field));
            handle = this.setRootValue(value, v, field, f, handle, isExpression);
        } else {
            int index = -1;
            for (int i = 0; i < parent.unfilteredChildren.length; ++i) {
                if (parent.unfilteredChildren[i] != field) continue;
                index = i;
                break;
            }
            if (index < 0) {
                throw new IllegalArgumentException("Field not found: " + field.value.getName());
            }
            if (parent.value instanceof ObjectVariable) {
                ObjectVariable parentVar = (ObjectVariable)parent.value;
                if (!isExpression) {
                    v = field.value.parse(handle.getMirror(), value);
                }
                parentVar.setField(index, v, isExpression);
            } else {
                Variable parentVar = parent.value;
                if (parentVar instanceof SyntheticArrayVariable) {
                    SyntheticArrayVariable part = (SyntheticArrayVariable)parentVar;
                    parentVar = part.getArray();
                    index += part.getOffset();
                }
                ArrayVariable array = (ArrayVariable)parentVar;
                if (!isExpression) {
                    v = field.value.parse(handle.getMirror(), value);
                }
                array.setField(index, v, isExpression);
            }
        }
        this.update(this.threadId, this.frameIndex, handle);
    }

    protected abstract FrameHandle setRootValue(String var1, ValueHandle var2, TreeNode var3, int var4, FrameHandle var5, boolean var6);

    private TreeNode findNode(VariableTreeNode[] path, int length) {
        assert (length <= path.length);
        TreeNode current = null;
        TreeNode[] children = this.roots;
        for (int i = 0; i < length; ++i) {
            VariableTreeNode target = path[i];
            if (target.getIndex() < 0 || target.getIndex() >= children.length) {
                return null;
            }
            current = children[target.getIndex()];
            if (!target.getName().equals(current.value.getName()) || target.isSynthetic() != current.value.isSynthetic() || !target.isSynthetic() && target.getObjectId() != current.value.getObjectId()) {
                return null;
            }
            children = current.children;
        }
        return current;
    }

    public void addLogicalStructure(LogicalStructureDefinition definition) {
        ArrayList<String> expressions = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        String returnString = "return ";
        boolean adapted = false;
        for (int i = 0; i < definition.getNumberOfExpressions(); ++i) {
            if (definition.getExpression(i).startsWith("return ")) {
                expressions.add(definition.getExpression(i).substring("return ".length()));
                adapted = true;
            } else {
                expressions.add(definition.getExpression(i));
            }
            names.add(definition.getExpressionName(i));
        }
        LogicalStructureDefinition def = definition;
        if (adapted) {
            def = new LogicalStructureDefinition(definition.getClassName(), definition.appliesToSubtypes(), names.toArray(new String[names.size()]), expressions.toArray(new String[expressions.size()]));
        }
        this.logicalStructureDefinitions.put(def.getClassName(), def);
        if (def.appliesToSubtypes()) {
            this.logicalStructureDefinitionsWithSubtypes.put(def.getClassName(), def);
        }
    }

    public void removeLogicalStructure(String className) {
        assert (this.logicalStructureDefinitions.containsKey(className));
        this.logicalStructureDefinitions.remove(className);
        this.logicalStructureDefinitionsWithSubtypes.remove(className);
    }

    public LogicalStructureDefinition[] getLogicalStructures() {
        return this.logicalStructureDefinitions.values().toArray(new LogicalStructureDefinition[this.logicalStructureDefinitions.size()]);
    }

    public void addDetailFormatters(Map<String, String> class2Expression) {
        this.detailFormatters.putAll(class2Expression);
    }

    public void removeDetailFormatters(String[] classNames) {
        for (String name : classNames) {
            this.detailFormatters.remove(name);
        }
    }

    public Map<String, String> getDetailFormatters() {
        return this.detailFormattersView;
    }

    static /* synthetic */ TreeNode[] access$700() {
        return NO_CHILDREN;
    }

    protected static class Memento {
        private final TreeNode[] oldRoots;
        private final Set<TreeNode> oldSelection;

        private Memento(TreeNode[] oldRoots, Set<TreeNode> oldSelection) {
            this.oldRoots = oldRoots;
            this.oldSelection = new HashSet<TreeNode>(oldSelection);
        }
    }

    public class TreeNode {
        private static final int EXPANDED = 1;
        private static final int SELECTED = 2;
        private static final int MAY_HAVE_ANY_CHILDREN = 4;
        private static final int HAS_CHILDREN = 8;
        private static final int MAY_HAVE_STATIC_CHILDREN = 16;
        private static final int MAY_HAVE_NON_STATIC_CHILDREN = 32;
        private static final int MAY_HAVE_CONSTANT_CHILDREN = 64;
        private Variable value;
        private int state;
        private TreeNode[] unfilteredChildren = AbstractVariableTreeModel.access$700();
        private TreeNode[] children = AbstractVariableTreeModel.access$700();

        public TreeNode(TreeNode parent, Variable value) {
            this.value = value;
            this.state = value.mayHaveFields() ? 4 | (value.hasStaticFields() ? 16 : 0) | (value.hasInstanceFields() ? 32 : 0) | (value.hasConstantFields() ? 64 : 0) : 0;
        }

        public void expand() {
            if (this.isExpanded() || !this.mayHaveAnyChildren() && !this.hasChildren()) {
                return;
            }
            if (this.mayHaveAnyChildren()) {
                assert (!this.hasChildren());
                Variable valueVar = this.value;
                int fieldCount = valueVar.getFieldCount();
                Variable[] logicalMultiStructure = null;
                if (AbstractVariableTreeModel.this.showLogicalStructures && valueVar instanceof ObjectVariable) {
                    ObjectVariable objectVar = (ObjectVariable)valueVar;
                    LogicalStructureDefinition definition = (LogicalStructureDefinition)AbstractVariableTreeModel.this.logicalStructureDefinitions.get(objectVar.object().getTypeName());
                    if (definition == null && AbstractVariableTreeModel.this.logicalStructureDefinitionsWithSubtypes.size() > 0) {
                        definition = this.getLogicalStructureWithSubtypes(objectVar.object());
                    }
                    if (definition != null) {
                        assert (definition.getNumberOfExpressions() >= 1);
                        ThreadHandle thread = AbstractVariableTreeModel.this.threadRegistry.get(AbstractVariableTreeModel.this.threadId);
                        assert (thread.isSuspended());
                        if (definition.getNumberOfExpressions() == 1) {
                            VariableHandle expressionResult = thread.getFrames()[0].evaluateExpressionWithContext(definition.getExpression(0), objectVar.object(), false);
                            expressionResult.getValue().retain();
                            thread.refresh();
                            String name = definition.getExpressionName(0);
                            if (name.length() == 0) {
                                name = definition.getExpression(0);
                            }
                            Variable resultVar = VariableHelper.convert(name, expressionResult.getValue(), expressionResult.getTypeName(), false, false, VisibilityType.PACKAGE_PRIVATE);
                            AbstractVariableTreeModel.this.retainedLogicalValues.add(resultVar);
                            if (resultVar instanceof PrimitiveVariable) {
                                logicalMultiStructure = new Variable[]{resultVar};
                                fieldCount = logicalMultiStructure.length;
                            } else {
                                valueVar = resultVar;
                                fieldCount = valueVar.getFieldCount();
                            }
                        } else {
                            logicalMultiStructure = new Variable[definition.getNumberOfExpressions()];
                            fieldCount = definition.getNumberOfExpressions();
                            for (int i = 0; i < logicalMultiStructure.length; ++i) {
                                VariableHandle expressionResult = thread.getFrames()[0].evaluateExpressionWithContext(definition.getExpression(i), objectVar.object(), false);
                                expressionResult.getValue().retain();
                                thread.refresh();
                                logicalMultiStructure[i] = VariableHelper.convert(definition.getExpressionName(i), expressionResult.getValue(), expressionResult.getTypeName(), false, false, VisibilityType.PACKAGE_PRIVATE);
                                AbstractVariableTreeModel.this.retainedLogicalValues.add(logicalMultiStructure[i]);
                            }
                        }
                    }
                }
                if (fieldCount > 0) {
                    if (logicalMultiStructure != null) {
                        this.unfilteredChildren = new TreeNode[logicalMultiStructure.length];
                        for (int i = 0; i < fieldCount; ++i) {
                            this.unfilteredChildren[i] = new TreeNode(this, (Variable)logicalMultiStructure[i]);
                        }
                    } else if (valueVar instanceof ArrayVariable && fieldCount > 100) {
                        ArrayVariable array = (ArrayVariable)valueVar;
                        int stride = ArrayVariable.calculateChildStride(0, fieldCount);
                        int size = fieldCount / stride;
                        if (size * stride < fieldCount) {
                            ++size;
                        }
                        this.unfilteredChildren = new TreeNode[size];
                        for (int i = 0; i < size; ++i) {
                            int high = (i + 1) * stride;
                            if (high > fieldCount) {
                                high = fieldCount;
                            }
                            SyntheticArrayVariable var = new SyntheticArrayVariable(array, i * stride, high);
                            this.unfilteredChildren[i] = new TreeNode(this, var);
                        }
                    } else {
                        this.unfilteredChildren = new TreeNode[fieldCount];
                        for (int i = 0; i < fieldCount; ++i) {
                            Variable field = valueVar.getField(i);
                            this.unfilteredChildren[i] = new TreeNode(this, field);
                        }
                    }
                    this.filter();
                }
                this.state &= 0xFFFFFFFB;
                this.state &= 0xFFFFFFEF;
                this.state &= 0xFFFFFFDF;
                this.state &= 0xFFFFFFBF;
                if (this.children.length > 0) {
                    this.state |= 8;
                }
            }
            if (this.hasChildren()) {
                this.state |= 1;
            }
        }

        public void collapse() {
            assert (this.isExpanded());
            if (!this.isExpanded()) {
                return;
            }
            this.state &= 0xFFFFFFFE;
        }

        public void select() {
            assert (!this.isSelected());
            if (this.isSelected()) {
                return;
            }
            assert (!AbstractVariableTreeModel.this.selection.contains(this));
            this.state |= 2;
            AbstractVariableTreeModel.this.selection.add(this);
            assert (AbstractVariableTreeModel.this.selection.contains(this));
        }

        public void deselect() {
            assert (this.isSelected());
            if (!this.isSelected()) {
                return;
            }
            assert (AbstractVariableTreeModel.this.selection.contains(this));
            this.state &= 0xFFFFFFFD;
            AbstractVariableTreeModel.this.selection.remove(this);
            assert (!AbstractVariableTreeModel.this.selection.contains(this));
        }

        public int getChildCount() {
            assert (!this.mayHaveChildren());
            return this.children.length;
        }

        public TreeNode getChild(int index) {
            return this.children[index];
        }

        public Variable getValue() {
            return this.value;
        }

        public boolean isExpanded() {
            return (this.state & 1) != 0;
        }

        public boolean isSelected() {
            return (this.state & 2) != 0;
        }

        public boolean mayHaveChildren() {
            return (this.state & 0x20) != 0 || AbstractVariableTreeModel.this.showStatics && (this.state & 0x10) != 0 || AbstractVariableTreeModel.this.showConstants && (this.state & 0x40) != 0;
        }

        public boolean mayHaveAnyChildren() {
            return (this.state & 4) != 0;
        }

        public boolean hasChildren() {
            return (this.state & 8) != 0;
        }

        private void filter() {
            if (this.unfilteredChildren.length == 0) {
                this.children = this.unfilteredChildren;
                return;
            }
            this.children = AbstractVariableTreeModel.this.filter(this.unfilteredChildren);
            if (this.children.length > 0) {
                this.state |= 8;
            } else {
                this.state &= 0xFFFFFFF7;
                this.state &= 0xFFFFFFFE;
            }
        }

        private LogicalStructureDefinition getLogicalStructureWithSubtypes(ObjectHandle object) {
            ClassHandle[] superClasses;
            for (ClassHandle clazz : superClasses = object.getClassHandle().getAllSuperClassHandles()) {
                LogicalStructureDefinition definition = (LogicalStructureDefinition)AbstractVariableTreeModel.this.logicalStructureDefinitionsWithSubtypes.get(clazz.getDisplayName());
                if (definition == null) continue;
                return definition;
            }
            return null;
        }
    }
}

