/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.presentation.BreakpointNameService;
import com.sap.jvm.debugging.presentation.BreakpointNameWithType;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class BreakpointListModel
implements BreakpointNameService {
    private final Map<BreakpointNameWithType, Breakpoint> breakpoints = new LinkedHashMap<BreakpointNameWithType, Breakpoint>();
    private final List<BreakpointSpecification> specs = new ArrayList<BreakpointSpecification>();
    private final Map<Breakpoint, BreakpointSpecification> breakpoint2Name = new HashMap<Breakpoint, BreakpointSpecification>();

    public BreakpointSpecification[] getBreakpoints() {
        return this.specs.toArray(new BreakpointSpecification[this.breakpoints.size()]);
    }

    public void update(BreakpointSpecification[] bps, Debugger debugger, Breakpoint.ConditionFailureListener l) {
        HashMap<BreakpointNameWithType, Breakpoint> oldBreakpoints = new HashMap<BreakpointNameWithType, Breakpoint>(this.breakpoints);
        HashMap<Breakpoint, BreakpointSpecification> oldMapping = new HashMap<Breakpoint, BreakpointSpecification>(this.breakpoint2Name);
        this.breakpoints.clear();
        this.breakpoint2Name.clear();
        this.specs.clear();
        for (BreakpointSpecification bp : bps) {
            BreakpointNameWithType name = new BreakpointNameWithType(bp.getName(), bp.getType());
            Breakpoint backendBreakpoint = (Breakpoint)oldBreakpoints.remove(name);
            BreakpointSpecification oldKey = (BreakpointSpecification)oldMapping.remove(backendBreakpoint);
            if (oldKey == null && backendBreakpoint != null) {
                assert (false);
                backendBreakpoint.setEnabled(false);
                backendBreakpoint = null;
            }
            if (this.requiresNewBreakpoint(bp, oldKey)) {
                backendBreakpoint.setEnabled(false);
                backendBreakpoint = null;
            }
            if (backendBreakpoint == null) {
                this.createBreakpoint(bp, debugger, l);
                continue;
            }
            this.updateBreakpoint(bp, oldKey, backendBreakpoint);
        }
        for (Breakpoint b : oldBreakpoints.values()) {
            b.setEnabled(false);
        }
    }

    private boolean requiresNewBreakpoint(BreakpointSpecification newBp, BreakpointSpecification oldBp) {
        if (oldBp == null) {
            return false;
        }
        return !newBp.equalNonDefaultAttributes(oldBp);
    }

    private void createBreakpoint(BreakpointSpecification bp, Debugger debugger, Breakpoint.ConditionFailureListener l) {
        Breakpoint b = bp.createBreakpoint(debugger);
        b.addConditionFailureListener(l);
        Breakpoint old = this.breakpoints.put(new BreakpointNameWithType(bp.getName(), bp.getType()), b);
        if (old != null) {
            this.breakpoint2Name.remove(old);
            old.setEnabled(false);
        }
        this.breakpoint2Name.put(b, bp);
        this.specs.add(bp);
    }

    private void updateBreakpoint(BreakpointSpecification newBp, BreakpointSpecification oldBp, Breakpoint backendBp) {
        this.breakpoints.put(new BreakpointNameWithType(newBp.getName(), newBp.getType()), backendBp);
        this.breakpoint2Name.put(backendBp, newBp);
        this.specs.add(newBp);
        if (newBp.getHitCount() != oldBp.getHitCount()) {
            backendBp.setHitCount(newBp.getHitCount());
        }
        if (newBp.hasCondition() != oldBp.hasCondition() || newBp.hasCondition() && (newBp.isBooleanCondition() != oldBp.isBooleanCondition() || !newBp.getCondition().equals(oldBp.getCondition()))) {
            if (newBp.isBooleanCondition()) {
                backendBp.setBooleanCondition(newBp.getCondition());
            } else {
                backendBp.setValueChangeCondition(newBp.getCondition());
            }
        }
        if (!Arrays.equals(newBp.getIgnoredThreads(), oldBp.getIgnoredThreads())) {
            backendBp.setIgnoredThreads(newBp.getIgnoredThreads());
        }
        if (!Arrays.equals(newBp.getIgnoredLocations(), oldBp.getIgnoredLocations())) {
            backendBp.setIgnoredLocations(newBp.getIgnoredLocations());
        }
        if (!Arrays.equals(newBp.getIncludedLocations(), oldBp.getIncludedLocations())) {
            backendBp.setIncludedLocations(newBp.getIncludedLocations());
        }
        if (newBp.isSuspendThread() != oldBp.isSuspendThread()) {
            backendBp.setSuspendsThread(newBp.isSuspendThread());
        }
        if (newBp.isEnabled() != oldBp.isEnabled()) {
            backendBp.setEnabled(newBp.isEnabled());
        }
    }

    @Override
    public BreakpointNameWithType getName(Breakpoint breakpoint) {
        BreakpointSpecification bp = this.breakpoint2Name.get(breakpoint);
        return bp != null ? new BreakpointNameWithType(bp.getName(), bp.getType()) : null;
    }
}

