/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public enum BreakpointType {
    METHOD_ENTRY,
    EXCEPTION,
    ABSOLUTE_METHOD_LINE,
    RELATIVE_METHOD_LINE,
    WATCH_POINT,
    LINE,
    METHOD_BYTE_CODE_INDEX,
    METHOD_EXIT,
    TYPE_LINE;


    public static BreakpointType read(DataInputStream in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 0: {
                return METHOD_ENTRY;
            }
            case 1: {
                return EXCEPTION;
            }
            case 2: {
                return ABSOLUTE_METHOD_LINE;
            }
            case 3: {
                return RELATIVE_METHOD_LINE;
            }
            case 4: {
                return WATCH_POINT;
            }
            case 5: {
                return LINE;
            }
            case 6: {
                return METHOD_BYTE_CODE_INDEX;
            }
            case 7: {
                return METHOD_EXIT;
            }
            case 8: {
                return TYPE_LINE;
            }
        }
        throw new IllegalStateException("Unknown breakpoint type: " + type);
    }

    public void write(DataOutputStream out) throws IOException {
        int type;
        switch (this) {
            case METHOD_ENTRY: {
                type = 0;
                break;
            }
            case EXCEPTION: {
                type = 1;
                break;
            }
            case ABSOLUTE_METHOD_LINE: {
                type = 2;
                break;
            }
            case RELATIVE_METHOD_LINE: {
                type = 3;
                break;
            }
            case WATCH_POINT: {
                type = 4;
                break;
            }
            case LINE: {
                type = 5;
                break;
            }
            case METHOD_BYTE_CODE_INDEX: {
                type = 6;
                break;
            }
            case METHOD_EXIT: {
                type = 7;
                break;
            }
            case TYPE_LINE: {
                type = 8;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown breakpoint type: " + (Object)((Object)this));
            }
        }
        out.writeByte(type);
    }
}

