/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import com.sap.jvm.debugging.presentation.AbstractVariableTreeModel;
import com.sap.jvm.debugging.presentation.LocalVariableTreeModel;
import com.sap.jvm.debugging.presentation.ThreadRegistry;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.StringHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.debugging.types.VariableHandle;
import java.util.ArrayList;
import java.util.List;

public final class ExpressionVariableTreeModel
extends AbstractVariableTreeModel {
    private String expressionToBeAdded = null;
    private String expressionToBeRemoved = null;
    private int expressionRemoveIndex = -1;
    private String newExpressionToBeChanged = null;
    private int expressionChangeIndex = -1;
    private AbstractVariableTreeModel.Memento memento = null;
    private final LocalVariableTreeModel localVariables;
    private boolean[] evaluationFailures;

    public ExpressionVariableTreeModel(LocalVariableTreeModel localVariables, ThreadRegistry threadRegistry) {
        super(threadRegistry);
        this.localVariables = localVariables;
    }

    @Override
    protected void saveOldState(String name, AbstractVariableTreeModel.Memento oldState) {
        this.memento = oldState;
    }

    @Override
    protected AbstractVariableTreeModel.Memento retrieveOldState(String name) {
        return this.memento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addExpression(ThreadHandle thread, int frame, String expression) {
        FrameHandle handle;
        if (thread == null || thread.getId() != this.getThreadId() || frame != this.getFrameIndex()) {
            return false;
        }
        int index = Math.max(frame, 0);
        FrameHandle[] stack = thread.getFrames();
        FrameHandle frameHandle = handle = stack != null && index >= 0 && index < stack.length ? stack[index] : null;
        if (handle == null) {
            return false;
        }
        assert (this.expressionToBeAdded == null);
        try {
            this.expressionToBeAdded = expression;
            this.update(thread.getId(), frame, handle);
            this.localVariables.update(thread.getId(), frame, thread.getFrames()[index]);
        }
        finally {
            this.expressionToBeAdded = null;
        }
        return true;
    }

    public boolean updateExpression(ThreadHandle thread, int frame, int[] expressionIndices) {
        FrameHandle handle;
        if (thread == null || thread.getId() != this.getThreadId() || frame != this.getFrameIndex()) {
            return false;
        }
        int index = Math.max(frame, 0);
        FrameHandle[] stack = thread.getFrames();
        FrameHandle frameHandle = handle = stack != null && index >= 0 && index < stack.length ? stack[index] : null;
        if (handle == null) {
            return false;
        }
        this.update(thread.getId(), frame, handle);
        this.localVariables.update(thread.getId(), frame, thread.getFrames()[index]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeExpression(ThreadHandle thread, int frame, String newExpression, int index) {
        FrameHandle handle;
        if (thread == null || thread.getId() != this.getThreadId() || frame != this.getFrameIndex()) {
            return false;
        }
        int f = Math.max(frame, 0);
        FrameHandle[] stack = thread.getFrames();
        FrameHandle frameHandle = handle = stack != null && f >= 0 && f < stack.length ? stack[f] : null;
        if (handle == null) {
            return false;
        }
        assert (this.newExpressionToBeChanged == null && this.expressionChangeIndex == -1);
        try {
            this.newExpressionToBeChanged = newExpression;
            this.expressionChangeIndex = index;
            this.update(thread.getId(), frame, handle);
            this.localVariables.update(thread.getId(), frame, thread.getFrames()[f]);
        }
        finally {
            this.newExpressionToBeChanged = null;
            this.expressionChangeIndex = -1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeExpression(ThreadHandle thread, int frame, String expression, int index) {
        FrameHandle handle;
        if (thread == null || thread.getId() != this.getThreadId() || frame != this.getFrameIndex()) {
            return false;
        }
        int f = Math.max(frame, 0);
        FrameHandle[] stack = thread.getFrames();
        FrameHandle frameHandle = handle = stack != null && f >= 0 && f < stack.length ? stack[f] : null;
        if (handle == null) {
            return false;
        }
        assert (this.expressionToBeRemoved == null && this.expressionRemoveIndex == -1);
        try {
            this.expressionToBeRemoved = expression;
            this.expressionRemoveIndex = index;
            this.update(thread.getId(), frame, handle);
            this.localVariables.update(thread.getId(), frame, thread.getFrames()[f]);
        }
        finally {
            this.expressionToBeRemoved = null;
            this.expressionRemoveIndex = -1;
        }
        return true;
    }

    @Override
    protected VariableHandle[] getVariables(FrameHandle frameHandle, AbstractVariableTreeModel.TreeNode[] oldRoots) {
        for (AbstractVariableTreeModel.TreeNode old : oldRoots) {
            old.getValue().release();
        }
        ArrayList<VariableHandle> result = new ArrayList<VariableHandle>();
        ThreadHandle thread = frameHandle.getThreadHandle();
        FrameHandle[] frames = thread.getFrames();
        int frameIndex = -1;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] != frameHandle) continue;
            frameIndex = i;
            break;
        }
        if (frameIndex < 0) {
            throw new IllegalStateException("Frame not found in thread");
        }
        FrameHandle handle = frameHandle;
        for (int i = 0; i < oldRoots.length; ++i) {
            if (i == this.expressionRemoveIndex && oldRoots[i].getValue().getName().equals(this.expressionToBeRemoved)) continue;
            VariableHandle var = i != this.expressionChangeIndex ? handle.evaluateExpression(oldRoots[i].getValue().getName(), false) : handle.evaluateExpression(this.newExpressionToBeChanged, false);
            if (var.getValue() != null) {
                var.getValue().retain();
            }
            result.add(var);
            thread.refresh();
            handle = thread.getFrames()[frameIndex];
        }
        if (this.expressionToBeAdded != null) {
            VariableHandle var = handle.evaluateExpression(this.expressionToBeAdded, false);
            if (var.getValue() != null) {
                var.getValue().retain();
            }
            result.add(var);
            thread.refresh();
        }
        this.inspectExpressionResults(result);
        return result.toArray(new VariableHandle[result.size()]);
    }

    @Override
    protected VisibilityType getVisibilityType(String name) {
        return VisibilityType.EXPRESSION_VARIABLE;
    }

    @Override
    protected FrameHandle setRootValue(String value, ValueHandle v, AbstractVariableTreeModel.TreeNode node, int index, FrameHandle frame, boolean throwException) {
        throw new UnsupportedOperationException("Root expressions cannot be set");
    }

    private void inspectExpressionResults(List<VariableHandle> result) {
        this.evaluationFailures = new boolean[result.size()];
        for (int i = 0; i < this.evaluationFailures.length; ++i) {
            String string;
            ValueHandle value = result.get(i).getValue();
            if (!(value instanceof StringHandle)) continue;
            StringHandle stringHandle = (StringHandle)value;
            int errorPrefixLen = "<error(s) during evaluation: ".length();
            int strLen = stringHandle.length();
            if (strLen < errorPrefixLen || !(string = stringHandle.substring(0, errorPrefixLen)).equals("<error(s) during evaluation: ")) continue;
            this.evaluationFailures[i] = true;
        }
    }

    public boolean hasEvaluationFailed(int index) {
        return this.evaluationFailures != null && index >= 0 && index < this.evaluationFailures.length && this.evaluationFailures[index];
    }
}

