/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import com.sap.jvm.debugging.presentation.AbstractVariableTreeModel;
import com.sap.jvm.debugging.presentation.ThreadRegistry;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.debugging.types.VariableHandle;
import java.util.HashMap;
import java.util.Map;

public final class LocalVariableTreeModel
extends AbstractVariableTreeModel {
    private final Map<String, AbstractVariableTreeModel.Memento> method2Memento = new HashMap<String, AbstractVariableTreeModel.Memento>();

    public LocalVariableTreeModel(ThreadRegistry threadRegistry) {
        super(threadRegistry);
    }

    @Override
    protected void saveOldState(String name, AbstractVariableTreeModel.Memento oldState) {
        this.method2Memento.put(name, oldState);
    }

    @Override
    protected AbstractVariableTreeModel.Memento retrieveOldState(String name) {
        return this.method2Memento.get(name);
    }

    @Override
    protected VariableHandle[] getVariables(FrameHandle frameHandle, AbstractVariableTreeModel.TreeNode[] oldRoots) {
        return frameHandle.getVariables();
    }

    @Override
    protected VisibilityType getVisibilityType(String name) {
        if (name.startsWith("<") && name.endsWith(">") || "this".equals(name)) {
            return VisibilityType.PUBLIC;
        }
        return VisibilityType.LOCAL_VARIABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FrameHandle setRootValue(String value, ValueHandle v, AbstractVariableTreeModel.TreeNode node, int index, FrameHandle frame, boolean throwException) {
        String name = node.getValue().getName();
        ValueHandle val = v;
        boolean omitSetting = false;
        if (!throwException) {
            try {
                val = node.getValue().parse(frame.getMirror(), value);
            }
            catch (UnsupportedOperationException e) {
                omitSetting = true;
            }
        }
        if (!omitSetting) {
            try {
                frame.setVariable(name, val, throwException);
            }
            finally {
                frame.getThreadHandle().refresh();
            }
        }
        return frame.getThreadHandle().getFrames()[index];
    }
}

