/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public final class LogicalStructureDefinition {
    private final String className;
    private final boolean appliesToSubtypes;
    private final NamedExpression[] expressions;

    public static LogicalStructureDefinition read(DataInputStream in) throws IOException {
        return new LogicalStructureDefinition(in);
    }

    private LogicalStructureDefinition(DataInputStream in) throws IOException {
        this.className = in.readUTF();
        this.appliesToSubtypes = in.readBoolean();
        int size = in.readInt();
        this.expressions = new NamedExpression[size];
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            String expr = in.readUTF();
            this.expressions[i] = new NamedExpression(name, expr);
        }
    }

    public LogicalStructureDefinition(String className, boolean appliesToSubtypes, String[] names, String[] expressions) {
        assert (names.length == expressions.length);
        if (names.length != expressions.length) {
            throw new IllegalArgumentException("Arrays 'names' (" + names.length + ") and 'exressions' (" + expressions.length + ") must be equal size");
        }
        if (names.length == 0) {
            throw new IllegalArgumentException("Expression length must be greater than 0");
        }
        this.className = className;
        this.appliesToSubtypes = appliesToSubtypes;
        this.expressions = new NamedExpression[names.length];
        for (int i = 0; i < expressions.length; ++i) {
            this.expressions[i] = new NamedExpression(names[i], expressions[i]);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.className);
        out.writeBoolean(this.appliesToSubtypes);
        out.writeInt(this.expressions.length);
        for (int i = 0; i < this.expressions.length; ++i) {
            out.writeUTF(this.expressions[i].name);
            out.writeUTF(this.expressions[i].expression);
        }
    }

    public void print(PrintStream stream) {
        stream.println("    Class name                    : " + this.className);
        stream.println("    Applies to sub types          : " + (this.appliesToSubtypes ? "yes" : "no"));
        for (int i = 0; i < this.expressions.length; ++i) {
            stream.println("    Expression name               : " + this.expressions[i].name);
            stream.println("    Expression                    : " + this.expressions[i].expression);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public boolean appliesToSubtypes() {
        return this.appliesToSubtypes;
    }

    public int getNumberOfExpressions() {
        return this.expressions.length;
    }

    public String getExpressionName(int index) {
        return this.expressions[index].name;
    }

    public String getExpression(int index) {
        return this.expressions[index].expression;
    }

    public int hashCode() {
        return this.className.hashCode() ^ (this.appliesToSubtypes ? 0 : 1) ^ Arrays.hashCode(this.expressions);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LogicalStructureDefinition other = (LogicalStructureDefinition)obj;
        return this.className.equals(other.className) && this.appliesToSubtypes == other.appliesToSubtypes && Arrays.equals(this.expressions, other.expressions);
    }

    private static final class NamedExpression {
        private final String name;
        private final String expression;

        private NamedExpression(String name, String expression) {
            if (name == null || expression == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.expression = expression;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.expression.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NamedExpression other = (NamedExpression)obj;
            return this.name.equals(other.name) && this.expression.equals(other.expression);
        }
    }
}

