/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import com.sap.jvm.debugging.ThreadChanges;
import com.sap.jvm.debugging.presentation.ThreadRegistry;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.ThreadGroupHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ThreadListModel
implements ThreadRegistry {
    private static final ThreadHandle[] EMPTY_THREADS = new ThreadHandle[0];
    private final Map<Long, ThreadHandle> threads = new LinkedHashMap<Long, ThreadHandle>();
    private long selectedThreadId = 0L;
    private int selectedFrameIndex = -1;
    private int selectedByteCodeIndex = -1;
    private final Set<ThreadSelectionChangeListener> listeners = new HashSet<ThreadSelectionChangeListener>();
    private boolean showRunningSystemThreads = false;
    private boolean sendOnlyDeltas = false;
    private final List<ThreadHandle> newThreads = new ArrayList<ThreadHandle>();
    private final List<ThreadHandle> changedThreads = new ArrayList<ThreadHandle>();
    private final List<ThreadHandle> removedThreads = new ArrayList<ThreadHandle>();

    public void update(ThreadChanges change) {
        ThreadHandle oldHandle;
        long oldSelectedThreadId = this.selectedThreadId;
        int oldSelectedFrameIndex = this.selectedFrameIndex;
        int oldSelectedByteCodeIndex = this.selectedByteCodeIndex;
        HashMap<Long, ThreadHandle> oldThreads = new HashMap<Long, ThreadHandle>(this.threads);
        this.newThreads.clear();
        this.changedThreads.clear();
        this.removedThreads.clear();
        for (ThreadHandle t : change.getStartedThreads()) {
            if (this.threads.containsKey(t.getId())) continue;
            if (t.isSuspended() || !this.isSystemThread(t) || this.showRunningSystemThreads) {
                this.newThreads.add(t);
            }
            this.threads.put(t.getId(), t);
        }
        for (ThreadHandle t : change.getStoppedThreads()) {
            assert (this.threads.containsKey(t.getId()));
            if (t.isSuspended() || !this.isSystemThread(t) || this.showRunningSystemThreads) {
                this.removedThreads.add(t);
            }
            this.threads.remove(t.getId());
        }
        for (ThreadHandle t : change.getChangedThreads()) {
            ThreadHandle oldHandle2 = this.threads.get(t.getId());
            this.threads.put(t.getId(), t);
            if (oldHandle2 == null) {
                assert (false);
                if (!t.isSuspended() && this.isSystemThread(t) && !this.showRunningSystemThreads) continue;
                this.newThreads.add(t);
                continue;
            }
            if (t.equalsThread(oldHandle2)) continue;
            if (!this.isSystemThread(t) || this.showRunningSystemThreads) {
                this.changedThreads.add(t);
                continue;
            }
            assert (this.isSystemThread(t));
            if (t.isSuspended() && !oldHandle2.isSuspended()) {
                this.newThreads.add(t);
                continue;
            }
            if (!t.isSuspended() && oldHandle2.isSuspended()) {
                this.removedThreads.add(t);
                continue;
            }
            if (!t.isSuspended()) continue;
            this.changedThreads.add(t);
        }
        ThreadHandle selectedThread = this.threads.get(this.selectedThreadId);
        if (selectedThread == null || selectedThread.getFrames().length == 0) {
            for (ThreadHandle thr : this.changedThreads) {
                FrameHandle[] oldFrames;
                ThreadHandle oldHandle3;
                if (!thr.isSuspended() || thr.getFrames().length <= 0 || (oldHandle3 = (ThreadHandle)oldThreads.get(thr.getId())) != null && oldHandle3.isSuspended() && (oldFrames = oldHandle3.getFrames()).length > 0 && oldFrames[0].toString().equals(thr.getFrames()[0].toString())) continue;
                selectedThread = thr;
                this.selectedThreadId = thr.getId();
                this.selectedFrameIndex = 0;
                this.selectedByteCodeIndex = Math.max(0, thr.getFrames()[0].getBci());
                break;
            }
        }
        if (selectedThread == null) {
            this.selectedThreadId = 0L;
            this.selectedFrameIndex = -1;
            this.selectedByteCodeIndex = -1;
        } else if (selectedThread.getFrames().length <= this.selectedFrameIndex) {
            this.selectedFrameIndex = -1;
            this.selectedByteCodeIndex = selectedThread.getFrames().length > 0 ? Math.max(0, selectedThread.getFrames()[0].getBci()) : -1;
        }
        if (selectedThread != null && this.selectedFrameIndex < 0 && (oldHandle = (ThreadHandle)oldThreads.get(this.selectedThreadId)) != null && oldHandle.getFrames().length == 0) {
            this.selectedFrameIndex = 0;
        }
        if (this.selectedThreadId != oldSelectedThreadId || this.selectedFrameIndex != oldSelectedFrameIndex || this.selectedByteCodeIndex != oldSelectedByteCodeIndex) {
            this.fireSelectionChanged();
        }
    }

    private void update(ThreadHandle[] t) {
        Object oldHandle;
        long oldSelectedThreadId = this.selectedThreadId;
        int oldSelectedFrameIndex = this.selectedFrameIndex;
        int oldSelectedByteCodeIndex = this.selectedByteCodeIndex;
        HashMap<Long, ThreadHandle> oldThreads = new HashMap<Long, ThreadHandle>(this.threads);
        HashMap<Long, ThreadHandle> tmpOldThreads = new HashMap<Long, ThreadHandle>(this.threads);
        this.threads.clear();
        this.newThreads.clear();
        this.changedThreads.clear();
        this.removedThreads.clear();
        for (int i = 0; i < t.length; ++i) {
            this.threads.put(t[i].getId(), t[i]);
            oldHandle = (ThreadHandle)tmpOldThreads.remove(t[i].getId());
            if (oldHandle == null) {
                if (!t[i].isSuspended() && this.isSystemThread(t[i]) && !this.showRunningSystemThreads) continue;
                this.newThreads.add(t[i]);
                continue;
            }
            if (t[i].equalsThread((ThreadHandle)oldHandle)) continue;
            if (!this.isSystemThread(t[i]) || this.showRunningSystemThreads) {
                this.changedThreads.add(t[i]);
                continue;
            }
            if (t[i].isSuspended()) {
                this.newThreads.add(t[i]);
                continue;
            }
            this.removedThreads.add(t[i]);
        }
        this.removedThreads.addAll(tmpOldThreads.values());
        ThreadHandle selectedThread = this.threads.get(this.selectedThreadId);
        if (selectedThread == null || selectedThread.getFrames().length == 0) {
            oldHandle = t;
            int n = ((ThreadHandle[])oldHandle).length;
            for (int i = 0; i < n; ++i) {
                FrameHandle[] oldFrames;
                ThreadHandle oldHandle2;
                ThreadHandle thr = oldHandle[i];
                if (!thr.isSuspended() || thr.getFrames().length <= 0 || (oldHandle2 = (ThreadHandle)oldThreads.get(thr.getId())) != null && oldHandle2.isSuspended() && (oldFrames = oldHandle2.getFrames()).length > 0 && oldFrames[0].toString().equals(thr.getFrames()[0].toString())) continue;
                selectedThread = thr;
                this.selectedThreadId = thr.getId();
                this.selectedFrameIndex = 0;
                this.selectedByteCodeIndex = Math.max(0, thr.getFrames()[0].getBci());
                break;
            }
        }
        if (selectedThread == null) {
            this.selectedThreadId = 0L;
            this.selectedFrameIndex = -1;
            this.selectedByteCodeIndex = -1;
        } else if (selectedThread.getFrames().length <= this.selectedFrameIndex) {
            this.selectedFrameIndex = -1;
            this.selectedByteCodeIndex = selectedThread.getFrames().length > 0 ? Math.max(0, selectedThread.getFrames()[0].getBci()) : -1;
        }
        if (selectedThread != null && this.selectedFrameIndex < 0 && (oldHandle = (ThreadHandle)oldThreads.get(this.selectedThreadId)) != null && oldHandle.getFrames().length == 0) {
            this.selectedFrameIndex = 0;
        }
        if (this.selectedThreadId != oldSelectedThreadId || this.selectedFrameIndex != oldSelectedFrameIndex || this.selectedByteCodeIndex != oldSelectedByteCodeIndex) {
            this.fireSelectionChanged();
        }
    }

    public ThreadHandle[] getAll() {
        return this.getFilteredThreads(this.threads.values());
    }

    private ThreadHandle[] getFilteredThreads(Collection<ThreadHandle> thr) {
        if (this.showRunningSystemThreads) {
            return thr.toArray(new ThreadHandle[thr.size()]);
        }
        ArrayList<ThreadHandle> result = new ArrayList<ThreadHandle>(thr.size());
        for (ThreadHandle handle : thr) {
            if (!handle.isSuspended() && this.isSystemThread(handle)) continue;
            result.add(handle);
        }
        return result.toArray(new ThreadHandle[result.size()]);
    }

    private boolean isSystemThread(ThreadHandle handle) {
        ThreadGroupHandle group = handle.getThreadGroup();
        return group.getParent() == null && "system".equals(group.getName());
    }

    @Override
    public ThreadHandle get(long id) {
        return this.threads.get(id);
    }

    public long getSelectedThread() {
        return this.selectedThreadId;
    }

    public int getSelectedFrame() {
        return this.selectedFrameIndex;
    }

    public void select(long threadId, int frameIndex) {
        this.selectedThreadId = threadId;
        this.selectedFrameIndex = frameIndex;
        ThreadHandle selectedThread = this.threads.get(this.selectedThreadId);
        if (selectedThread == null) {
            this.selectedThreadId = 0L;
            this.selectedFrameIndex = -1;
            this.selectedByteCodeIndex = -1;
        } else {
            FrameHandle[] frames;
            int index = this.selectedFrameIndex;
            if (index < 0) {
                index = 0;
            }
            this.selectedByteCodeIndex = (frames = selectedThread.getFrames()).length > index ? frames[index].getBci() : -1;
        }
        this.fireSelectionChanged();
    }

    public void addSelectionListener(ThreadSelectionChangeListener l) {
        this.listeners.add(l);
    }

    public void removeSelectionListener(ThreadSelectionChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionChanged() {
        FrameHandle frame;
        ThreadHandle selectedThread = this.threads.get(this.selectedThreadId);
        if (selectedThread == null) {
            frame = null;
        } else {
            FrameHandle[] frames;
            int frameIndex = this.selectedFrameIndex;
            if (frameIndex < 0) {
                frameIndex = 0;
            }
            frame = (frames = selectedThread.getFrames()).length > frameIndex ? frames[frameIndex] : null;
        }
        for (ThreadSelectionChangeListener l : this.listeners) {
            l.selectionChanged(this.selectedThreadId, this.selectedFrameIndex, frame);
        }
    }

    public void setShowRunningSystemThreads(boolean showRunningSystemThreads) {
        this.showRunningSystemThreads = showRunningSystemThreads;
    }

    public boolean showRunningSystemThreads() {
        return this.showRunningSystemThreads;
    }

    public void setSendOnlyDeltas(boolean sendOnlyDeltas) {
        this.sendOnlyDeltas = sendOnlyDeltas;
    }

    public boolean sendOnlyDeltas() {
        return this.sendOnlyDeltas;
    }

    public ThreadHandle[] getAddedThreads() {
        if (this.newThreads.isEmpty()) {
            return EMPTY_THREADS;
        }
        return this.newThreads.toArray(new ThreadHandle[this.newThreads.size()]);
    }

    public ThreadHandle[] getChangedThreads() {
        if (this.changedThreads.isEmpty()) {
            return EMPTY_THREADS;
        }
        return this.changedThreads.toArray(new ThreadHandle[this.changedThreads.size()]);
    }

    public ThreadHandle[] getRemovedThreads() {
        if (this.removedThreads.isEmpty()) {
            return EMPTY_THREADS;
        }
        return this.removedThreads.toArray(new ThreadHandle[this.removedThreads.size()]);
    }

    public void clearDelta() {
        this.newThreads.clear();
        this.changedThreads.clear();
        this.removedThreads.clear();
    }

    public static interface ThreadSelectionChangeListener {
        public void selectionChanged(long var1, int var3, FrameHandle var4);
    }
}

