/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public enum VisibilityType {
    LOCAL_VARIABLE,
    EXPRESSION_VARIABLE,
    PUBLIC,
    PROTECTED,
    PACKAGE_PRIVATE,
    PRIVATE;


    public static VisibilityType read(DataInputStream in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 0: {
                return LOCAL_VARIABLE;
            }
            case 1: {
                return EXPRESSION_VARIABLE;
            }
            case 2: {
                return PUBLIC;
            }
            case 3: {
                return PROTECTED;
            }
            case 4: {
                return PACKAGE_PRIVATE;
            }
            case 5: {
                return PRIVATE;
            }
        }
        throw new IllegalStateException("Unknown visibility type: " + type);
    }

    public void write(DataOutputStream out) throws IOException {
        int type;
        switch (this) {
            case LOCAL_VARIABLE: {
                type = 0;
                break;
            }
            case EXPRESSION_VARIABLE: {
                type = 1;
                break;
            }
            case PUBLIC: {
                type = 2;
                break;
            }
            case PROTECTED: {
                type = 3;
                break;
            }
            case PACKAGE_PRIVATE: {
                type = 4;
                break;
            }
            case PRIVATE: {
                type = 5;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown visbility type: " + (Object)((Object)this));
            }
        }
        out.writeByte(type);
    }
}

