/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation.impl;

import com.sap.jvm.debugging.presentation.Variable;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.AbstractVariable;
import com.sap.jvm.debugging.presentation.impl.VariableHelper;
import com.sap.jvm.debugging.types.ArrayHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.jdi.Mirror;
import java.util.Map;

public final class ArrayVariable
extends AbstractVariable {
    public static final int SYNTHETIC_ARRAY_THRESHOLD = 100;
    private final ArrayHandle array;
    private final long id;
    private final String typeName;

    public ArrayVariable(String name, String typeName, ArrayHandle array, boolean isStatic, boolean isFinal, VisibilityType visibility) {
        super(name, isStatic, isFinal, visibility);
        long l;
        this.array = array;
        if (array == null) {
            long l2 = uniqueIdentifier;
            l = l2;
            uniqueIdentifier = l2 + 1L;
        } else {
            l = array.getId();
        }
        this.id = l;
        this.typeName = typeName;
    }

    @Override
    public long getObjectId() {
        return this.id;
    }

    @Override
    public boolean mayHaveFields() {
        return this.array != null && this.array.getLength() > 0;
    }

    @Override
    public boolean hasStaticFields() {
        return false;
    }

    @Override
    public boolean hasInstanceFields() {
        return this.mayHaveFields();
    }

    @Override
    public boolean hasConstantFields() {
        return false;
    }

    @Override
    public int getFieldCount() {
        return this.array == null ? 0 : this.array.getLength();
    }

    @Override
    public Variable getField(int index) {
        return VariableHelper.convert("[" + index + "]", this.array.getValue(index), this.array.getComponentTypeName(), false, false, VisibilityType.PACKAGE_PRIVATE);
    }

    public void setField(int index, ValueHandle value, boolean throwException) {
        this.array.setValue(index, value, throwException);
    }

    @Override
    public boolean isSynthetic() {
        return this.array == null;
    }

    @Override
    public String getValue() {
        if (this.array == null) {
            return "null";
        }
        String type = this.array.getClassHandle().getDisplayName();
        int bracket = type.indexOf(93);
        assert (bracket >= 0 && bracket < type.length());
        return type.substring(0, bracket) + this.array.getLength() + type.substring(bracket) + " (id=" + this.array.getId() + ")";
    }

    @Override
    public ValueHandle parse(Mirror mirror, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toStringEquivalent(ThreadHandle thread, Map<String, String> detailFormatters) {
        if (this.array == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            Variable var = this.getField(i);
            buffer.append(var.toStringEquivalent(thread, detailFormatters));
            if (buffer.length() < 1000) continue;
            buffer.setLength(1000);
            buffer.append("...");
            return buffer.toString();
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static int calculateChildStride(int low, int high) {
        assert (low < high);
        int children = high - low;
        int stride = 1;
        while (children > 100) {
            children /= 100;
            stride *= 100;
        }
        return stride;
    }

    @Override
    public String getDeclaredTypeName() {
        return this.typeName;
    }

    @Override
    public String getConcreteTypeName() {
        return this.array.getTypeName();
    }

    @Override
    public void release() {
        if (this.array != null) {
            this.array.release();
        }
    }
}

