/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation.impl;

import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.PrimitiveVariable;
import com.sap.jvm.debugging.types.ValueFactory;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.jdi.Mirror;

public final class CharVariable
extends PrimitiveVariable {
    private final char value;

    public CharVariable(String name, char value, boolean isStatic, boolean isFinal, VisibilityType visibility) {
        super(name, isStatic, isFinal, visibility);
        this.value = value;
    }

    @Override
    public String getValue() {
        if (this.isPrintableCharacter()) {
            return Character.toString(this.value);
        }
        switch (this.value) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return "\\u" + Integer.toHexString(this.value | 0x10000).substring(1);
    }

    @Override
    public ValueHandle parse(Mirror mirror, String string) {
        if (string.length() == 1) {
            return ValueFactory.create(string.charAt(0));
        }
        assert (string.length() > 1);
        if (string.charAt(0) != '\\') {
            throw new IllegalArgumentException("Character string invalid: " + string);
        }
        switch (string.charAt(1)) {
            case 'b': {
                return ValueFactory.create('\b');
            }
            case 'f': {
                return ValueFactory.create('\f');
            }
            case 'n': {
                return ValueFactory.create('\n');
            }
            case 'r': {
                return ValueFactory.create('\r');
            }
            case 't': {
                return ValueFactory.create('\t');
            }
            case 'u': {
                String hexValue = string.substring(2);
                if (hexValue.trim().length() == 0 || hexValue.length() > 4) {
                    throw new IllegalArgumentException("Character string invalid: " + string);
                }
                return ValueFactory.create((char)Integer.parseInt(hexValue, 16));
            }
        }
        throw new IllegalArgumentException("Character string invalid: " + string);
    }

    private boolean isPrintableCharacter() {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(this.value);
        return this.value != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS && !Character.isISOControl(this.value);
    }

    @Override
    public String getDeclaredTypeName() {
        return Character.TYPE.getName();
    }
}

