/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation.impl;

import com.sap.jvm.debugging.presentation.Variable;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.AbstractVariable;
import com.sap.jvm.debugging.presentation.impl.VariableHelper;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.FieldHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.jdi.Mirror;
import java.util.Map;

public class ObjectVariable
extends AbstractVariable {
    private final ObjectHandle object;
    private final ClassHandle clazz;
    private final long id;
    private final String typeName;

    public ObjectVariable(String name, String typeName, ObjectHandle object, ClassHandle clazz, boolean isStatic, boolean isFinal, VisibilityType visibility) {
        super(name, isStatic, isFinal, visibility);
        long l;
        this.object = object;
        this.clazz = clazz;
        if (object == null) {
            long l2 = uniqueIdentifier;
            l = l2;
            uniqueIdentifier = l2 + 1L;
        } else {
            l = object.getId();
        }
        this.id = l;
        this.typeName = typeName;
    }

    public ObjectHandle object() {
        return this.object;
    }

    @Override
    public long getObjectId() {
        return this.id;
    }

    @Override
    public boolean mayHaveFields() {
        return this.object != null && this.getFieldCount() > 0;
    }

    @Override
    public boolean hasStaticFields() {
        return this.object != null && this.clazz != null && this.clazz.hasStaticFields();
    }

    @Override
    public boolean hasInstanceFields() {
        return this.object != null && this.clazz != null && this.clazz.hasInstanceFields();
    }

    @Override
    public boolean hasConstantFields() {
        return this.object != null && this.clazz != null && this.clazz.hasConstantFields();
    }

    @Override
    public int getFieldCount() {
        return this.clazz == null ? 0 : this.clazz.getFieldCount();
    }

    @Override
    public Variable getField(int index) {
        VisibilityType visibility;
        FieldHandle field = this.clazz.getField(index);
        if (field.isPrivate()) {
            visibility = VisibilityType.PRIVATE;
        } else if (field.isPackagePrivate()) {
            visibility = VisibilityType.PACKAGE_PRIVATE;
        } else if (field.isProtected()) {
            visibility = VisibilityType.PROTECTED;
        } else if (field.isPublic()) {
            visibility = VisibilityType.PUBLIC;
        } else {
            throw new IllegalStateException("Field '" + field.getName() + "' has unknown visibility");
        }
        return VariableHelper.convert(field.getName(), field.getValue(this.object), field.getTypeName(), field.isStatic(), field.isFinal(), visibility);
    }

    public void setField(int index, ValueHandle value, boolean throwException) {
        FieldHandle field = this.clazz.getField(index);
        field.setValue(this.object, value, throwException);
    }

    @Override
    public boolean isSynthetic() {
        return this.object == null;
    }

    @Override
    public String getValue() {
        if (this.object == null) {
            return "null";
        }
        return this.clazz.getDisplayName() + " (id=" + this.id + ")";
    }

    @Override
    public ValueHandle parse(Mirror mirror, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toStringEquivalent(ThreadHandle thread, Map<String, String> detailFormatters) {
        if (this.object == null) {
            return "null";
        }
        return this.object.invokeToString(thread, detailFormatters);
    }

    @Override
    public String getDeclaredTypeName() {
        return this.typeName;
    }

    @Override
    public String getConcreteTypeName() {
        return this.object == null ? this.typeName : this.object.getTypeName();
    }

    @Override
    public void release() {
        if (this.object != null) {
            this.object.release();
        }
    }
}

