/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation.impl;

import com.sap.jvm.debugging.presentation.Variable;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.AbstractVariable;
import com.sap.jvm.debugging.types.ThreadHandle;
import java.util.Map;

public abstract class PrimitiveVariable
extends AbstractVariable {
    private final long id = uniqueIdentifier++;

    public PrimitiveVariable(String name, boolean isStatic, boolean isFinal, VisibilityType visibility) {
        super(name, isStatic, isFinal, visibility);
    }

    @Override
    public long getObjectId() {
        return this.id;
    }

    @Override
    public boolean mayHaveFields() {
        return false;
    }

    @Override
    public boolean hasStaticFields() {
        return false;
    }

    @Override
    public boolean hasInstanceFields() {
        return false;
    }

    @Override
    public boolean hasConstantFields() {
        return false;
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public Variable getField(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toStringEquivalent(ThreadHandle thread, Map<String, String> detailFormatters) {
        return this.getValue();
    }

    @Override
    public boolean isDirectlySettable() {
        return !this.isFinal();
    }

    @Override
    public void release() {
    }

    @Override
    public String getConcreteTypeName() {
        return this.getDeclaredTypeName();
    }
}

