/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation.impl;

import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.ObjectVariable;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.StringHandle;
import com.sap.jvm.debugging.types.ValueFactory;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.jdi.Mirror;

public final class StringVariable
extends ObjectVariable {
    public StringVariable(String name, String typeName, StringHandle object, ClassHandle clazz, boolean isStatic, boolean isFinal, VisibilityType visibility) {
        super(name, typeName, object, clazz, isStatic, isFinal, visibility);
    }

    @Override
    public String getValue() {
        StringHandle handle = (StringHandle)this.object();
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        if (handle == null) {
            buffer.append("null");
        } else {
            int len = handle.length();
            if (len <= 1000) {
                buffer.append(handle.get());
            } else {
                buffer.append(handle.substring(0, 1000));
                buffer.append("...");
            }
        }
        buffer.append("\" (id=");
        buffer.append(this.getObjectId());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public ValueHandle parse(Mirror mirror, String string) {
        return ValueFactory.create(mirror.virtualMachine(), string);
    }

    @Override
    public boolean isDirectlySettable() {
        return !this.isFinal();
    }
}

