/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation.impl;

import com.sap.jvm.debugging.presentation.Variable;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.AbstractVariable;
import com.sap.jvm.debugging.presentation.impl.ArrayVariable;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.jdi.Mirror;
import java.util.Map;

public final class SyntheticArrayVariable
extends AbstractVariable {
    private final ArrayVariable array;
    private final long id;
    private final int lowIndex;
    private final int highIndex;
    private final int childCount;
    private final int childStride;

    public SyntheticArrayVariable(ArrayVariable array, int low, int high) {
        super("[" + low + ".." + (high - 1) + "]", false, false, VisibilityType.PACKAGE_PRIVATE);
        this.array = array;
        this.id = uniqueIdentifier++;
        this.lowIndex = low;
        this.highIndex = high;
        this.childStride = ArrayVariable.calculateChildStride(low, high);
        int count = (high - low) / this.childStride;
        if (count * this.childStride < high - low) {
            ++count;
        }
        this.childCount = count;
    }

    public ArrayVariable getArray() {
        return this.array;
    }

    public int getOffset() {
        return this.lowIndex;
    }

    @Override
    public long getObjectId() {
        return this.id;
    }

    @Override
    public boolean mayHaveFields() {
        return true;
    }

    @Override
    public boolean hasStaticFields() {
        return false;
    }

    @Override
    public boolean hasInstanceFields() {
        return true;
    }

    @Override
    public boolean hasConstantFields() {
        return false;
    }

    @Override
    public int getFieldCount() {
        return this.childCount;
    }

    @Override
    public Variable getField(int index) {
        if (this.highIndex - this.lowIndex == this.childCount) {
            assert (this.childStride == 1);
            return this.array.getField(this.lowIndex + index);
        }
        int low = this.lowIndex + index * this.childStride;
        int high = low + this.childStride >= this.highIndex ? this.highIndex : low + this.childStride;
        return new SyntheticArrayVariable(this.array, low, high);
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public ValueHandle parse(Mirror mirror, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toStringEquivalent(ThreadHandle thread, Map<String, String> detailFormatters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this.lowIndex > 0) {
            buffer.append("... ");
        }
        for (int i = this.lowIndex; i < this.highIndex; ++i) {
            if (i > this.lowIndex) {
                buffer.append(", ");
            }
            Variable var = this.array.getField(i);
            buffer.append(var.toStringEquivalent(thread, detailFormatters));
            if (buffer.length() < 1000) continue;
            buffer.setLength(1000);
            buffer.append("...");
            return buffer.toString();
        }
        if (this.highIndex < this.array.getFieldCount()) {
            buffer.append("...");
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public String getDeclaredTypeName() {
        return this.array.getDeclaredTypeName();
    }

    @Override
    public String getConcreteTypeName() {
        return this.array.getConcreteTypeName();
    }

    @Override
    public void release() {
    }
}

