/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.presentation.impl;

import com.sap.jvm.debugging.presentation.Variable;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.presentation.impl.ArrayVariable;
import com.sap.jvm.debugging.presentation.impl.BooleanVariable;
import com.sap.jvm.debugging.presentation.impl.ByteVariable;
import com.sap.jvm.debugging.presentation.impl.CharVariable;
import com.sap.jvm.debugging.presentation.impl.DoubleVariable;
import com.sap.jvm.debugging.presentation.impl.FloatVariable;
import com.sap.jvm.debugging.presentation.impl.IntVariable;
import com.sap.jvm.debugging.presentation.impl.LongVariable;
import com.sap.jvm.debugging.presentation.impl.ObjectVariable;
import com.sap.jvm.debugging.presentation.impl.ShortVariable;
import com.sap.jvm.debugging.presentation.impl.StringVariable;
import com.sap.jvm.debugging.presentation.impl.VoidVariable;
import com.sap.jvm.debugging.types.ArrayHandle;
import com.sap.jvm.debugging.types.BooleanHandle;
import com.sap.jvm.debugging.types.ByteHandle;
import com.sap.jvm.debugging.types.CharacterHandle;
import com.sap.jvm.debugging.types.DoubleHandle;
import com.sap.jvm.debugging.types.FloatHandle;
import com.sap.jvm.debugging.types.IntegerHandle;
import com.sap.jvm.debugging.types.LongHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.ShortHandle;
import com.sap.jvm.debugging.types.StringHandle;
import com.sap.jvm.debugging.types.ValueHandle;
import com.sap.jvm.debugging.types.VoidHandle;

public final class VariableHelper {
    public static Variable convert(String name, ValueHandle value, String type, boolean isStatic, boolean isFinal, VisibilityType visibility) {
        ObjectHandle v;
        if (value instanceof BooleanHandle) {
            BooleanHandle v2 = (BooleanHandle)value;
            return new BooleanVariable(name, v2.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof ByteHandle) {
            ByteHandle v3 = (ByteHandle)value;
            return new ByteVariable(name, v3.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof CharacterHandle) {
            CharacterHandle v4 = (CharacterHandle)value;
            return new CharVariable(name, v4.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof ShortHandle) {
            ShortHandle v5 = (ShortHandle)value;
            return new ShortVariable(name, v5.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof IntegerHandle) {
            IntegerHandle v6 = (IntegerHandle)value;
            return new IntVariable(name, v6.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof LongHandle) {
            LongHandle v7 = (LongHandle)value;
            return new LongVariable(name, v7.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof DoubleHandle) {
            DoubleHandle v8 = (DoubleHandle)value;
            return new DoubleVariable(name, v8.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof FloatHandle) {
            FloatHandle v9 = (FloatHandle)value;
            return new FloatVariable(name, v9.get(), isStatic, isFinal, visibility);
        }
        if (value instanceof VoidHandle) {
            return new VoidVariable(name, isStatic, isFinal, visibility);
        }
        if (value instanceof ArrayHandle) {
            ArrayHandle v10 = (ArrayHandle)value;
            return new ArrayVariable(name, type, v10, isStatic, isFinal, visibility);
        }
        if (value instanceof StringHandle || value == null && "java.lang.String".equals(type)) {
            StringHandle v11;
            return new StringVariable(name, type, v11, (v11 = (StringHandle)value) == null ? null : v11.getClassHandle(), isStatic, isFinal, visibility);
        }
        assert (value instanceof ObjectHandle || value == null);
        return new ObjectVariable(name, type, v, (v = (ObjectHandle)value) == null ? null : v.getClassHandle(), isStatic, isFinal, visibility);
    }
}

