/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.tools;

import com.sap.jvm.debugging.controller.io.PacketFileReader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class JvmDebuggerDumper {
    public static void main(String[] args) throws IOException {
        if (args.length < 1 || "-?".equals(args[0]) || "--?".equals(args[0]) || "-h".equals(args[0]) || "--help".equals(args[0])) {
            System.out.println("Dumps all debugging packets of the given debugging history file.");
            System.out.println();
            System.out.println("Syntax: jvmdebugger-dumper [<options> ...] <debugging-history-file>");
            System.out.println();
            System.out.println("The following options are supported: ");
            System.out.println("-?, --?");
            System.out.println("            Print usage information (this message).");
            System.out.println("-h, --help");
            System.out.println("            Print usage information (this message).");
            return;
        }
        boolean useZipEncoding = true;
        for (String file : args) {
            if ("-nozip".equals(file)) {
                useZipEncoding = false;
                continue;
            }
            if (useZipEncoding) {
                new PacketFileReader(file, null).run();
                continue;
            }
            new PacketFileReader(new BufferedInputStream(new FileInputStream(file)), null).run();
        }
    }
}

