/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbsoluteMethodLineBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacket;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointParser;
import com.sap.jvm.debugging.controller.packets.breakpoints.ExceptionBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.LineBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.MethodBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.SkipAllBreakpointsPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.TypeLineBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.WatchPointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import com.sap.jvm.debugging.ui.swing.FrontendController;
import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import com.sap.jvm.debugging.ui.swing.dialog.ExceptionBreakpointDialog;
import com.sap.jvm.debugging.ui.swing.dialog.FileLineBreakpointDialog;
import com.sap.jvm.debugging.ui.swing.dialog.LineBreakpointDialog;
import com.sap.jvm.debugging.ui.swing.dialog.RelativeLineBreakpointDialog;
import com.sap.jvm.debugging.ui.swing.dialog.WatchPointDialog;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.concurrent.QueueHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public final class BreakpointManager {
    private static final String BREAKPOINT_COUNT_KEY = "breakpoints";
    private static final String BREAKPOINT_PREFIX = "breakpoint_";
    private JvmDebugger.SwingDebugger context = null;
    private FrontendController controller = null;
    private SourceCodeManager codeManager = null;
    private BreakpointSpecification[] breakpoints = new BreakpointSpecification[0];
    private final JPanel container;
    private final JTable table;
    private final BreakpointModel model;
    private final JToolBar toolbar;
    private final JButton exceptionBreakpointButton;
    private final JButton methodEntryBreakpointButton;
    private final JButton absoluteMethodBreakpointButton;
    private final JButton relativeMethodBreakpointButton;
    private final JButton watchPointButton;
    private final JButton lineBreakpointButton;
    private final JButton bciBreakpointButton;
    private final JButton methodExitBreakpointButton;
    private final JButton typeLineBreakpointButton;
    private final JButton clearBreakpointsButton;
    private final JToggleButton skipBreakpointsButton;
    private final JPopupMenu contextMenu;
    private final JMenuItem enableContextMenuItem;
    private final JMenuItem disableContextMenuItem;
    private final JMenuItem removeContextMenuItem;
    private final JMenuItem editHitCountContextMenuItem;
    private final JMenuItem editConditionContextMenuItem;
    private final JMenuItem editSuspendTypeContextMenuItem;
    private final BreakpointListenerImpl listener;
    private final Map<String, BreakpointSpecification> name2Breakpoint = new HashMap<String, BreakpointSpecification>();
    private final Map<String, Integer> name2Index = new HashMap<String, Integer>();
    private final Map<BreakpointType, Icon> icons = new HashMap<BreakpointType, Icon>();
    private final BlockingQueue<DebuggingPacket> initialPackets = new LinkedBlockingQueue<DebuggingPacket>();
    private final List<BreakpointListener> listeners = Collections.synchronizedList(new ArrayList());

    public BreakpointManager() {
        this.model = new BreakpointModel();
        this.listener = new BreakpointListenerImpl();
        this.table = new JTable(this.model);
        this.table.setTableHeader(null);
        this.model.isInitialized = false;
        TableCellRenderer renderer = this.table.getCellRenderer(0, 0);
        Component component = this.table.prepareRenderer(renderer, 0, 0);
        this.model.isInitialized = true;
        this.table.getColumnModel().getColumn(0).setMaxWidth(component.getPreferredSize().width + 5);
        this.table.addMouseListener(this.listener);
        this.toolbar = new JToolBar();
        ImageIcon breakpointIcon = ImageRepository.getImage("resources/breakpoint.gif", "Breakpoint");
        this.lineBreakpointButton = new JButton(breakpointIcon);
        this.lineBreakpointButton.setToolTipText("Add Line Breakpoint");
        this.lineBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.lineBreakpointButton);
        this.typeLineBreakpointButton = new JButton(ImageRepository.createIconWithOverlay(breakpointIcon, null, ImageRepository.getImage("resources/overlay_type.gif", "Type"), null, null));
        this.typeLineBreakpointButton.setToolTipText("Add Type Line Breakpoint");
        this.typeLineBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.typeLineBreakpointButton);
        this.toolbar.addSeparator();
        this.exceptionBreakpointButton = new JButton(ImageRepository.getImage("resources/exception.gif", "Exception Breakpoint"));
        this.exceptionBreakpointButton.setToolTipText("Add Exception Breakpoint");
        this.exceptionBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.exceptionBreakpointButton);
        this.toolbar.addSeparator();
        this.watchPointButton = new JButton(ImageRepository.getImage("resources/watchpoint.gif", "Watchpoint"));
        this.watchPointButton.setToolTipText("Add Watch Point");
        this.watchPointButton.addActionListener(this.listener);
        this.toolbar.add(this.watchPointButton);
        this.toolbar.addSeparator();
        this.methodEntryBreakpointButton = new JButton(ImageRepository.createIconWithOverlay(breakpointIcon, null, ImageRepository.getImage("resources/overlay_entry.gif", "Method Entry"), null, null));
        this.methodEntryBreakpointButton.setToolTipText("Add Method Entry Breakpoint");
        this.methodEntryBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.methodEntryBreakpointButton);
        this.methodExitBreakpointButton = new JButton(ImageRepository.createIconWithOverlay(breakpointIcon, null, null, null, ImageRepository.getImage("resources/overlay_exit.gif", "Method Exit")));
        this.methodExitBreakpointButton.setToolTipText("Add Method Exit Breakpoint");
        this.methodExitBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.methodExitBreakpointButton);
        this.absoluteMethodBreakpointButton = new JButton(ImageRepository.createIconWithOverlay(breakpointIcon, null, ImageRepository.getImage("resources/overlay_abstract.gif", "Abstract"), null, null));
        this.absoluteMethodBreakpointButton.setToolTipText("Add Absolute Method Breakpoint");
        this.absoluteMethodBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.absoluteMethodBreakpointButton);
        this.relativeMethodBreakpointButton = new JButton(ImageRepository.createIconWithOverlay(breakpointIcon, null, ImageRepository.getImage("resources/overlay_delta.gif", "Delta"), null, null));
        this.relativeMethodBreakpointButton.setToolTipText("Add Relative Method Breakpoint");
        this.relativeMethodBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.relativeMethodBreakpointButton);
        this.bciBreakpointButton = new JButton(ImageRepository.createIconWithOverlay(breakpointIcon, null, ImageRepository.getImage("resources/overlay_byte_code_index.gif", "BCI"), null, null));
        this.bciBreakpointButton.setToolTipText("Add Byte Code Index Breakpoint");
        this.bciBreakpointButton.addActionListener(this.listener);
        this.toolbar.add(this.bciBreakpointButton);
        this.toolbar.addSeparator();
        this.clearBreakpointsButton = new JButton(ImageRepository.getImage("resources/remove_grey_all.gif", "Remove Breakpoints"));
        this.clearBreakpointsButton.setToolTipText("Remove all Breakpoints");
        this.clearBreakpointsButton.addActionListener(this.listener);
        this.toolbar.add(this.clearBreakpointsButton);
        this.toolbar.addSeparator();
        this.skipBreakpointsButton = new JToggleButton(ImageRepository.getImage("resources/ignore_breakpoint.gif", "Skip Breakpoints"));
        this.skipBreakpointsButton.setToolTipText("Skip all Breakpoints");
        this.skipBreakpointsButton.addActionListener(this.listener);
        this.toolbar.add(this.skipBreakpointsButton);
        this.contextMenu = new JPopupMenu();
        this.enableContextMenuItem = new JMenuItem("Enable", ImageRepository.getImage("resources/breakpoint.gif", "Enable Breakpoint"));
        this.enableContextMenuItem.addActionListener(this.listener);
        this.contextMenu.add(this.enableContextMenuItem);
        this.disableContextMenuItem = new JMenuItem("Disable", ImageRepository.getImage("resources/ignore_breakpoint.gif", "Disable Breakpoint"));
        this.disableContextMenuItem.addActionListener(this.listener);
        this.contextMenu.add(this.disableContextMenuItem);
        this.removeContextMenuItem = new JMenuItem("Remove", ImageRepository.getImage("resources/remove.gif", "Remove"));
        this.removeContextMenuItem.addActionListener(this.listener);
        this.contextMenu.add(this.removeContextMenuItem);
        this.contextMenu.addSeparator();
        this.editHitCountContextMenuItem = new JMenuItem("Edit Hit Count", ImageRepository.getImage("resources/hit_count.gif", "Hit count"));
        this.editHitCountContextMenuItem.addActionListener(this.listener);
        this.contextMenu.add(this.editHitCountContextMenuItem);
        this.editConditionContextMenuItem = new JMenuItem("Edit Condition", ImageRepository.createIconWithOverlay(breakpointIcon, null, ImageRepository.getImage("resources/overlay_condition.gif", "Condition"), null, null));
        this.editConditionContextMenuItem.addActionListener(this.listener);
        this.contextMenu.add(this.editConditionContextMenuItem);
        this.editSuspendTypeContextMenuItem = new JMenuItem("Edit Suspension Type", ImageRepository.getImage("resources/suspension_type.gif", "Suspension type"));
        this.editSuspendTypeContextMenuItem.addActionListener(this.listener);
        this.contextMenu.add(this.editSuspendTypeContextMenuItem);
        this.container = new JPanel(new BorderLayout());
        this.container.add((Component)this.toolbar, "First");
        this.container.add((Component)new JScrollPane(this.table), "Center");
        this.icons.put(BreakpointType.ABSOLUTE_METHOD_LINE, this.absoluteMethodBreakpointButton.getIcon());
        this.icons.put(BreakpointType.EXCEPTION, this.exceptionBreakpointButton.getIcon());
        this.icons.put(BreakpointType.LINE, this.lineBreakpointButton.getIcon());
        this.icons.put(BreakpointType.METHOD_BYTE_CODE_INDEX, this.bciBreakpointButton.getIcon());
        this.icons.put(BreakpointType.METHOD_ENTRY, this.methodEntryBreakpointButton.getIcon());
        this.icons.put(BreakpointType.METHOD_EXIT, this.methodExitBreakpointButton.getIcon());
        this.icons.put(BreakpointType.RELATIVE_METHOD_LINE, this.relativeMethodBreakpointButton.getIcon());
        this.icons.put(BreakpointType.TYPE_LINE, this.typeLineBreakpointButton.getIcon());
        this.icons.put(BreakpointType.WATCH_POINT, this.watchPointButton.getIcon());
        int maxWidth = 0;
        for (Icon icon : this.icons.values()) {
            maxWidth = Math.max(maxWidth, icon.getIconWidth());
        }
        this.table.getColumnModel().getColumn(1).setMaxWidth(maxWidth + 5);
    }

    public void setBreakpoints(BreakpointListPacket packet) {
        int[] selectedValues = this.table.getSelectedRows();
        HashSet<String> selectedEntries = new HashSet<String>();
        for (int i = 0; i < selectedValues.length; ++i) {
            BreakpointSpecification b = this.breakpoints[selectedValues[i]];
            selectedEntries.add(b.getName());
        }
        this.name2Breakpoint.clear();
        this.name2Index.clear();
        HashSet<Integer> newlySelectedEntries = new HashSet<Integer>();
        BreakpointSpecification[] bps = packet.getBreakpoints();
        for (int i = 0; i < bps.length; ++i) {
            this.name2Breakpoint.put(bps[i].getName(), bps[i]);
            this.name2Index.put(bps[i].getName(), i);
            if (!selectedEntries.contains(bps[i].getName())) continue;
            newlySelectedEntries.add(i);
        }
        int[] selection = new int[newlySelectedEntries.size()];
        int i = 0;
        Iterator iterator = newlySelectedEntries.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            selection[i++] = s;
        }
        int oldLength = this.breakpoints.length;
        this.breakpoints = bps;
        if (oldLength > 0) {
            this.model.fireTableRowsDeleted(0, oldLength - 1);
        }
        if (this.breakpoints.length > 0) {
            this.model.fireTableRowsInserted(0, this.breakpoints.length - 1);
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        for (int s : selection) {
            selectionModel.addSelectionInterval(s, s);
        }
        this.updateBreakpointProperties(bps);
        for (BreakpointListener l : this.listeners.toArray(new BreakpointListener[0])) {
            l.breakpointsChanged((BreakpointSpecification[])this.breakpoints.clone());
        }
    }

    public void setContext(JvmDebugger.SwingDebugger context) {
        assert (this.context == null && context != null);
        this.context = context;
    }

    public void setController(FrontendController controller) {
        assert (this.controller == null && controller != null);
        this.controller = controller;
        while (this.initialPackets.size() > 0) {
            QueueHelper.put(controller.getWriteQueue(), this.initialPackets.remove());
        }
    }

    public void setSourceCodeManager(SourceCodeManager manager) {
        assert (this.codeManager == null);
        this.codeManager = manager;
    }

    public JComponent getList() {
        return this.container;
    }

    public DebuggingPacket createIgnoreLocationPacket(String name, long threadId) {
        BreakpointSpecification breakpoint = this.name2Breakpoint.get(name);
        BreakpointSpecification[] newBreakpoints = new BreakpointSpecification[this.breakpoints.length];
        System.arraycopy(this.breakpoints, 0, newBreakpoints, 0, this.breakpoints.length);
        newBreakpoints[this.name2Index.get((Object)name).intValue()] = breakpoint.setThreadToBeIgnored(threadId);
        return new BreakpointListPacketImpl(newBreakpoints);
    }

    public boolean breakpointExists(String name) {
        return this.name2Breakpoint.containsKey(name);
    }

    public void addBreakpoint(BreakpointSpecification newBreakpoint) {
        BreakpointSpecification[] bps = new BreakpointSpecification[this.breakpoints.length + 1];
        System.arraycopy(this.breakpoints, 0, bps, 0, bps.length - 1);
        bps[bps.length - 1] = newBreakpoint;
        this.sendBreakpoints(bps);
    }

    public void removeBreakpoint(BreakpointSpecification breakpointToBeRemoved) {
        if (!this.breakpointExists(breakpointToBeRemoved.getName())) {
            return;
        }
        ArrayList<BreakpointSpecification> bps = new ArrayList<BreakpointSpecification>();
        for (BreakpointSpecification b : this.breakpoints) {
            if (b.getName().equals(breakpointToBeRemoved.getName())) continue;
            bps.add(b);
        }
        this.sendBreakpoints(bps.toArray(new BreakpointSpecification[bps.size()]));
    }

    public void updateBreakpoint(BreakpointSpecification updatedBreakpoint) {
        if (!this.breakpointExists(updatedBreakpoint.getName())) {
            this.addBreakpoint(updatedBreakpoint);
            return;
        }
        int index = this.name2Index.get(updatedBreakpoint.getName());
        this.updateBreakpointImpl(updatedBreakpoint, index);
    }

    private void updateBreakpointImpl(BreakpointSpecification updatedBreakpoint, int index) {
        BreakpointSpecification[] bps = new BreakpointSpecification[this.breakpoints.length];
        System.arraycopy(this.breakpoints, 0, bps, 0, bps.length);
        bps[index] = updatedBreakpoint;
        this.sendBreakpoints(bps);
    }

    public boolean isEnabled(String name) {
        BreakpointSpecification breakpoint = this.name2Breakpoint.get(name);
        return breakpoint != null && breakpoint.isEnabled();
    }

    private void sendBreakpoints(BreakpointSpecification[] bps) {
        BreakpointListPacketImpl packet = new BreakpointListPacketImpl(bps);
        BlockingQueue<DebuggingPacket> queue = this.controller == null ? this.initialPackets : this.controller.getWriteQueue();
        QueueHelper.put(queue, packet);
        if (queue == this.initialPackets) {
            this.setBreakpoints(packet);
        }
    }

    public void reset() {
        this.controller = null;
        this.name2Breakpoint.clear();
        this.name2Index.clear();
        this.sendBreakpoints(this.breakpoints);
    }

    private void updateBreakpointProperties(BreakpointSpecification[] bps) {
        int i;
        Properties properties = this.context.getProperties();
        int oldCount = Integer.parseInt(properties.getProperty(BREAKPOINT_COUNT_KEY, "0"));
        int newCount = bps.length;
        properties.setProperty(BREAKPOINT_COUNT_KEY, Integer.toString(newCount));
        for (i = newCount; i < oldCount; ++i) {
            properties.remove(BREAKPOINT_PREFIX + i);
        }
        for (i = 0; i < newCount; ++i) {
            properties.setProperty(BREAKPOINT_PREFIX + i, BreakpointParser.serialize(bps[i]));
        }
    }

    public void propertiesChanged() {
        Properties properties = this.context.getProperties();
        int count = Integer.parseInt(properties.getProperty(BREAKPOINT_COUNT_KEY, "0"));
        ArrayList<BreakpointSpecification> bps = new ArrayList<BreakpointSpecification>(Arrays.asList(this.breakpoints));
        for (int i = 0; i < count; ++i) {
            String bp = properties.getProperty(BREAKPOINT_PREFIX + i);
            if (bp == null) continue;
            try {
                BreakpointSpecification spec = BreakpointParser.deserialize(bp);
                bps.add(spec);
                continue;
            }
            catch (RuntimeException e) {
                Trace.warn((Throwable)e, () -> "Exception while parsing breakpoint specification '" + bp + "'.");
            }
        }
        this.sendBreakpoints(bps.toArray(new BreakpointSpecification[bps.size()]));
    }

    public void clearProperties() {
        this.sendBreakpoints(new BreakpointSpecification[0]);
    }

    public void addListener(BreakpointListener l) {
        this.listeners.add(l);
    }

    public void removeListener(BreakpointListener l) {
        this.listeners.remove(l);
    }

    private final class BreakpointModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8955099511574741460L;
        private final Class<?>[] COLUMNS = new Class[]{Boolean.class, ImageIcon.class, String.class};
        private boolean isInitialized = false;

        private BreakpointModel() {
        }

        @Override
        public int getRowCount() {
            return BreakpointManager.this.breakpoints.length;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (!this.isInitialized && rowIndex == 0 && columnIndex == 0) {
                return true;
            }
            BreakpointSpecification bp = BreakpointManager.this.breakpoints[rowIndex];
            if (columnIndex == 0) {
                return bp.isEnabled();
            }
            if (columnIndex == 1) {
                return BreakpointManager.this.icons.get((Object)bp.getType());
            }
            String text = bp.getName();
            if (bp.getType() == BreakpointType.EXCEPTION) {
                ExceptionBreakpointSpecification eBp = (ExceptionBreakpointSpecification)bp;
                text = text + ",notifyoncaught=" + eBp.isNotifyOnCaught() + ",notifyonuncaught=" + eBp.isNotifyOnUncaught() + ",notifyonsubtypes=" + eBp.isNotifyOnSubtypes();
            } else if (bp.getType() == BreakpointType.WATCH_POINT) {
                WatchPointSpecification wpBp = (WatchPointSpecification)bp;
                text = text + ",notifyonaccess=" + wpBp.isNotifyOnAccess() + ",notifyonmodification=" + wpBp.isNotifyOnModification();
            }
            return text;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 0) {
                return;
            }
            BreakpointManager.this.updateBreakpointImpl(BreakpointManager.this.breakpoints[rowIndex].setEnabled((Boolean)aValue), rowIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.COLUMNS[columnIndex];
        }

        public BreakpointSpecification get(int rowIndex) {
            return BreakpointManager.this.breakpoints[rowIndex];
        }
    }

    public static interface BreakpointListener {
        public void breakpointsChanged(BreakpointSpecification[] var1);
    }

    private static class BreakpointConditionDialog
    implements ActionListener {
        private final JButton okButton = new JButton("Ok");
        private final JButton disableButton;
        private final JButton cancelButton;
        private final JRadioButton booleanConditionButton;
        private final JRadioButton valueChangeConditionButton;
        private final JTextArea conditionArea;
        private final JDialog dialog;
        private String condition = null;
        private boolean disabled = false;
        private boolean booleanCondition = false;

        public BreakpointConditionDialog(BreakpointSpecification breakpoint) {
            this.okButton.addActionListener(this);
            this.disableButton = new JButton("Disable");
            this.disableButton.addActionListener(this);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            this.booleanConditionButton = new JRadioButton("Suspend when 'true'");
            this.valueChangeConditionButton = new JRadioButton("Suspend when value changes");
            ButtonGroup group = new ButtonGroup();
            group.add(this.booleanConditionButton);
            group.add(this.valueChangeConditionButton);
            boolean bl = this.booleanCondition = !breakpoint.isValueChangeCondition();
            if (this.booleanCondition) {
                this.booleanConditionButton.setSelected(true);
            } else {
                this.valueChangeConditionButton.setSelected(true);
            }
            this.conditionArea = new JTextArea(breakpoint.getCondition(), 5, 80);
            this.dialog = new JDialog((Frame)null, "Edit Breakpoint Condition", true);
        }

        public boolean show() {
            JPanel main = new JPanel(new BorderLayout(5, 5));
            JLabel label = new JLabel("Please enter the condition:");
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            main.add((Component)label, "First");
            main.add((Component)this.conditionArea, "Center");
            JPanel conditionType = new JPanel();
            conditionType.add(this.booleanConditionButton);
            conditionType.add(this.valueChangeConditionButton);
            main.add((Component)conditionType, "Last");
            JPanel buttons = new JPanel(new FlowLayout(2));
            buttons.add(this.okButton);
            buttons.add(this.disableButton);
            buttons.add(this.cancelButton);
            JLabel icon = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
            icon.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
            this.dialog.getContentPane().add((Component)icon, "Before");
            this.dialog.getContentPane().add((Component)main, "Center");
            this.dialog.getContentPane().add((Component)new JLabel(""), "After");
            this.dialog.getContentPane().add((Component)buttons, "Last");
            this.dialog.pack();
            this.dialog.setVisible(true);
            this.dialog.dispose();
            return this.disabled || this.condition != null;
        }

        public boolean isDisable() {
            return this.disabled;
        }

        public boolean isBooleanCondition() {
            if (this.condition == null) {
                throw new IllegalStateException("No breakpoint condition present");
            }
            return this.booleanCondition;
        }

        public String getCondition() {
            return this.condition;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButton) {
                this.condition = this.conditionArea.getText();
                this.booleanCondition = this.booleanConditionButton.isSelected();
            } else if (e.getSource() == this.disableButton) {
                this.disabled = true;
            } else assert (e.getSource() == this.cancelButton);
            this.dialog.setVisible(false);
        }
    }

    private class WatchPointCreationDialog
    implements BreakpointCreationDialog {
        private WatchPointCreationDialog() {
        }

        @Override
        public String show(String message, String title, String input) {
            int comma = input.indexOf(44);
            String truncInput = comma < 0 ? input : input.substring(0, comma);
            WatchPointDialog dialog = WatchPointDialog.create((JFrame)SwingUtilities.getRoot(BreakpointManager.this.table), title);
            if (dialog.show(message, truncInput)) {
                return dialog.getBreakpointResult();
            }
            return null;
        }
    }

    private class LineBreakpointCreationDialog
    implements BreakpointCreationDialog {
        private final String[] labels;
        private final boolean isRelative;
        private final boolean isFile;

        public LineBreakpointCreationDialog(String ... labels) {
            this(false, false, labels);
        }

        public LineBreakpointCreationDialog(boolean isRelative, boolean isFile, String ... labels) {
            this.labels = labels;
            this.isRelative = isRelative;
            this.isFile = isFile;
        }

        @Override
        public String show(String message, String title, String input) {
            RelativeLineBreakpointDialog dialog;
            JFrame frame = (JFrame)SwingUtilities.getRoot(BreakpointManager.this.table);
            LineBreakpointDialog lineBreakpointDialog = dialog = this.isRelative ? RelativeLineBreakpointDialog.create(frame, title) : (this.isFile ? FileLineBreakpointDialog.create(frame, title) : LineBreakpointDialog.create(frame, title));
            if (dialog.show(this.labels, message, input.split(this.isRelative ? ":[+]" : ":"))) {
                return dialog.getBreakpointResult();
            }
            return null;
        }
    }

    private class ExceptionBreakpointCreationDialog
    implements BreakpointCreationDialog {
        private ExceptionBreakpointCreationDialog() {
        }

        @Override
        public String show(String message, String title, String input) {
            int comma = input.indexOf(44);
            String truncInput = comma < 0 ? input : input.substring(0, comma);
            ExceptionBreakpointDialog dialog = ExceptionBreakpointDialog.create((JFrame)SwingUtilities.getRoot(BreakpointManager.this.table), title);
            if (dialog.show(message, truncInput)) {
                return dialog.getBreakpointResult();
            }
            return null;
        }
    }

    private class GenericBreakpointCreationDialog
    implements BreakpointCreationDialog {
        private GenericBreakpointCreationDialog() {
        }

        @Override
        public String show(String message, String title, String input) {
            return (String)JOptionPane.showInputDialog(BreakpointManager.this.table, message, title, 3, null, null, input);
        }
    }

    private static interface BreakpointCreationDialog {
        public String show(String var1, String var2, String var3);
    }

    private class BreakpointListenerImpl
    extends MouseAdapter
    implements ActionListener {
        private BreakpointListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == BreakpointManager.this.exceptionBreakpointButton) {
                String format = "<package>.<exception-class>,notifyoncaught=[true|false],notifyonuncaught=[true|false],notifyonsubtypes=[true|false]";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.EXCEPTION, format, input, "Add Exception Breakpoint", "Please enter the fully qualified name of the exception:", new ExceptionBreakpointCreationDialog());
            } else if (e.getSource() == BreakpointManager.this.methodEntryBreakpointButton) {
                String format = "<package>.<class>.<method>";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.METHOD_ENTRY, format, input, "Add Method Entry Breakpoint", "Please enter the fully qualified method name without the signature:", new GenericBreakpointCreationDialog());
            } else if (e.getSource() == BreakpointManager.this.absoluteMethodBreakpointButton) {
                String format = "<package>.<class>.<method>:<file-line-number>";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.ABSOLUTE_METHOD_LINE, format, input, "Add Absolute Method Breakpoint", "Please enter the fully qualified method name without the signature\nand the absolute line number with respect to the file:", new LineBreakpointCreationDialog("Method Name:", "Line Number:"));
            } else if (e.getSource() == BreakpointManager.this.relativeMethodBreakpointButton) {
                String format = "<package>.<class>.<method>:+<relative-statement-line-number>";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.RELATIVE_METHOD_LINE, format, input, "Add Relative Method Breakpoint", "Please enter the fully qualified method name without the signature\nand the relative line number with respect to the method's statements:", new LineBreakpointCreationDialog(true, false, "Method Name:", "Line Number:"));
            } else if (e.getSource() == BreakpointManager.this.watchPointButton) {
                String format = "<package>.<class>.<field>,notifyonaccess=[true|false],notifyonmodification=[true|false]";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.WATCH_POINT, format, input, "Add Field Watch Point", "Please enter the fully qualified field name:", new WatchPointCreationDialog());
            } else if (e.getSource() == BreakpointManager.this.lineBreakpointButton) {
                String format = "<file>:<line-number>:<package>.<class>";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.LINE, format, input, "Add Line Breakpoint", "Please enter the file name followed by ':' and the line number:", new LineBreakpointCreationDialog(false, true, "File Name:", "Line Number:", "Class Name (optional):"));
            } else if (e.getSource() == BreakpointManager.this.bciBreakpointButton) {
                String format = "<package>.<class>.<method>:<byte-code-index>";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.METHOD_BYTE_CODE_INDEX, format, input, "Add Byte Code Index Breakpoint", "Please enter the fully qualified method name without the signature\nand the byte code index within the method:", new LineBreakpointCreationDialog("Method Name:", "Byte Code Index:"));
            } else if (e.getSource() == BreakpointManager.this.methodExitBreakpointButton) {
                String format = "<package>.<class>.<method>";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.METHOD_EXIT, format, input, "Add Method Exit Breakpoint", "Please enter the fully qualified method name without the signature:", new GenericBreakpointCreationDialog());
            } else if (e.getSource() == BreakpointManager.this.typeLineBreakpointButton) {
                String format = "<package>.<class>:<line-number>";
                String input = this.getInitialInput(format);
                this.showAddBreakpointDialog(BreakpointType.TYPE_LINE, format, input, "Add Type Line Breakpoint", "Please enter the fully qualified class name and the line number:", new LineBreakpointCreationDialog("Class Name:", "Line Number:"));
            } else if (e.getSource() == BreakpointManager.this.clearBreakpointsButton) {
                BreakpointManager.this.clearProperties();
            } else if (e.getSource() == BreakpointManager.this.skipBreakpointsButton) {
                BlockingQueue<DebuggingPacket> queue = BreakpointManager.this.controller == null ? BreakpointManager.this.initialPackets : BreakpointManager.this.controller.getWriteQueue();
                QueueHelper.put(queue, new SkipAllBreakpointsPacketImpl(BreakpointManager.this.skipBreakpointsButton.isSelected()));
            } else if (e.getSource() == BreakpointManager.this.enableContextMenuItem || e.getSource() == BreakpointManager.this.disableContextMenuItem) {
                boolean isEnabled = e.getSource() == BreakpointManager.this.enableContextMenuItem;
                BreakpointSpecification[] bps = (BreakpointSpecification[])BreakpointManager.this.breakpoints.clone();
                int[] selectedRows = BreakpointManager.this.table.getSelectedRows();
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    bps[selectedRows[i]] = bps[selectedRows[i]].setEnabled(isEnabled);
                }
                BreakpointManager.this.sendBreakpoints(bps);
            } else if (e.getSource() == BreakpointManager.this.removeContextMenuItem) {
                ArrayList<BreakpointSpecification> bps = new ArrayList<BreakpointSpecification>(Arrays.asList(BreakpointManager.this.breakpoints));
                int[] selectedRows = BreakpointManager.this.table.getSelectedRows();
                Arrays.sort(selectedRows);
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    bps.remove(selectedRows[i]);
                }
                BreakpointManager.this.sendBreakpoints(bps.toArray(new BreakpointSpecification[bps.size()]));
            } else if (e.getSource() == BreakpointManager.this.editHitCountContextMenuItem) {
                int selectedIndex = BreakpointManager.this.table.getSelectedRow();
                String input = Integer.toString(Math.max(0, BreakpointManager.this.breakpoints[selectedIndex].getHitCount()));
                int count = -1;
                while ((input = (String)JOptionPane.showInputDialog(BreakpointManager.this.table, "Please specify the breakpoint hit count:", "Edit Breakpoint Hit Count", 3, null, null, input)) != null) {
                    try {
                        count = Integer.parseInt(input);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(BreakpointManager.this.table, "Yout input '" + input + "'\nis not a valid number. Please try again.", "Incorrect Hit Count", 0);
                    }
                }
                if (input != null) {
                    BreakpointManager.this.updateBreakpointImpl(BreakpointManager.this.breakpoints[selectedIndex].setHitCount(count), selectedIndex);
                }
            } else if (e.getSource() == BreakpointManager.this.editConditionContextMenuItem) {
                int selectedIndex = BreakpointManager.this.table.getSelectedRow();
                BreakpointConditionDialog dialog = new BreakpointConditionDialog(BreakpointManager.this.breakpoints[selectedIndex]);
                if (dialog.show() && (dialog.isDisable() || dialog.getCondition().trim().length() > 0)) {
                    String condition = dialog.isDisable() ? null : dialog.getCondition();
                    boolean boolCond = dialog.isDisable() ? true : dialog.isBooleanCondition();
                    BreakpointManager.this.updateBreakpointImpl(BreakpointManager.this.breakpoints[selectedIndex].setCondition(condition, boolCond), selectedIndex);
                }
            } else if (e.getSource() == BreakpointManager.this.editSuspendTypeContextMenuItem) {
                Object[] values = new String[]{"Suspend Thread", "Suspend VM"};
                int selectedIndex = BreakpointManager.this.table.getSelectedRow();
                BreakpointSpecification b = BreakpointManager.this.model.get(selectedIndex);
                String input = b.isSuspendThread() ? values[0] : values[1];
                input = (String)JOptionPane.showInputDialog(BreakpointManager.this.table, "Please choose the breakpoint suspension type:", "Change Breakpoint Suspension Type", 3, null, values, input);
                if (input != null) {
                    BreakpointManager.this.updateBreakpointImpl(BreakpointManager.this.breakpoints[selectedIndex].setSuspendThread(input == values[0]), selectedIndex);
                }
            }
        }

        private void showAddBreakpointDialog(BreakpointType type, String format, String initialInput, String title, String message, BreakpointCreationDialog dialog) {
            String input = initialInput;
            BreakpointSpecification spec = null;
            while ((input = dialog.show(message, title, input)) != null) {
                try {
                    spec = BreakpointParser.deserialize(type, input);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    JOptionPane.showMessageDialog(BreakpointManager.this.table, "Yout input '" + input + "'\ndoes not match the format '" + format + "'.\nPlease try again.", "Incorrect Breakpoint Format", 0);
                }
            }
            if (spec != null) {
                BreakpointManager.this.addBreakpoint(spec);
            }
        }

        private String getInitialInput(String format) {
            String path;
            String result = format;
            String className = BreakpointManager.this.codeManager.getActiveClassName();
            if (className != null) {
                result = result.replace("<package>.<class>", className);
            }
            if ((path = BreakpointManager.this.codeManager.getActivePath()) != null) {
                result = result.replace("<file>", path);
            }
            return result;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = BreakpointManager.this.table.rowAtPoint(e.getPoint());
            if (index >= 0 && !BreakpointManager.this.contextMenu.isShowing() && e.getClickCount() == 2) {
                BreakpointSpecification bp = BreakpointManager.this.breakpoints[index];
                if (bp instanceof LineBreakpointSpecification) {
                    LineBreakpointSpecification spec = (LineBreakpointSpecification)bp;
                    BreakpointManager.this.codeManager.showSource(spec.getFileName(), spec.getLineNumber());
                } else {
                    BreakpointSpecification spec;
                    String file = null;
                    int lineNumber = 0;
                    if (bp instanceof ExceptionBreakpointSpecification) {
                        spec = (ExceptionBreakpointSpecification)bp;
                        file = spec.getExceptionName();
                    } else if (bp instanceof TypeLineBreakpointSpecification) {
                        spec = (TypeLineBreakpointSpecification)bp;
                        file = spec.getClassName();
                        lineNumber = spec.getLineNumber();
                    } else if (bp instanceof WatchPointSpecification) {
                        spec = (WatchPointSpecification)bp;
                        file = spec.getClassName();
                    } else if (bp instanceof MethodBreakpointSpecification) {
                        spec = (MethodBreakpointSpecification)bp;
                        file = spec.getMethod();
                        int lastDot = file.lastIndexOf(46);
                        if (lastDot > 0) {
                            file = file.substring(0, lastDot);
                        }
                        if (spec instanceof AbsoluteMethodLineBreakpointSpecification) {
                            lineNumber = ((AbsoluteMethodLineBreakpointSpecification)spec).getLineNumber();
                        }
                    }
                    file = file.replace('.', '/');
                    int dollarIndex = file.indexOf(36);
                    if (dollarIndex > 0) {
                        file = file.substring(0, dollarIndex);
                    }
                    file = file + ".java";
                    BreakpointManager.this.codeManager.showSource(file, lineNumber);
                }
            }
        }

        private void handleContextMenu(MouseEvent e) {
            int index;
            if (e.isPopupTrigger() && (index = BreakpointManager.this.table.rowAtPoint(e.getPoint())) >= 0) {
                ListSelectionModel selectionModel = BreakpointManager.this.table.getSelectionModel();
                if (!selectionModel.isSelectedIndex(index)) {
                    selectionModel.addSelectionInterval(index, index);
                }
                boolean singleRowSelected = BreakpointManager.this.table.getSelectedRowCount() == 1;
                BreakpointManager.this.editHitCountContextMenuItem.setEnabled(singleRowSelected);
                BreakpointManager.this.editConditionContextMenuItem.setEnabled(singleRowSelected);
                BreakpointManager.this.editSuspendTypeContextMenuItem.setEnabled(singleRowSelected);
                boolean isAnyBreakpointEnabled = false;
                boolean isAnyBreakpointDisabled = false;
                for (int i : BreakpointManager.this.table.getSelectedRows()) {
                    BreakpointSpecification bp = BreakpointManager.this.breakpoints[i];
                    isAnyBreakpointEnabled |= bp.isEnabled();
                    isAnyBreakpointDisabled |= !bp.isEnabled();
                }
                BreakpointManager.this.enableContextMenuItem.setEnabled(isAnyBreakpointDisabled);
                BreakpointManager.this.disableContextMenuItem.setEnabled(isAnyBreakpointEnabled);
                BreakpointManager.this.contextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

