/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.packets.variables.AddExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ChangeExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableExpansionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableFilterPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSelectPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.VariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreeNodeImpl;
import com.sap.jvm.debugging.ui.swing.VariablesManager;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.util.concurrent.QueueHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public final class ExpressionManager
extends VariablesManager {
    private final ActionListenerImpl buttonListener = new ActionListenerImpl();
    private final JButton addExpressionToolBarButton;
    private final JButton removeAllExpressionsToolBarButton;
    private final JMenuItem changeExpressionContextMenuItem;
    private final JMenuItem removeExpressionContextMenuItem;

    public ExpressionManager() {
        this.getToolbar().addSeparator();
        this.addExpressionToolBarButton = new JButton(ImageRepository.getImage("resources/expressions.gif", "Expressions"));
        this.addExpressionToolBarButton.setToolTipText("Add Expression");
        this.addExpressionToolBarButton.addActionListener(this.buttonListener);
        this.getToolbar().add(this.addExpressionToolBarButton);
        this.getToolbar().addSeparator();
        this.removeAllExpressionsToolBarButton = new JButton(ImageRepository.getImage("resources/remove_grey_all.gif", "Remove All Expressions"));
        this.removeAllExpressionsToolBarButton.setToolTipText("Remove All Expressions");
        this.removeAllExpressionsToolBarButton.addActionListener(this.buttonListener);
        this.getToolbar().add(this.removeAllExpressionsToolBarButton);
        this.changeExpressionContextMenuItem = new JMenuItem("Change Expression", ImageRepository.getImage("resources/change.gif", "Change"));
        this.addRootContextMenuItem(this.changeExpressionContextMenuItem);
        this.removeExpressionContextMenuItem = new JMenuItem("Remove Expression", ImageRepository.getImage("resources/remove.gif", "Remove Expression"));
        this.addRootContextMenuItem(this.removeExpressionContextMenuItem);
        this.finishedConstruction();
    }

    public void setExpressions(ExpressionVariableTreePacket packet) {
        this.setVariables(packet);
    }

    @Override
    protected VariableSetPacket createVariableSetPacket(long thread, int frame, String value, VariableTreeNodeImpl[] path) {
        return new ExpressionVariableSetPacketImpl(thread, frame, value, path);
    }

    @Override
    protected VariableSetExpressionPacket createVariableSetExpressionPacket(long thread, int frame, String expression, VariableTreeNodeImpl[] path) {
        return new ExpressionVariableSetExpressionPacketImpl(thread, frame, expression, path);
    }

    @Override
    protected VariableExpansionPacket createVariableExpansionPacket(long thread, int frame, boolean isExpanded, VariableTreeNodeImpl[] path) {
        return new ExpressionVariableExpansionPacketImpl(thread, frame, isExpanded, path);
    }

    @Override
    protected VariableFilterPacket createVariableFilterPacket(boolean showStatics, boolean showConstants, boolean showSynthetics, boolean showLogicalStructures) {
        return new ExpressionVariableFilterPacketImpl(showStatics, showConstants, showSynthetics, showLogicalStructures);
    }

    @Override
    protected VariableSelectPacket createVariableSelectPacket(long thread, int frame, boolean isSelected, VariableTreeNodeImpl[][] paths) {
        return new ExpressionVariableSelectPacketImpl(thread, frame, isSelected, paths);
    }

    @Override
    protected boolean rootNodeEditable() {
        return false;
    }

    @Override
    protected void rootContextMenuItemSelected(JMenuItem item, String name, int index) {
        if (item == this.changeExpressionContextMenuItem) {
            String input = (String)JOptionPane.showInputDialog(this.getList(), "Please enter the new expression:", "Change Expression", 3, null, null, name);
            if (input != null) {
                QueueHelper.put(this.getController().getWriteQueue(), new ChangeExpressionPacketImpl(this.getThreadId(), this.getFrameIndex(), input, index));
            }
        } else if (item == this.removeExpressionContextMenuItem) {
            QueueHelper.put(this.getController().getWriteQueue(), new RemoveExpressionPacketImpl(this.getThreadId(), this.getFrameIndex(), name, index));
        }
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ExpressionManager.this.addExpressionToolBarButton) {
                String input = (String)JOptionPane.showInputDialog(ExpressionManager.this.getList(), "Please enter the new expression:", "Add Expression", 3, null, null, null);
                if (input != null) {
                    QueueHelper.put(ExpressionManager.this.getController().getWriteQueue(), new AddExpressionPacketImpl(ExpressionManager.this.getThreadId(), ExpressionManager.this.getFrameIndex(), input));
                }
            } else if (e.getSource() == ExpressionManager.this.removeAllExpressionsToolBarButton) {
                String[] names = ExpressionManager.this.getRootNames();
                for (int i = names.length - 1; i >= 0; --i) {
                    QueueHelper.put(ExpressionManager.this.getController().getWriteQueue(), new RemoveExpressionPacketImpl(ExpressionManager.this.getThreadId(), ExpressionManager.this.getFrameIndex(), names[i], i));
                }
            }
        }
    }
}

