/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.io.PacketFileWriter;
import com.sap.jvm.debugging.controller.io.PacketReader;
import com.sap.jvm.debugging.controller.io.PacketWriter;
import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.tasks.TaskExecutor;
import com.sap.jvm.debugging.ui.swing.PacketDispatcher;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class FrontendController {
    private static final String JOURNAL_FILE_PREFIX = System.getProperty("com.sap.jvm.debugging.controller.journal.file");
    private final PacketReader reader;
    private final Thread readerThread;
    private final PacketWriter writer;
    private final Thread writerThread;
    private final PacketDispatcher dispatcher;
    private final Thread dispatcherThread;
    private final com.sap.jvm.debugging.controller.io.PacketDispatcher testDispatcher;
    private final Thread testDispatcherThread;
    private final TaskExecutor executor;
    private final Thread executorThread;
    private final PacketFileWriter readPacketsWriter;
    private final Thread readPacketsWriterThread;
    private final PacketFileWriter writtenPacketsWriter;
    private final Thread writtenPacketsWriterThread;
    private final BlockingQueue<DebuggingPacket> readQueue;
    private final BlockingQueue<DebuggingPacket> writeQueue;
    private final BlockingQueue<DebuggingPacket> readJournalQueue;
    private final BlockingQueue<DebuggingPacket> writeJournalQueue;
    private final BlockingQueue<Runnable> taskQueue;
    private final PacketHandler handler;
    private final int majorBackendVersion;
    private final int minorBackendVersion;
    private final List<ControllerListener> listeners = new ArrayList<ControllerListener>();

    public FrontendController(InputStream in, OutputStream out, PacketHandler callback, int majorVersion, int minorVersion, boolean testMode) {
        if (majorVersion != 0) {
            String message = majorVersion > 0 ? "Debugging backend too new: Please update frontend" : "Debugging backend too old: Please update backend";
            throw new RuntimeException(message + " (frontend=" + 0 + "." + 2 + ", backend=" + majorVersion + "." + minorVersion + ")");
        }
        this.readQueue = new LinkedBlockingQueue<DebuggingPacket>();
        this.writeQueue = new LinkedBlockingQueue<DebuggingPacket>();
        this.handler = callback;
        LinkedBlockingQueue<DebuggingPacket> tmpReadJournal = null;
        PacketFileWriter tmpReadJournalWriter = null;
        Thread tmpReadJournalThread = null;
        LinkedBlockingQueue<DebuggingPacket> tmpWriteJournal = null;
        PacketFileWriter tmpWriteJournalWriter = null;
        Thread tmpWriteJournalThread = null;
        if (JOURNAL_FILE_PREFIX != null) {
            LinkedBlockingQueue<DebuggingPacket> tmp = new LinkedBlockingQueue<DebuggingPacket>();
            try {
                tmpReadJournalWriter = new PacketFileWriter(JOURNAL_FILE_PREFIX + ".read.gz", tmp);
                tmpReadJournalThread = new Thread((Runnable)tmpReadJournalWriter, "JournalWriter: read packets");
                tmpReadJournal = tmp;
            }
            catch (IOException e) {
                Trace.error((Throwable)e, (String)"Exception while creating read journal writer");
            }
            tmp = new LinkedBlockingQueue();
            try {
                tmpWriteJournalWriter = new PacketFileWriter(JOURNAL_FILE_PREFIX + ".write.gz", tmp);
                tmpWriteJournalThread = new Thread((Runnable)tmpWriteJournalWriter, "JournalWriter: written packets");
                tmpWriteJournal = tmp;
            }
            catch (IOException e) {
                Trace.error((Throwable)e, (String)"Exception while creating write journal writer");
            }
        }
        this.readJournalQueue = tmpReadJournal;
        this.readPacketsWriter = tmpReadJournalWriter;
        this.readPacketsWriterThread = tmpReadJournalThread;
        this.writeJournalQueue = tmpWriteJournal;
        this.writtenPacketsWriter = tmpWriteJournalWriter;
        this.writtenPacketsWriterThread = tmpWriteJournalThread;
        this.reader = new PacketReader(in, this.readQueue, this.readJournalQueue, null);
        this.readerThread = new Thread((Runnable)this.reader, "PacketReader");
        this.writer = new PacketWriter(out, this.writeQueue, this.writeJournalQueue, null);
        this.writerThread = new Thread((Runnable)this.writer, "PacketWriter");
        if (testMode) {
            this.taskQueue = new LinkedBlockingQueue<Runnable>();
            this.dispatcher = null;
            this.dispatcherThread = null;
            this.testDispatcher = new com.sap.jvm.debugging.controller.io.PacketDispatcher(this.readQueue, this.taskQueue, this.handler, null);
            this.testDispatcherThread = new Thread((Runnable)this.testDispatcher, "PacketDispatcher (test-mode)");
            this.executor = new TaskExecutor(this.taskQueue, null);
            this.executorThread = new Thread((Runnable)this.executor, "TaskExecutor (test-mode)");
        } else {
            this.taskQueue = null;
            this.dispatcher = new PacketDispatcher(this.readQueue, this.handler, null);
            this.dispatcherThread = new Thread((Runnable)this.dispatcher, "PacketDispatcher");
            this.testDispatcher = null;
            this.testDispatcherThread = null;
            this.executor = null;
            this.executorThread = null;
            this.reader.addListener(new PacketReader.PacketReaderListener(){

                @Override
                public void finished(IOException exception) {
                    try {
                        FrontendController.this.stop();
                    }
                    catch (IOException e) {
                        Trace.error((Throwable)e, (String)"Shutting down debugging frontend failed.");
                    }
                }
            });
        }
        this.majorBackendVersion = majorVersion;
        this.minorBackendVersion = minorVersion;
    }

    public void start() {
        this.readerThread.start();
        this.writerThread.start();
        if (this.dispatcherThread != null) {
            this.dispatcherThread.start();
        }
        if (this.testDispatcherThread != null) {
            this.testDispatcherThread.start();
        }
        if (this.executorThread != null) {
            this.executorThread.start();
        }
        if (JOURNAL_FILE_PREFIX != null) {
            this.readPacketsWriterThread.start();
            this.writtenPacketsWriterThread.start();
        }
    }

    public void stop() throws IOException {
        IOException exception = null;
        this.reader.stop();
        try {
            this.writer.stop();
        }
        catch (IOException e) {
            exception = e;
        }
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.testDispatcher != null) {
            this.testDispatcher.stop();
        }
        if (this.executor != null) {
            this.executor.stop();
        }
        if (JOURNAL_FILE_PREFIX != null) {
            this.readPacketsWriter.stop();
            this.writtenPacketsWriter.stop();
        }
        for (ControllerListener l : this.listeners.toArray(new ControllerListener[0])) {
            l.finished();
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void finishJournal() {
        if (JOURNAL_FILE_PREFIX != null) {
            this.readPacketsWriter.stop();
            this.writtenPacketsWriter.stop();
            while (!this.readPacketsWriter.isFinished() || !this.writtenPacketsWriter.isFinished()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public BlockingQueue<DebuggingPacket> getWriteQueue() {
        return this.writeQueue;
    }

    public int getMajorBackendVersion() {
        return this.majorBackendVersion;
    }

    public int getMinorBackendVersion() {
        return this.minorBackendVersion;
    }

    public void addListener(ControllerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ControllerListener l) {
        this.listeners.remove(l);
    }

    public static interface ControllerListener {
        public void finished();
    }
}

