/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.DebuggingController;
import com.sap.jvm.debugging.controller.DebuggingControllerFactory;
import com.sap.jvm.debugging.controller.io.CloudDebuggingPoller;
import com.sap.jvm.debugging.controller.packets.ConnectPacketImpl;
import com.sap.jvm.debugging.controller.packets.ConnectToPidPacketImpl;
import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.ShutdownPacketImpl;
import com.sap.jvm.debugging.controller.packets.StartDebuggingPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointParser;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import com.sap.jvm.debugging.ui.swing.BreakpointManager;
import com.sap.jvm.debugging.ui.swing.ExpressionManager;
import com.sap.jvm.debugging.ui.swing.FrontendController;
import com.sap.jvm.debugging.ui.swing.LocalsManager;
import com.sap.jvm.debugging.ui.swing.PacketHandlerImpl;
import com.sap.jvm.debugging.ui.swing.ThreadManager;
import com.sap.jvm.debugging.ui.swing.dialog.AboutDialog;
import com.sap.jvm.debugging.ui.swing.dialog.CloudConnectionDialog;
import com.sap.jvm.debugging.ui.swing.dialog.ConnectionDialog;
import com.sap.jvm.debugging.ui.swing.dialog.ReturnValueConfigurationDialog;
import com.sap.jvm.debugging.ui.swing.dialog.RunningJvmDialog;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.inspector.cluster.ProfilingCluster;
import com.sap.jvm.inspector.debugging.RemoteDebuggingBackendProvider;
import com.sap.jvm.monitor.remoteCluster.RemoteCluster;
import com.sap.jvm.monitor.remoteCluster.RemoteVm;
import com.sap.jvm.monitor.vm.DebugState;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.tools.util.desktop.PlatformUtil;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.cloud.CloudService;
import com.sap.jvm.util.cloud.CloudServiceFactory;
import com.sap.jvm.util.concurrent.QueueHelper;
import com.sap.jvm.util.http.Result;
import com.sap.jvm.util.misc.PipedSocket;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URISyntaxException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class JvmDebugger {
    public static final String VERSION = "2.4.14";
    public static final String TITLE = "SAP JVM Debugger";
    private static final String SAPJVM_BACKEND = "SAPJVM-Backend";
    private static final boolean TRACE = Boolean.getBoolean("com.sap.jvm.debugging.controller.version.trace");
    private static final int BACKEND_PORT = Integer.getInteger("com.sap.jvm.debugging.controller.backend.port", 2345);
    private static final int BACKEND_RANGE = Integer.getInteger("com.sap.jvm.debugging.controller.backend.range", 10);
    private static final boolean USE_PIPES_FOR_LOCAL_BACKEND = !Boolean.getBoolean("com.sap.jvm.debugging.controller.no.pipes");
    private static final String LOG_FILE_KEY = "log_file";
    private static final boolean isMacOS = System.getProperty("os.name").startsWith("Mac OS X");
    private static int majorVersion = -1;
    private static int minorVersion = -1;
    public static final int jdkVersion;

    private static String printStackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    public static void main(String[] args) throws IOException {
        SwingUtilities.invokeLater(() -> JvmDebugger.checkedStart(args));
    }

    static void checkedStart(String[] args) {
        try {
            JvmDebugger.start(args);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, new JTextArea(JvmDebugger.printStackTraceToString(t)), "Error", 0);
            System.exit(-1);
        }
    }

    public static void start(String[] args) throws IOException {
        PlatformUtil.initializeApp(TITLE, ImageRepository.getImage("resources/debugger.png", "Debugger big").getImage());
        boolean nimbusSet = false;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                nimbusSet = true;
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            Trace.error((Throwable)e, (String)"Error installing nimbus look&feel");
        }
        if (!nimbusSet) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                Trace.error((Throwable)e, (String)"Error installing platform look&feel");
            }
        }
        JFrame frame = new JFrame(TITLE);
        PlatformUtil.initializeFrame(frame, f -> AboutDialog.show(f));
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(ImageRepository.getImage("resources/debugger.gif", "Debugger small").getImage());
        icons.add(ImageRepository.getImage("resources/debugger-32.png", "Debugger 32").getImage());
        icons.add(ImageRepository.getImage("resources/debugger-48.png", "Debugger 48").getImage());
        icons.add(ImageRepository.getImage("resources/debugger.png", "Debugger big").getImage());
        frame.setIconImages(icons);
        frame.setDefaultCloseOperation(3);
        ThreadManager threadManager = new ThreadManager();
        JComponent threads = threadManager.getTree();
        threads.setPreferredSize(new Dimension(500, 300));
        final JTabbedPane localsAndBreakpoints = new JTabbedPane();
        LocalsManager localsManager = new LocalsManager();
        JComponent locals = localsManager.getList();
        locals.setPreferredSize(new Dimension(500, 300));
        JvmDebugger.addTab(localsAndBreakpoints, "Variables", ImageRepository.getImage("resources/variables.gif", "Variables"), locals);
        BreakpointManager breakpointManager = new BreakpointManager();
        threadManager.setBreakpointManager(breakpointManager);
        localsManager.setBreakpointManager(breakpointManager);
        final JComponent breakpoints = breakpointManager.getList();
        breakpoints.setPreferredSize(new Dimension(500, 300));
        JvmDebugger.addTab(localsAndBreakpoints, "Breakpoints", ImageRepository.getImage("resources/breakpoints.gif", "Breakpoints"), breakpoints);
        ExpressionManager expressionManager = new ExpressionManager();
        expressionManager.setBreakpointManager(breakpointManager);
        final JComponent expressions = expressionManager.getList();
        expressions.setPreferredSize(new Dimension(500, 300));
        JvmDebugger.addTab(localsAndBreakpoints, "Expressions", ImageRepository.getImage("resources/expressions.gif", "Expressions"), expressions);
        JSplitPane topSplit = new JSplitPane(1, true, threads, localsAndBreakpoints);
        topSplit.setOneTouchExpandable(true);
        SourceCodeManager sources = new SourceCodeManager(new Runnable(){

            @Override
            public void run() {
                localsAndBreakpoints.setSelectedComponent(expressions);
            }
        }, new Runnable(){

            @Override
            public void run() {
                localsAndBreakpoints.setSelectedComponent(breakpoints);
            }
        }, breakpointManager);
        threadManager.setSourceCodeManager(sources);
        breakpointManager.setSourceCodeManager(sources);
        JComponent sourceCode = sources.getSource();
        sourceCode.setPreferredSize(new Dimension(800, 450));
        JSplitPane mainSplit = new JSplitPane(0, true, topSplit, sourceCode);
        mainSplit.setOneTouchExpandable(true);
        final SwingDebugger debugger = new SwingDebugger(threadManager, localsManager, breakpointManager, expressionManager, sources);
        threadManager.setContext(debugger);
        breakpointManager.setContext(debugger);
        sources.setContext(debugger);
        localsManager.setContext(debugger);
        if (SwingDebugger.DEFAULT_PROPERTY_LOCATION.exists()) {
            debugger.importProperties(SwingDebugger.DEFAULT_PROPERTY_LOCATION);
        }
        frame.getContentPane().add(mainSplit);
        JvmDebugger.addMenuBar(frame, debugger);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                debugger.exportProperties(SwingDebugger.DEFAULT_PROPERTY_LOCATION);
                debugger.disableLogging();
            }
        });
        if (args.length > 0) {
            try {
                JvmDebugger.connect(args, frame, debugger);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(frame, e.getClass().getName() + (e.getMessage() == null ? "" : ": " + e.getMessage()), "Exception occurred while setting up connection", 0);
                System.exit(1);
            }
        }
    }

    private static void addMenuBar(final JFrame frame, final SwingDebugger debugger) {
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        JMenuItem importConfig = new JMenuItem("Import Configuration...", ImageRepository.getImage("resources/import.gif", "Import"));
        importConfig.setMnemonic(73);
        importConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle("Import Debugger Configuration");
                int result = chooser.showOpenDialog(frame);
                if (result == 0 && chooser.getSelectedFile().exists()) {
                    debugger.importProperties(chooser.getSelectedFile());
                }
            }
        });
        menu.add(importConfig);
        JMenuItem exportConfig = new JMenuItem("Export Configuration...", ImageRepository.getImage("resources/export.gif", "Export"));
        exportConfig.setMnemonic(69);
        exportConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(){
                    private static final long serialVersionUID = 115390083946075681L;

                    @Override
                    public void approveSelection() {
                        int result;
                        File file = this.getSelectedFile();
                        if (file != null && file.exists() && (result = JOptionPane.showConfirmDialog(this, "The selected file already exists. Do you want to overwrite it?", "Overwrite Existing File?", 0)) == 1) {
                            return;
                        }
                        super.approveSelection();
                    }
                };
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle("Export Debugger Configuration");
                int result = chooser.showSaveDialog(frame);
                if (result == 0) {
                    debugger.exportProperties(chooser.getSelectedFile());
                }
            }
        });
        menu.add(exportConfig);
        JMenuItem removeConfig = new JMenuItem("Clear Configuration", ImageRepository.getImage("resources/remove_grey_all.gif", "Remove Configuration"));
        removeConfig.setMnemonic(67);
        removeConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                debugger.clearProperties();
            }
        });
        menu.add(removeConfig);
        menu.addSeparator();
        final JCheckBoxMenuItem loggingConfig = new JCheckBoxMenuItem("Log Messages...", ImageRepository.getImage("resources/logging.gif", "Logging"));
        loggingConfig.setMnemonic(76);
        loggingConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (loggingConfig.isSelected()) {
                    String initialSelection = debugger.getProperties().getProperty(JvmDebugger.LOG_FILE_KEY);
                    JFileChooser chooser = new JFileChooser(){
                        private static final long serialVersionUID = 7026628735124406387L;

                        @Override
                        public void approveSelection() {
                            int result;
                            File file = this.getSelectedFile();
                            if (file != null && file.exists() && (result = JOptionPane.showConfirmDialog(this, "The selected file already exists. Do you want to overwrite it?", "Overwrite Existing File?", 0)) == 1) {
                                return;
                            }
                            super.approveSelection();
                        }
                    };
                    if (initialSelection != null) {
                        chooser.setSelectedFile(new File(initialSelection));
                    }
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileSelectionMode(0);
                    chooser.setDialogTitle("Log File Configuration");
                    int result = chooser.showSaveDialog(frame);
                    if (result == 0) {
                        String fileName = chooser.getSelectedFile().toString();
                        debugger.getProperties().setProperty(JvmDebugger.LOG_FILE_KEY, fileName);
                        debugger.enableLogging(fileName);
                    }
                } else {
                    debugger.disableLogging();
                }
            }
        });
        menu.add(loggingConfig);
        if (!isMacOS) {
            menu.addSeparator();
            JMenuItem about = new JMenuItem("About");
            about.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog.show(frame);
                }
            });
            menu.add(about);
            JMenuItem exit = new JMenuItem("Exit");
            exit.setMnemonic(88);
            exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    frame.dispatchEvent(new WindowEvent(frame, 201));
                }
            });
            menu.add(exit);
        }
        bar.add(menu);
        frame.setJMenuBar(bar);
    }

    private static void addTab(JTabbedPane pane, String title, Icon icon, JComponent component) {
        pane.addTab(title, icon, component);
        try {
            Method setTabAt = pane.getClass().getMethod("setTabComponentAt", Integer.TYPE, Component.class);
            JLabel label = new JLabel(title);
            label.setIcon(icon);
            label.setIconTextGap(5);
            label.setHorizontalTextPosition(4);
            setTabAt.invoke((Object)pane, pane.getTabCount() - 1, label);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static void connect(String[] args, JFrame frame, SwingDebugger context) {
        if (args.length == 1 && "-cloud".equals(args[0])) {
            JvmDebugger.createCloudController(context, true);
        } else {
            JvmDebugger.createManualController(args, context, true);
        }
    }

    public static void createCloudController(SwingDebugger context) {
        JvmDebugger.createCloudController(context, false);
    }

    private static void createCloudController(SwingDebugger context, boolean exitOnCancel) {
        JFrame frame = JvmDebugger.getFrame(context);
        CloudConnectionDialog dialog = new CloudConnectionDialog(frame, context);
        if (!dialog.show()) {
            if (exitOnCancel) {
                System.err.println("Debugging cloud connection dialog aborted.");
                System.exit(0);
            }
            return;
        }
        String landscapeURL = dialog.getLandscapeUrl();
        String accountName = dialog.getAccountName();
        String applicationName = dialog.getApplicationName();
        String componentName = dialog.getComponentName();
        context.setName(accountName + ":" + applicationName + ":" + componentName + " [" + landscapeURL + "]");
        final CloudService cloudService = CloudServiceFactory.createDebuggingService(landscapeURL, dialog.getUserName(), dialog.getPassword(), dialog.getProxy(), accountName, applicationName, componentName);
        try {
            cloudService.start();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Debugging-Frontend-Major-Version", Integer.toString(0));
            headers.put("Debugging-Frontend-Minor-Version", Integer.toString(2));
            Result connectResult = cloudService.connect(headers);
            majorVersion = connectResult.getMajorServerVersion();
            minorVersion = connectResult.getMinorServerVersion();
        }
        catch (IOException | URISyntaxException e) {
            JvmDebugger.disconnectCloud(cloudService);
            throw new RuntimeException(e);
        }
        CloudDebuggingPoller poller = new CloudDebuggingPoller(cloudService, null);
        FrontendController controller = new FrontendController(poller.getInputStream(), poller.getOutputStream(), context.handler, majorVersion, minorVersion, false);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JvmDebugger.disconnectCloud(cloudService);
            }
        });
        System.setProperty("com.sap.jvm.debugging.ui.backend.keepalive", "true");
        JvmDebugger.establishConnectionCommon(controller, context, null);
    }

    public static void createManualController(SwingDebugger context) {
        JvmDebugger.createManualController(new String[0], context, false);
    }

    private static void createManualController(String[] args, SwingDebugger context, boolean exitOnCancel) {
        JFrame frame = JvmDebugger.getFrame(context);
        DebuggingPacket initialPacket = null;
        String debugAddressTarget = null;
        Object backendAddressTarget = null;
        boolean spawnBackend = false;
        if (args.length == 0) {
            ConnectionDialog dialog = new ConnectionDialog(frame, context);
            if (!dialog.show()) {
                if (exitOnCancel) {
                    System.err.println("Debugging connection dialog aborted.");
                    System.exit(0);
                }
                return;
            }
            debugAddressTarget = dialog.getDebuggeeAddress();
            backendAddressTarget = dialog.getBackendAddress();
            spawnBackend = dialog.spawnBackend();
            assert (spawnBackend && backendAddressTarget == null || !spawnBackend && backendAddressTarget != null);
        } else if (args[0].equals("-p") && args.length == 2) {
            initialPacket = new ConnectToPidPacketImpl(Integer.parseInt(args[1]));
            spawnBackend = true;
            context.setName("localhost (pid " + args[1] + ")");
        } else {
            String string = debugAddressTarget = args.length > 0 ? args[0] : JOptionPane.showInputDialog(frame, "Debugging target address and port", "Remote Host", 3);
            if (debugAddressTarget == null) {
                System.err.println("Debugging address selection aborted.");
                System.exit(0);
                return;
            }
            Object object = backendAddressTarget = args.length > 1 ? args[1] : JOptionPane.showInputDialog(frame, "Debugging backend address and port", "Backend Host", 3);
            if (backendAddressTarget == null) {
                System.err.println("Backend address selection aborted.");
                System.exit(0);
                return;
            }
            boolean bl = spawnBackend = args.length > 2 ? "spawn".equals(args[2]) : spawnBackend;
        }
        if (debugAddressTarget != null) {
            boolean omitConnect = false;
            String[] strings = debugAddressTarget.split(":");
            if (debugAddressTarget.equals("-") || debugAddressTarget.equals("-:-")) {
                omitConnect = true;
            } else if (strings.length != 2 || strings[0].trim().length() == 0 || strings[1].trim().length() == 0) {
                System.err.println("Illegal debugging address: " + debugAddressTarget);
                System.exit(0);
            }
            if (!omitConnect) {
                String address = strings[0].trim();
                int port = Integer.parseInt(strings[1]);
                assert (address != null && port > 0);
                initialPacket = new ConnectPacketImpl(address, port);
                context.setName(address + ":" + port);
            }
        }
        if (spawnBackend) {
            backendAddressTarget = JvmDebugger.spawnDebuggingBackendLocally();
        }
        if (context.getName().equals("<not connected>")) {
            context.setName(backendAddressTarget instanceof String ? (String)backendAddressTarget : "<unknown connection endpoint>");
        }
        JvmDebugger.connectToDebuggingBackend(context, backendAddressTarget, initialPacket);
    }

    private static void connectToDebuggingBackend(SwingDebugger context, Object backendAddressTarget, DebuggingPacket initialPacket) {
        if (backendAddressTarget instanceof SocketAdapter) {
            SocketAdapter socket = (SocketAdapter)backendAddressTarget;
            try {
                JvmDebugger.performHandshake(socket);
                FrontendController controller = new FrontendController(socket.getInputStream(), socket.getOutputStream(), context.handler, majorVersion, minorVersion, false);
                JvmDebugger.establishConnectionCommon(controller, context, initialPacket);
            }
            catch (IOException e) {
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    Trace.error((Throwable)e2, (String)"Error while closing the connection");
                }
                throw new RuntimeException(e);
            }
            return;
        }
        if (!(backendAddressTarget instanceof String)) {
            throw new IllegalArgumentException("Unknown debugging backend address type: " + backendAddressTarget.getClass());
        }
        String[] strings = ((String)backendAddressTarget).split(":");
        if (strings.length != 2 || strings[0].trim().length() == 0 || strings[1].trim().length() == 0) {
            System.err.println("Illegal backend address: " + backendAddressTarget);
            System.exit(0);
        }
        String backendAddress = strings[0].trim();
        int backendPort = Integer.parseInt(strings[1]);
        Socket socket = null;
        try {
            socket = new Socket(backendAddress, backendPort);
            JvmDebugger.performHandshake(SocketAdapterFactory.getForSocket((Socket)socket));
            FrontendController controller = new FrontendController(socket.getInputStream(), socket.getOutputStream(), context.handler, majorVersion, minorVersion, false);
            JvmDebugger.establishConnectionCommon(controller, context, initialPacket);
        }
        catch (IOException e) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    Trace.error((Throwable)e1, (String)"Error while closing the connection");
                }
            }
            throw new RuntimeException(e);
        }
    }

    private static Object spawnDebuggingBackendLocally() {
        if (USE_PIPES_FOR_LOCAL_BACKEND) {
            try {
                final PipedSocket ps = new PipedSocket();
                Thread backendThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DebuggingController controller = DebuggingControllerFactory.establishConnection(ps.leftSide(), true);
                            controller.shutdownOnError(true);
                        }
                        catch (IOException e) {
                            Trace.error((Throwable)e, (String)"Error while establishing local debugging connection");
                        }
                    }
                }, "Debugging Backend Starter");
                backendThread.setDaemon(true);
                backendThread.start();
                return ps.rightSide();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ServerSocket socket = null;
        int localBackendPort = -1;
        for (int i = 0; i < BACKEND_RANGE; ++i) {
            localBackendPort = BACKEND_PORT + i;
            try {
                socket = new ServerSocket(localBackendPort);
                break;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (socket == null) {
            System.err.println("Unable to launch debugging backend locally in port range [" + BACKEND_PORT + ".." + (BACKEND_PORT + BACKEND_RANGE) + "].");
            System.exit(0);
        }
        final ServerSocket serverSocket = socket;
        Thread spawnThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DebuggingController controller = DebuggingControllerFactory.establishConnection(serverSocket, true);
                    controller.shutdownOnError(true);
                }
                catch (IOException e) {
                    Trace.error((Throwable)e, (String)"Error while establishing local debugging connection");
                    System.exit(0);
                }
            }
        }, "Debugging Backend Starter");
        spawnThread.setDaemon(true);
        spawnThread.start();
        return "localhost:" + localBackendPort;
    }

    private static void establishConnectionCommon(final FrontendController controller, final SwingDebugger context, DebuggingPacket initialPacket) {
        if (controller == null) {
            return;
        }
        if (TRACE) {
            Trace.debug((String)"Connection established: frontend version=%d.%d, backend version=%d.%d", (Object[])new Object[]{0, 2, majorVersion, minorVersion});
        }
        FrontendController.ControllerListener terminationListener = new FrontendController.ControllerListener(){

            @Override
            public void finished() {
                context.reset();
                JOptionPane.showMessageDialog(null, "The debugged program terminated.", "Program termination", 1);
            }
        };
        controller.addListener(terminationListener);
        if (initialPacket != null) {
            QueueHelper.put(controller.getWriteQueue(), initialPacket);
        }
        context.threads.setController(controller);
        context.threads.setControllerListener(terminationListener);
        context.locals.setController(controller);
        context.breakpoints.setController(controller);
        context.expressions.setController(controller);
        context.sources.setController(controller);
        JvmDebugger.handleInitialBreakpoints(controller.getWriteQueue());
        controller.start();
        JvmDebugger.getFrame(context).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!Boolean.getBoolean("com.sap.jvm.debugging.ui.backend.keepalive")) {
                    QueueHelper.put(controller.getWriteQueue(), new ShutdownPacketImpl());
                }
                controller.finishJournal();
            }
        });
    }

    public static void createControllerUsingBrowser(SwingDebugger context) {
        String name;
        JFrame frame = JvmDebugger.getFrame(context);
        RunningJvmDialog dialog = new RunningJvmDialog(frame, context);
        if (!dialog.show()) {
            return;
        }
        boolean isLocal = dialog.getSelectedHost() == null;
        DebuggingPacket initialPacket = null;
        int debuggeePort = -1;
        if (isLocal && dialog.supportsFileSockets()) {
            initialPacket = new ConnectToPidPacketImpl(dialog.getSelectedProcessId());
            name = "localhost (pid " + dialog.getSelectedProcessId() + ")";
        } else {
            block30: {
                Vm vm;
                if (isLocal) {
                    vm = ProfilingCluster.getVm((int)dialog.getSelectedProcessId());
                } else {
                    try {
                        Registry registry = LocateRegistry.getRegistry(dialog.getSelectedHost(), dialog.getSelectedPort());
                        RemoteCluster cluster = (RemoteCluster)registry.lookup("RemoteCluster");
                        RemoteVm remoteVm = cluster.getVm(dialog.getSelectedProcessId());
                        vm = cluster.getVm(remoteVm);
                    }
                    catch (RemoteException e) {
                        Trace.error((Throwable)e, (String)"Error while retrieving handle to remote debuggee");
                        JOptionPane.showMessageDialog(frame, "Error while establishing the debugging connection:\n" + e.getMessage() + " (" + e.getClass().getName() + ")\nPlease, ensure that jvmmond is still running", "Connection Error", 0);
                        return;
                    }
                    catch (NotBoundException e) {
                        Trace.error((Throwable)e, (String)"Error while retrieving handle to remote debuggee");
                        JOptionPane.showMessageDialog(frame, "Error while establishing the debugging connection:\n" + e.getMessage() + " (" + e.getClass().getName() + ")\nPlease, ensure that jvmmond is still running", "Connection Error", 0);
                        return;
                    }
                }
                if (vm == null) {
                    JOptionPane.showMessageDialog(frame, "Could not establish a connection to the VM. Process with pid " + dialog.getSelectedProcessId() + " seems to be gone.", "Connection Error", 0);
                    return;
                }
                try {
                    if (vm.getDebugInfo().getDebugState() == DebugState.STATE_DEBUGGER_ATTACHED) {
                        if (JOptionPane.showConfirmDialog(frame, "The selected VM is being debugged. Do you want to stop the ongoing debugging session?", "Warning", 0) != 0) {
                            return;
                        }
                        vm.stopDebug();
                        int counter = 0;
                        while (vm.getDebugInfo().getDebugState() != DebugState.STATE_NOT_ACTIVE && counter++ < 20) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException cluster) {}
                        }
                    }
                    if (vm.getDebugInfo().getDebugState() == DebugState.STATE_NOT_ACTIVE) {
                        DebugState state;
                        vm.startDebug(SuspendPolicy.SUSPEND_NONE);
                        int counter = 0;
                        while ((state = vm.getDebugInfo().getDebugState()) != DebugState.STATE_WAIT_FOR_DEBUGGER && counter++ < 20) {
                            if (state == DebugState.STATE_DEBUGGER_ATTACHED) {
                                JOptionPane.showMessageDialog(frame, "Another debugger has already been attached to the selected VM.", "Connection Error", 0);
                                return;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException remoteVm) {}
                        }
                        if (vm.getDebugInfo().getDebugState() != DebugState.STATE_WAIT_FOR_DEBUGGER) {
                            JOptionPane.showMessageDialog(frame, "Timeout while enabling debugging (possibly invalid VM state).", "Connection Error", 0);
                            return;
                        }
                        debuggeePort = vm.getDebugInfo().getDebugPort();
                        break block30;
                    }
                    if (vm.getDebugInfo().getDebugState() == DebugState.STATE_WAIT_FOR_DEBUGGER) {
                        debuggeePort = vm.getDebugInfo().getDebugPort();
                        break block30;
                    }
                    JOptionPane.showMessageDialog(frame, "Invalid VM state (" + vm.getDebugInfo().getDebugState() + ").", "Connection Error", 0);
                    return;
                }
                catch (InvalidVmException e) {
                    Trace.error((Throwable)e, (String)"Error while setting up debuggee VM");
                    JOptionPane.showMessageDialog(frame, "The state of the selected VM has changed.", "Connection Error", 0);
                    return;
                }
            }
            name = (isLocal ? "localhost" : dialog.getSelectedHost()) + ":" + debuggeePort;
        }
        Object debuggingBackendAddress = null;
        if (!isLocal) {
            try {
                Registry registry = LocateRegistry.getRegistry(dialog.getSelectedHost(), dialog.getSelectedPort());
                RemoteDebuggingBackendProvider provider = (RemoteDebuggingBackendProvider)registry.lookup("RemoteDebuggingProvider");
                int backendPort = provider.createDebuggingBackend("localhost", debuggeePort, false);
                if (backendPort > 0) {
                    debuggingBackendAddress = dialog.getSelectedHost() + ":" + backendPort;
                }
            }
            catch (RemoteException e) {
                Trace.debug((Throwable)e, () -> "Error while spawning debugging backend on host " + dialog.getSelectedHost() + ", falling back to local debugging backend");
            }
            catch (NotBoundException e) {
                Trace.debug((Throwable)e, () -> "Error while spawning debugging backend on host " + dialog.getSelectedHost() + ", falling back to local debugging backend");
            }
        }
        if (debuggingBackendAddress == null) {
            debuggingBackendAddress = JvmDebugger.spawnDebuggingBackendLocally();
            if (initialPacket == null) {
                initialPacket = new ConnectPacketImpl(isLocal ? "localhost" : dialog.getSelectedHost(), debuggeePort);
            }
        }
        context.setName(name);
        JvmDebugger.connectToDebuggingBackend(context, debuggingBackendAddress, initialPacket);
    }

    private static void disconnectCloud(CloudService cloudService) {
        try {
            cloudService.disconnect();
            cloudService.stop();
        }
        catch (IOException exc) {
            System.err.println("Error while stopping debugging session: " + exc.getMessage());
        }
        catch (URISyntaxException exc) {
            System.err.println("Error while stopping debugging session: URISyntaxException " + exc.getMessage());
        }
    }

    private static JFrame getFrame(SwingDebugger context) {
        return (JFrame)SwingUtilities.getRoot(context.threads.getTree());
    }

    private static void performHandshake(SocketAdapter socket) throws IOException {
        int result;
        DataOutputStream dataOut = new DataOutputStream(socket.getOutputStream());
        dataOut.write(JvmDebugger.getBytes(SAPJVM_BACKEND));
        dataOut.writeInt(0);
        dataOut.writeInt(2);
        dataOut.flush();
        byte[] handshake = new byte[SAPJVM_BACKEND.length()];
        int offset = 0;
        for (int length = handshake.length; length > 0; length -= result) {
            result = socket.getInputStream().read(handshake, offset, length);
            if (result < 0) {
                throw new IOException("Connection closed before end of handshake");
            }
            offset += result;
        }
        if (!Arrays.equals(handshake, JvmDebugger.getBytes(SAPJVM_BACKEND))) {
            throw new IOException("Received unexpected handshake: " + Arrays.toString(handshake));
        }
        DataInputStream dataIn = new DataInputStream(socket.getInputStream());
        majorVersion = dataIn.readInt();
        minorVersion = dataIn.readInt();
    }

    private static byte[] getBytes(String value) {
        byte[] result = new byte[value.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)value.charAt(i);
        }
        return result;
    }

    private static void handleInitialBreakpoints(BlockingQueue<DebuggingPacket> writeQueue) {
        ArrayList<BreakpointSpecification> specs = new ArrayList<BreakpointSpecification>();
        JvmDebugger.handleBreakpoints(specs, BreakpointType.EXCEPTION, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.exceptions"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.METHOD_ENTRY, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.methodentry"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.ABSOLUTE_METHOD_LINE, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.absolutemethod"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.RELATIVE_METHOD_LINE, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.relativemethod"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.WATCH_POINT, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.watch"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.LINE, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.line"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.METHOD_BYTE_CODE_INDEX, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.bci"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.METHOD_EXIT, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.methodexit"));
        JvmDebugger.handleBreakpoints(specs, BreakpointType.TYPE_LINE, System.getProperty("com.sap.jvm.debugging.ui.breakpoints.typeline"));
        if (specs.size() > 0) {
            QueueHelper.put(writeQueue, new BreakpointListPacketImpl(specs.toArray(new BreakpointSpecification[specs.size()])));
        }
        QueueHelper.put(writeQueue, new StartDebuggingPacketImpl());
    }

    private static void handleBreakpoints(List<BreakpointSpecification> specs, BreakpointType type, String breakpoints) {
        if (breakpoints != null) {
            String[] bps;
            for (String b : bps = breakpoints.split(";")) {
                specs.add(BreakpointParser.deserialize(type, b));
            }
        }
    }

    static {
        String java_version = System.getProperty("java.version");
        Matcher mat = Pattern.compile("1\\.(\\d+)\\..*").matcher(java_version);
        jdkVersion = mat.matches() ? Integer.parseInt(mat.group(1)) : (java_version.startsWith("9") ? 9 : -1);
    }

    public static class SwingDebugger {
        public static final File DEFAULT_PROPERTY_LOCATION = new File(System.getProperty("user.home") + File.separator + ".debugger-config.properties");
        private static final String NOT_CONNECTED = "<not connected>";
        private final ThreadManager threads;
        private final LocalsManager locals;
        private final BreakpointManager breakpoints;
        private final ExpressionManager expressions;
        private final SourceCodeManager sources;
        private final PacketHandlerImpl handler;
        private final Properties properties = new Properties();
        private String name = "<not connected>";
        private static final Pattern[] ON_PATTERNS = new Pattern[]{Pattern.compile("com\\.sap\\.jvm\\.debugging.*")};
        private static final Pattern[] OFF_PATTERNS = new Pattern[]{Pattern.compile("com\\.sap\\.jvm\\.debugging\\.controller\\.io\\.reader\\.full.*"), Pattern.compile("com\\.sap\\.jvm\\.debugging\\.controller\\.io\\.writer\\.full.*"), Pattern.compile("com\\.sap\\.jvm\\.debugging\\.controller\\.io\\.file.*")};
        private Thread.UncaughtExceptionHandler ueh = null;

        public SwingDebugger(ThreadManager threads, LocalsManager locals, BreakpointManager breakpoints, ExpressionManager expressions, SourceCodeManager sources) {
            this.threads = threads;
            this.locals = locals;
            this.breakpoints = breakpoints;
            this.expressions = expressions;
            this.sources = sources;
            this.handler = new PacketHandlerImpl(threads, locals, breakpoints, expressions, sources);
        }

        public void reset() {
            this.threads.reset();
            this.locals.reset();
            this.breakpoints.reset();
            this.expressions.reset();
            this.sources.reset();
            this.setName(NOT_CONNECTED);
        }

        public Properties getProperties() {
            return this.properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exportProperties(File targetFile) {
            FilterOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(targetFile));
                this.properties.store(os, "sap jvm debugger configuration");
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, (String)"Error while storing debugger configuration.");
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        Trace.warn((Throwable)e, (String)"Error while storing debugger configuration.");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void importProperties(File sourceFile) {
            Properties before = new Properties();
            before.putAll((Map<?, ?>)this.properties);
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(sourceFile));
                this.properties.load(is);
                this.breakpoints.propertiesChanged();
                this.sources.propertiesChanged();
                RunningJvmDialog.propertiesChanged(this, before);
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, (String)"Error while loading debugger configuration");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Trace.warn((Throwable)e, (String)"Error while loading debugger configuration.");
                    }
                }
            }
        }

        public void clearProperties() {
            this.breakpoints.clearProperties();
            this.sources.clearProperties();
            RunningJvmDialog.clearProperties(this);
            ConnectionDialog.clearProperties(this);
            CloudConnectionDialog.clearProperties(this);
            ReturnValueConfigurationDialog.clearProperties(this);
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        public void enableLogging(String fileName) {
            for (Pattern p : ON_PATTERNS) {
                Trace.setTraceLevel((Pattern)p, (Tracer.TraceLevel)Tracer.TraceLevel.DEBUG);
            }
            for (Pattern p : OFF_PATTERNS) {
                Trace.setTraceLevel((Pattern)p, (Tracer.TraceLevel)Tracer.TraceLevel.NONE);
            }
            Trace.enableFileOutput((String)fileName, (boolean)true);
            this.ueh = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
                Trace.error((Throwable)e, () -> "Thread '" + t.getName() + "' terminated with exception");
                if (this.ueh != null) {
                    this.ueh.uncaughtException(t, e);
                }
            });
        }

        public void disableLogging() {
            Trace.disableFileOutput();
            Thread.setDefaultUncaughtExceptionHandler(this.ueh);
        }
    }
}

