/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.packets.variables.LocalVariableExpansionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableFilterPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSelectPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreeNodeImpl;
import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import com.sap.jvm.debugging.ui.swing.VariablesManager;
import com.sap.jvm.debugging.ui.swing.dialog.ReturnValueConfigurationDialog;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.util.concurrent.QueueHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public final class LocalsManager
extends VariablesManager {
    private final ActionListenerImpl buttonListener = new ActionListenerImpl();
    private final JToggleButton returnValueToolBarButton;
    private final JButton returnValueDialogToolBarButton;
    private JvmDebugger.SwingDebugger context = null;

    public LocalsManager() {
        ImageIcon returnValueIcon = ImageRepository.getImage("resources/return_value.png", "Return Values");
        this.returnValueToolBarButton = new JToggleButton(returnValueIcon, true);
        this.returnValueToolBarButton.setToolTipText("Show Return Values");
        this.returnValueToolBarButton.addActionListener(this.buttonListener);
        this.getToolbar().add(this.returnValueToolBarButton);
        ImageIcon returnValuesOptionsIcon = ImageRepository.getImage("resources/return_values_options.png", "Return Values Options");
        this.returnValueDialogToolBarButton = new JButton(returnValuesOptionsIcon);
        this.returnValueDialogToolBarButton.setToolTipText("Advanced Configuration of Return Values");
        this.returnValueDialogToolBarButton.addActionListener(this.buttonListener);
        this.getToolbar().add(this.returnValueDialogToolBarButton);
        this.finishedConstruction();
    }

    public void setContext(JvmDebugger.SwingDebugger context) {
        assert (this.context == null && context != null);
        this.context = context;
    }

    public void setLocals(LocalVariableTreePacket packet) {
        this.setVariables(packet);
    }

    @Override
    protected VariableSetPacket createVariableSetPacket(long thread, int frame, String value, VariableTreeNodeImpl[] path) {
        return new LocalVariableSetPacketImpl(thread, frame, value, path);
    }

    @Override
    protected VariableSetExpressionPacket createVariableSetExpressionPacket(long thread, int frame, String expression, VariableTreeNodeImpl[] path) {
        return new LocalVariableSetExpressionPacketImpl(thread, frame, expression, path);
    }

    @Override
    protected VariableExpansionPacket createVariableExpansionPacket(long thread, int frame, boolean isExpanded, VariableTreeNodeImpl[] path) {
        return new LocalVariableExpansionPacketImpl(thread, frame, isExpanded, path);
    }

    @Override
    protected VariableFilterPacket createVariableFilterPacket(boolean showStatics, boolean showConstants, boolean showSynthetics, boolean showLogicalStructures) {
        return new LocalVariableFilterPacketImpl(showStatics, showConstants, showSynthetics, showLogicalStructures, this.returnValueToolBarButton.isSelected(), ReturnValueConfigurationDialog.ignoreReturnValuesStoredInLocals(this.context), ReturnValueConfigurationDialog.ignoreReturnValuesUsedAsParameters(this.context), ReturnValueConfigurationDialog.ignoreReturnValuesUsedAsReceivers(this.context), ReturnValueConfigurationDialog.ignoredMethods(this.context));
    }

    @Override
    protected VariableSelectPacket createVariableSelectPacket(long thread, int frame, boolean isSelected, VariableTreeNodeImpl[][] paths) {
        return new LocalVariableSelectPacketImpl(thread, frame, isSelected, paths);
    }

    @Override
    protected boolean rootNodeEditable() {
        return true;
    }

    @Override
    protected void rootContextMenuItemSelected(JMenuItem item, String name, int index) {
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReturnValueConfigurationDialog dialog;
            if (e.getSource() == LocalsManager.this.returnValueToolBarButton) {
                ReturnValueConfigurationDialog.setShowReturnValues(LocalsManager.this.context, LocalsManager.this.returnValueToolBarButton.isSelected());
                QueueHelper.put(LocalsManager.this.getController().getWriteQueue(), LocalsManager.this.createVariableFilterPacket());
            } else if (e.getSource() == LocalsManager.this.returnValueDialogToolBarButton && (dialog = new ReturnValueConfigurationDialog((JFrame)SwingUtilities.getRoot(LocalsManager.this.getList()), LocalsManager.this.context)).show()) {
                LocalsManager.this.returnValueToolBarButton.setSelected(ReturnValueConfigurationDialog.showReturnValues(LocalsManager.this.context));
                QueueHelper.put(LocalsManager.this.getController().getWriteQueue(), LocalsManager.this.createVariableFilterPacket());
            }
        }
    }
}

