/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public final class PacketDispatcher
implements Runnable {
    public static final long POLLING_PERIOD_MS = 500L;
    private volatile boolean closed = false;
    private volatile boolean finished = false;
    private final BlockingQueue<DebuggingPacket> packetQueue;
    private final PacketHandler handler;
    private volatile long dispatchedPackets = 0L;
    private final Tracer tracer;

    public PacketDispatcher(BlockingQueue<DebuggingPacket> packets, PacketHandler handler, Object context) {
        this.packetQueue = packets;
        this.handler = handler;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.controller.io.dispatcher", (Object)context);
    }

    @Override
    public void run() {
        try {
            this.tracer.debug("Dispatcher: Waiting for new packet...");
            while (!this.closed) {
                try {
                    DebuggingPacket packet = this.packetQueue.poll(500L, TimeUnit.MILLISECONDS);
                    if (packet == null) continue;
                    this.tracer.debug("Dispatcher: Dispatching packet %s (type=%d) to run queue...", new Object[]{packet.getType(), packet.getType().get()});
                    SwingUtilities.invokeLater(new Dispatcher(this.handler, packet, this.tracer));
                    ++this.dispatchedPackets;
                    this.tracer.debug("Dispatcher: Waiting for new packet...");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.tracer.debug("Dispatcher: Stopped.");
            this.finished = true;
        }
    }

    public long getNrOfDispatchedPackets() {
        return this.dispatchedPackets;
    }

    public void stop() {
        this.tracer.debug("Dispatcher: Stopping...");
        this.closed = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private static class Dispatcher
    implements Runnable {
        private final PacketHandler handler;
        private final DebuggingPacket packet;
        private final Tracer tracer;

        public Dispatcher(PacketHandler handler, DebuggingPacket packet, Tracer tracer) {
            this.handler = handler;
            this.packet = packet;
            this.tracer = tracer;
        }

        @Override
        public void run() {
            this.tracer.debug("Dispatcher: Handling packet %s (type=%d)...", new Object[]{this.packet.getType(), this.packet.getType().get()});
            this.packet.dispatch(this.handler);
        }
    }
}

