/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.packets.ConditionalBreakpointFailurePacket;
import com.sap.jvm.debugging.controller.packets.ConnectPacket;
import com.sap.jvm.debugging.controller.packets.ConnectToPidPacket;
import com.sap.jvm.debugging.controller.packets.DisassembledClassPacket;
import com.sap.jvm.debugging.controller.packets.ExitVmPacket;
import com.sap.jvm.debugging.controller.packets.HotCodeReplacementErrorPacket;
import com.sap.jvm.debugging.controller.packets.HotCodeReplacementPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.RefreshPacket;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByNamePacket;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByThreadPacket;
import com.sap.jvm.debugging.controller.packets.ResumeAllThreadsPacket;
import com.sap.jvm.debugging.controller.packets.ResumeThreadPacket;
import com.sap.jvm.debugging.controller.packets.ShutdownPacket;
import com.sap.jvm.debugging.controller.packets.StartDebuggingPacket;
import com.sap.jvm.debugging.controller.packets.StepThreadPacket;
import com.sap.jvm.debugging.controller.packets.SuspendAllThreadsPacket;
import com.sap.jvm.debugging.controller.packets.SuspendThreadPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListDeltaPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListFilterPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListSelectPacket;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacket;
import com.sap.jvm.debugging.controller.packets.breakpoints.SkipAllBreakpointsPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddDetailFormattersPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddHoverExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddLogicalStructuresPacket;
import com.sap.jvm.debugging.controller.packets.variables.ChangeExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.DetailFormattersListPacket;
import com.sap.jvm.debugging.controller.packets.variables.EvalExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.LogicalStructuresListPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveDetailFormattersPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveHoverExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveLogicalStructurePacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableAssignmentFailurePacket;
import com.sap.jvm.debugging.ui.swing.BreakpointManager;
import com.sap.jvm.debugging.ui.swing.ExpressionManager;
import com.sap.jvm.debugging.ui.swing.LocalsManager;
import com.sap.jvm.debugging.ui.swing.ThreadManager;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import javax.swing.JOptionPane;

public class PacketHandlerImpl
implements PacketHandler {
    private final ThreadManager threadManager;
    private final LocalsManager localsManager;
    private final BreakpointManager breakpointManager;
    private final ExpressionManager expressionsManager;
    private final SourceCodeManager sourceCodeManager;

    public PacketHandlerImpl(ThreadManager manager, LocalsManager locals, BreakpointManager breakpoints, ExpressionManager expressions, SourceCodeManager source) {
        this.threadManager = manager;
        this.localsManager = locals;
        this.breakpointManager = breakpoints;
        this.expressionsManager = expressions;
        this.sourceCodeManager = source;
    }

    @Override
    public void close() {
    }

    @Override
    public void handle(ThreadListPacket packet) {
        this.threadManager.setThreads(packet);
    }

    @Override
    public void handle(ThreadListDeltaPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ConnectPacket packet) {
        assert (false);
    }

    @Override
    public void handle(SuspendAllThreadsPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ResumeAllThreadsPacket packet) {
        assert (false);
    }

    @Override
    public void handle(SuspendThreadPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ResumeThreadPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ThreadListSelectPacket packet) {
        assert (false);
    }

    @Override
    public void handle(LocalVariableTreePacket packet) {
        this.localsManager.setLocals(packet);
    }

    @Override
    public void handle(ExpressionVariableTreePacket packet) {
        this.expressionsManager.setExpressions(packet);
    }

    @Override
    public void handle(LocalVariableExpansionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ExpressionVariableExpansionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(LocalVariableFilterPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ExpressionVariableFilterPacket packet) {
        assert (false);
    }

    @Override
    public void handle(StepThreadPacket packet) {
        assert (false);
    }

    @Override
    public void handle(LocalVariableSelectPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ExpressionVariableSelectPacket packet) {
        assert (false);
    }

    @Override
    public void handle(LocalVariableSetPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ExpressionVariableSetPacket packet) {
        assert (false);
    }

    @Override
    public void handle(AddExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ChangeExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(RemoveExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(EvalExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(LocalVariableSetExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ExpressionVariableSetExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(VariableAssignmentFailurePacket packet) {
        JOptionPane.showMessageDialog(null, packet.getMessage(), "Variable Assignment Failure", 0);
    }

    @Override
    public void handle(ConditionalBreakpointFailurePacket packet) {
        JOptionPane.showMessageDialog(null, "The condition of breakpoint '" + packet.getName() + "' failed to evaluate:\n" + packet.getMessage(), "Conditional Breakpoint Failure", 0);
    }

    @Override
    public void handle(HotCodeReplacementPacket packet) {
        assert (false);
    }

    @Override
    public void handle(HotCodeReplacementErrorPacket packet) {
        JOptionPane.showMessageDialog(null, "The hot code replacement failed:\n" + packet.getMessage(), "Hot Code Replacement Error", 0);
    }

    @Override
    public void handle(ShutdownPacket packet) {
        assert (false);
    }

    @Override
    public void handle(AddDetailFormattersPacket packet) {
        assert (false);
    }

    @Override
    public void handle(RemoveDetailFormattersPacket packet) {
        assert (false);
    }

    @Override
    public void handle(DetailFormattersListPacket packet) {
        this.localsManager.setDetailFormatters(packet);
        this.expressionsManager.setDetailFormatters(packet);
    }

    @Override
    public void handle(AddLogicalStructuresPacket packet) {
        assert (false);
    }

    @Override
    public void handle(RemoveLogicalStructurePacket packet) {
        assert (false);
    }

    @Override
    public void handle(LogicalStructuresListPacket packet) {
        this.localsManager.setLogicalStructures(packet);
        this.expressionsManager.setLogicalStructures(packet);
    }

    @Override
    public void handle(RefreshPacket packet) {
        assert (false);
    }

    @Override
    public void handle(RequestDisassemblyByNamePacket packet) {
        assert (false);
    }

    @Override
    public void handle(RequestDisassemblyByThreadPacket packet) {
        assert (false);
    }

    @Override
    public void handle(DisassembledClassPacket packet) {
        this.sourceCodeManager.showDisassembly(packet);
    }

    @Override
    public void handle(ExitVmPacket packet) {
        assert (false);
    }

    @Override
    public void handle(BreakpointListPacket packet) {
        this.breakpointManager.setBreakpoints(packet);
    }

    @Override
    public void handle(HoverExpressionTreePacket packet) {
    }

    @Override
    public void handle(AddHoverExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(RemoveHoverExpressionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(HoverExpressionExpansionPacket packet) {
        assert (false);
    }

    @Override
    public void handle(HoverExpressionSelectPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ThreadListFilterPacket packet) {
        assert (false);
    }

    @Override
    public void handle(SkipAllBreakpointsPacket packet) {
        assert (false);
    }

    @Override
    public void handle(StartDebuggingPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ConnectToPidPacket packet) {
        assert (false);
    }
}

