/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.ExitVmPacketImpl;
import com.sap.jvm.debugging.controller.packets.ResumeAllThreadsPacketImpl;
import com.sap.jvm.debugging.controller.packets.ResumeThreadPacketImpl;
import com.sap.jvm.debugging.controller.packets.StepThreadPacket;
import com.sap.jvm.debugging.controller.packets.StepThreadPacketImpl;
import com.sap.jvm.debugging.controller.packets.SuspendAllThreadsPacketImpl;
import com.sap.jvm.debugging.controller.packets.SuspendThreadPacketImpl;
import com.sap.jvm.debugging.controller.packets.ThreadListFilterPacketImpl;
import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListSelectPacketImpl;
import com.sap.jvm.debugging.ui.swing.BreakpointManager;
import com.sap.jvm.debugging.ui.swing.FrontendController;
import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.concurrent.QueueHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public final class ThreadManager {
    private static boolean makeNodeVisibleOnce = !"false".equals(System.getProperty("com.sap.jvm.debugging.makeNodeVisibleOnce"));
    private JvmDebugger.SwingDebugger context = null;
    private FrontendController controller = null;
    private SourceCodeManager codeManager = null;
    private BreakpointManager breakpointManager = null;
    private FrontendController.ControllerListener terminationListener = null;
    private ThreadListPacket current = null;
    private final JPanel container;
    private final JScrollPane scrollPane;
    private final JTree tree;
    private final DefaultTreeModel model;
    private final ThreadSelectionModel selectionModel;
    private final ThreadTreeRenderer renderer;
    private final DefaultMutableTreeNode root;
    private final Map<Long, DefaultMutableTreeNode> threads = new LinkedHashMap<Long, DefaultMutableTreeNode>();
    private final JPopupMenu contextMenu;
    private final JMenuItem suspendContextMenuItem;
    private final JMenuItem resumeContextMenuItem;
    private final JMenuItem stepMinContextMenuItem;
    private final JMenuItem stepIntoContextMenuItem;
    private final JMenuItem stepOverContextMenuItem;
    private final JMenuItem stepOutContextMenuItem;
    private final JMenuItem ignoreLocationContextMenuItem;
    private final JPopupMenu connectMenu;
    private final JMenuItem browserConnectMenuItem;
    private final JMenuItem cloudConnectMenuItem;
    private final JMenuItem manualConnectMenuItem;
    private final JToolBar toolbar;
    private final JButton connectToolBarButton;
    private final JButton extendedConnectToolBarButton;
    private final JButton suspendToolBarButton;
    private final JButton resumeToolBarButton;
    private final JButton terminateToolBarButton;
    private final JButton disconnectToolBarButton;
    private final JButton stepMinToolBarButton;
    private final JButton stepIntoToolBarButton;
    private final JButton stepOverToolBarButton;
    private final JButton stepOutToolBarButton;
    private final JButton ignoreLocationToolBarButton;
    private final JToggleButton monitorsToolBarButton;
    private final JToggleButton systemThreadToolBarButton;
    private final TreeEventHandler treeListener;
    private String file = null;
    private String prefix = null;
    private int lineNumber = -1;
    private int bci = -1;
    private boolean rootSelected = false;
    private Object lastVisibleNode = null;

    public ThreadManager() {
        this.root = new DefaultMutableTreeNode("Threads");
        this.model = new DefaultTreeModel(this.root);
        this.renderer = new ThreadTreeRenderer();
        this.selectionModel = new ThreadSelectionModel();
        this.treeListener = new TreeEventHandler();
        this.contextMenu = new JPopupMenu();
        this.resumeContextMenuItem = new JMenuItem("Resume", ImageRepository.getImage("resources/resume.gif", "Resume"));
        this.resumeContextMenuItem.addActionListener(this.treeListener);
        this.contextMenu.add(this.resumeContextMenuItem);
        this.suspendContextMenuItem = new JMenuItem("Suspend", ImageRepository.getImage("resources/suspend.gif", "Suspend"));
        this.suspendContextMenuItem.addActionListener(this.treeListener);
        this.contextMenu.add(this.suspendContextMenuItem);
        this.stepMinContextMenuItem = new JMenuItem("Step Min", ImageRepository.getImage("resources/step_min.gif", "Step Min"));
        this.stepMinContextMenuItem.addActionListener(this.treeListener);
        this.contextMenu.add(this.stepMinContextMenuItem);
        this.stepIntoContextMenuItem = new JMenuItem("Step Into", ImageRepository.getImage("resources/step_into.gif", "Step Into"));
        this.stepIntoContextMenuItem.addActionListener(this.treeListener);
        this.contextMenu.add(this.stepIntoContextMenuItem);
        this.stepOverContextMenuItem = new JMenuItem("Step Over", ImageRepository.getImage("resources/step_over.gif", "Step Over"));
        this.stepOverContextMenuItem.addActionListener(this.treeListener);
        this.contextMenu.add(this.stepOverContextMenuItem);
        this.stepOutContextMenuItem = new JMenuItem("Step Out", ImageRepository.getImage("resources/step_out.gif", "Step Out"));
        this.stepOutContextMenuItem.addActionListener(this.treeListener);
        this.contextMenu.add(this.stepOutContextMenuItem);
        this.ignoreLocationContextMenuItem = new JMenuItem("Ignore Breakpoint Location", ImageRepository.getImage("resources/ignore_breakpoint_location.png", "Ignore Breakpoint Location"));
        this.ignoreLocationContextMenuItem.addActionListener(this.treeListener);
        this.contextMenu.add(this.ignoreLocationContextMenuItem);
        this.tree = new JTree(this.model);
        this.tree.setSelectionModel(this.selectionModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(this.treeListener);
        this.tree.addTreeSelectionListener(this.treeListener);
        this.tree.setCellRenderer(this.renderer);
        this.tree.setRootVisible(false);
        this.connectMenu = new JPopupMenu();
        this.browserConnectMenuItem = new JMenuItem("Connect using JVM browser...");
        this.browserConnectMenuItem.addActionListener(this.treeListener);
        this.connectMenu.add(this.browserConnectMenuItem);
        this.cloudConnectMenuItem = new JMenuItem("Connect to HANA Cloud...");
        this.cloudConnectMenuItem.addActionListener(this.treeListener);
        this.cloudConnectMenuItem.setEnabled(true);
        this.connectMenu.add(this.cloudConnectMenuItem);
        this.manualConnectMenuItem = new JMenuItem("Connect manually...");
        this.manualConnectMenuItem.addActionListener(this.treeListener);
        this.connectMenu.add(this.manualConnectMenuItem);
        this.toolbar = new JToolBar();
        this.connectToolBarButton = new JButton(ImageRepository.getImage("resources/debugger.gif", "Connect"));
        this.connectToolBarButton.setToolTipText("Connect...");
        this.connectToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.connectToolBarButton);
        this.extendedConnectToolBarButton = new JButton(ImageRepository.getImage("resources/more_options.png", "Extended Connect"));
        this.extendedConnectToolBarButton.setToolTipText("Connect...");
        this.extendedConnectToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.extendedConnectToolBarButton);
        this.toolbar.addSeparator();
        this.resumeToolBarButton = new JButton(ImageRepository.getImage("resources/resume.gif", "Resume"));
        this.resumeToolBarButton.setToolTipText("Resume (F8)");
        this.resumeToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.resumeToolBarButton);
        this.suspendToolBarButton = new JButton(ImageRepository.getImage("resources/suspend.gif", "Suspend"));
        this.suspendToolBarButton.setToolTipText("Suspend");
        this.suspendToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.suspendToolBarButton);
        this.terminateToolBarButton = new JButton(ImageRepository.getImage("resources/terminate.gif", "Terminate"));
        this.terminateToolBarButton.setToolTipText("Terminate");
        this.terminateToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.terminateToolBarButton);
        this.disconnectToolBarButton = new JButton(ImageRepository.getImage("resources/disconnect.gif", "Disconnect"));
        this.disconnectToolBarButton.setToolTipText("Disconnect");
        this.disconnectToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.disconnectToolBarButton);
        this.toolbar.addSeparator();
        this.stepMinToolBarButton = new JButton(ImageRepository.getImage("resources/step_min.gif", "Step Min"));
        this.stepMinToolBarButton.setToolTipText("Step Min");
        this.stepMinToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.stepMinToolBarButton);
        this.stepIntoToolBarButton = new JButton(ImageRepository.getImage("resources/step_into.gif", "Step Into"));
        this.stepIntoToolBarButton.setToolTipText("Step Into (F5)");
        this.stepIntoToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.stepIntoToolBarButton);
        this.stepOverToolBarButton = new JButton(ImageRepository.getImage("resources/step_over.gif", "Step Over"));
        this.stepOverToolBarButton.setToolTipText("Step Over (F6)");
        this.stepOverToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.stepOverToolBarButton);
        this.stepOutToolBarButton = new JButton(ImageRepository.getImage("resources/step_out.gif", "Step Out"));
        this.stepOutToolBarButton.setToolTipText("Step Out (F7)");
        this.stepOutToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.stepOutToolBarButton);
        this.toolbar.addSeparator();
        this.ignoreLocationToolBarButton = new JButton(ImageRepository.getImage("resources/ignore_breakpoint_location.png", "Ignore Breakpoint Location"));
        this.ignoreLocationToolBarButton.setToolTipText("Ignore Breakpoint Location");
        this.ignoreLocationToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.ignoreLocationToolBarButton);
        this.toolbar.addSeparator();
        this.monitorsToolBarButton = new JToggleButton(ImageRepository.getImage("resources/monitors.gif", "Monitors"), true);
        this.monitorsToolBarButton.setToolTipText("Show Monitors");
        this.monitorsToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.monitorsToolBarButton);
        this.systemThreadToolBarButton = new JToggleButton(ImageRepository.getImage("resources/system_thread.gif", "System Threads"), false);
        this.systemThreadToolBarButton.setToolTipText("Show Running System Threads");
        this.systemThreadToolBarButton.addActionListener(this.treeListener);
        this.toolbar.add(this.systemThreadToolBarButton);
        this.scrollPane = new JScrollPane(this.tree);
        this.container = new JPanel(new BorderLayout());
        this.container.add((Component)this.toolbar, "First");
        this.container.add((Component)this.scrollPane, "Center");
        this.updateToolbarState();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                JButton source;
                if (e.getID() != 401) {
                    return false;
                }
                switch (e.getKeyCode()) {
                    case 116: {
                        source = ThreadManager.this.stepIntoToolBarButton;
                        break;
                    }
                    case 117: {
                        source = ThreadManager.this.stepOverToolBarButton;
                        break;
                    }
                    case 118: {
                        source = ThreadManager.this.stepOutToolBarButton;
                        break;
                    }
                    case 119: {
                        source = ThreadManager.this.resumeToolBarButton;
                        break;
                    }
                    default: {
                        source = null;
                    }
                }
                if (source != null && source.isEnabled()) {
                    ThreadManager.this.treeListener.actionPerformed(new ActionEvent(source, 1001, null));
                    return true;
                }
                return false;
            }
        });
    }

    public void setThreads(ThreadListPacket packet) {
        this.selectionModel.clearSelection();
        this.file = null;
        this.prefix = null;
        this.lineNumber = -1;
        this.bci = -1;
        boolean expandOnFirstPacket = this.root.getChildCount() == 0;
        HashMap<Long, DefaultMutableTreeNode> toBeRemoved = new HashMap<Long, DefaultMutableTreeNode>();
        if (this.current != null) {
            toBeRemoved.putAll(this.threads);
        }
        boolean anyThreadSelected = !this.rootSelected;
        this.rootSelected = false;
        for (int i = 0; i < packet.getThreadCount(); ++i) {
            boolean wasCollapsed;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)toBeRemoved.remove(packet.getThreadId(i));
            boolean isSelected = packet.isSelected(i);
            anyThreadSelected = anyThreadSelected || isSelected;
            ThreadListPacket.Frame[] frames = packet.getThreadFrames(i);
            boolean bl = wasCollapsed = node != null && !node.isLeaf() && this.tree.isCollapsed(new TreePath(node.getPath()));
            if (node == null) {
                node = new DefaultMutableTreeNode(new ThreadObject(packet, i));
                this.threads.put(packet.getThreadId(i), node);
                this.model.insertNodeInto(node, this.root, this.root.getChildCount());
                isSelected = this.addChildren(node, isSelected, frames, packet.getContendedMonitor(i), packet.getWaitingMonitor(i), packet.getOwnedMonitors(i));
            } else {
                int childCount;
                ThreadObject newState = new ThreadObject(packet, i);
                if (!newState.equals(node.getUserObject())) {
                    node.setUserObject(newState);
                    this.model.nodeChanged(node);
                }
                if (((childCount = this.model.getChildCount(node)) > 0 || frames.length > 0 || packet.getContendedMonitor(i) != null || packet.getWaitingMonitor(i) != null || packet.getOwnedMonitors(i).length > 0) && (isSelected || this.subTreeChanged(packet, i, node, frames))) {
                    for (int j = childCount - 1; j >= 0; --j) {
                        this.model.removeNodeFromParent((DefaultMutableTreeNode)this.model.getChild(node, j));
                    }
                    isSelected = this.addChildren(node, isSelected, frames, packet.getContendedMonitor(i), packet.getWaitingMonitor(i), packet.getOwnedMonitors(i));
                }
            }
            if (isSelected) {
                this.selectionModel.setSelected(new TreePath(node.getPath()));
                assert (this.file == null && this.prefix == null && this.lineNumber == -1);
                if (frames.length > 0) {
                    this.file = frames[0].getSourceName();
                    this.prefix = frames[0].getSourcePrefix();
                    this.lineNumber = frames[0].getLineNr();
                    this.bci = frames[0].getByteCodeIndex();
                }
                this.makeNodeVisible(node);
            }
            if (wasCollapsed) continue;
            this.tree.expandPath(new TreePath(node.getPath()));
        }
        for (DefaultMutableTreeNode node : toBeRemoved.values()) {
            this.model.removeNodeFromParent(node);
        }
        this.threads.keySet().removeAll(toBeRemoved.keySet());
        if (!anyThreadSelected) {
            this.selectionModel.setSelected(new TreePath(this.root.getPath()));
            this.rootSelected = true;
        }
        if (expandOnFirstPacket) {
            this.tree.expandPath(new TreePath(this.root));
        }
        this.updateToolbarState();
        this.current = packet;
        if (this.file != null) {
            String methodName;
            int i;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selectionModel.getSelectionPath().getLastPathComponent();
            int frameIndex = 0;
            if (node.getUserObject() instanceof ThreadListPacket.Frame) {
                DefaultMutableTreeNode child;
                frameIndex = node.getParent().getIndex(node);
                int nonFrames = 0;
                for (i = 0; i < frameIndex && !((child = (DefaultMutableTreeNode)node.getParent().getChildAt(i)).getUserObject() instanceof ThreadListPacket.Frame); ++i) {
                    ++nonFrames;
                }
                frameIndex -= nonFrames;
                methodName = ((ThreadListPacket.Frame)node.getUserObject()).getMethodNameWithReturnType();
                node = (DefaultMutableTreeNode)node.getParent();
            } else {
                DefaultMutableTreeNode topFrame = null;
                for (i = 0; i < node.getChildCount(); ++i) {
                    if (!(((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject() instanceof ThreadListPacket.Frame)) continue;
                    topFrame = (DefaultMutableTreeNode)node.getChildAt(i);
                    break;
                }
                methodName = ((ThreadListPacket.Frame)topFrame.getUserObject()).getMethodNameWithReturnType();
            }
            assert (node.getUserObject() instanceof ThreadObject);
            long threadId = ((ThreadObject)node.getUserObject()).id;
            this.codeManager.showSource(this.file, this.prefix, this.lineNumber, this.bci, threadId, frameIndex, methodName);
        } else {
            this.codeManager.removeHighlight();
        }
    }

    private boolean subTreeChanged(ThreadListPacket packet, int index, DefaultMutableTreeNode node, ThreadListPacket.Frame[] frames) {
        int childCount = this.model.getChildCount(node);
        boolean update = true;
        int targetCount = frames.length + packet.getOwnedMonitors(index).length + (packet.getContendedMonitor(index) != null ? 1 : 0) + (packet.getWaitingMonitor(index) != null ? 1 : 0);
        if (childCount == targetCount) {
            DefaultMutableTreeNode f;
            int j;
            MonitorObject m;
            DefaultMutableTreeNode f2;
            update = false;
            int offset = 0;
            if (this.monitorsToolBarButton.isSelected() && packet.getContendedMonitor(index) != null) {
                f2 = (DefaultMutableTreeNode)this.model.getChild(node, offset);
                ++offset;
                m = MonitorObject.createContended(packet.getContendedMonitor(index));
                if (!m.equals(f2.getUserObject())) {
                    update = true;
                }
            }
            if (!update && this.monitorsToolBarButton.isSelected() && packet.getWaitingMonitor(index) != null) {
                f2 = (DefaultMutableTreeNode)this.model.getChild(node, offset);
                ++offset;
                m = MonitorObject.createWaiting(packet.getWaitingMonitor(index));
                if (!m.equals(f2.getUserObject())) {
                    update = true;
                }
            }
            ThreadListPacket.ObjectMonitor[] monitors = packet.getOwnedMonitors(index);
            for (j = 0; !update && this.monitorsToolBarButton.isSelected() && j < monitors.length; ++j) {
                f = (DefaultMutableTreeNode)this.model.getChild(node, j + offset);
                MonitorObject m2 = MonitorObject.createOwned(monitors[j]);
                if (m2.equals(f.getUserObject())) continue;
                update = true;
                break;
            }
            offset += this.monitorsToolBarButton.isSelected() ? monitors.length : 0;
            for (j = 0; !update && j < frames.length; ++j) {
                f = (DefaultMutableTreeNode)this.model.getChild(node, j + offset);
                if (frames[j].equals(f.getUserObject())) continue;
                update = true;
                break;
            }
        }
        return update;
    }

    private boolean addChildren(DefaultMutableTreeNode node, boolean isSelected, ThreadListPacket.Frame[] frames, ThreadListPacket.ObjectMonitor contended, ThreadListPacket.ObjectMonitor waiting, ThreadListPacket.ObjectMonitor[] owned) {
        DefaultMutableTreeNode f;
        int j;
        DefaultMutableTreeNode f2;
        boolean result = isSelected;
        if (this.monitorsToolBarButton.isSelected() && contended != null) {
            f2 = new DefaultMutableTreeNode(MonitorObject.createContended(contended));
            this.model.insertNodeInto(f2, node, node.getChildCount());
        }
        if (this.monitorsToolBarButton.isSelected() && waiting != null) {
            f2 = new DefaultMutableTreeNode(MonitorObject.createWaiting(waiting));
            this.model.insertNodeInto(f2, node, node.getChildCount());
        }
        int offset = node.getChildCount();
        for (j = 0; this.monitorsToolBarButton.isSelected() && j < owned.length; ++j) {
            f = new DefaultMutableTreeNode(MonitorObject.createOwned(owned[j]));
            this.model.insertNodeInto(f, node, j + offset);
        }
        offset = node.getChildCount();
        for (j = 0; j < frames.length; ++j) {
            f = new DefaultMutableTreeNode(frames[j]);
            this.model.insertNodeInto(f, node, j + offset);
            if (!frames[j].isSelected()) continue;
            assert (isSelected);
            result = false;
            this.selectionModel.setSelected(new TreePath(f.getPath()));
            assert (this.file == null && this.prefix == null && this.lineNumber == -1 && this.bci == -1);
            this.file = frames[j].getSourceName();
            this.prefix = frames[j].getSourcePrefix();
            this.lineNumber = frames[j].getLineNr();
            this.bci = frames[j].getByteCodeIndex();
            this.makeNodeVisible(f);
        }
        return result;
    }

    public void setContext(JvmDebugger.SwingDebugger context) {
        assert (this.context == null && context != null);
        this.context = context;
    }

    public void setController(FrontendController controller) {
        assert (this.controller == null && controller != null);
        this.controller = controller;
        QueueHelper.put(controller.getWriteQueue(), new ThreadListFilterPacketImpl(this.systemThreadToolBarButton.isSelected(), false));
        this.root.setUserObject(this.context.getName());
        this.tree.setRootVisible(true);
    }

    public void setSourceCodeManager(SourceCodeManager manager) {
        assert (this.codeManager == null);
        this.codeManager = manager;
    }

    public void setBreakpointManager(BreakpointManager manager) {
        assert (this.breakpointManager == null);
        this.breakpointManager = manager;
    }

    public void setControllerListener(FrontendController.ControllerListener listener) {
        assert (this.terminationListener == null);
        this.terminationListener = listener;
    }

    public JComponent getTree() {
        return this.container;
    }

    private void makeNodeVisible(DefaultMutableTreeNode node) {
        if (makeNodeVisibleOnce) {
            Object uo = node.getUserObject();
            if (uo != null && this.lastVisibleNode != null && uo.equals(this.lastVisibleNode)) {
                return;
            }
            this.lastVisibleNode = uo;
        }
        Rectangle rect = this.tree.getPathBounds(new TreePath(node.getPath()));
        Rectangle viewRect = this.scrollPane.getViewport().getViewRect();
        rect.x = viewRect.x;
        rect.width = 1;
        this.tree.scrollRectToVisible(rect);
    }

    private ThreadObject getThreadForPath(TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof ThreadObject) {
            return (ThreadObject)node.getUserObject();
        }
        if ((node = (DefaultMutableTreeNode)node.getParent()) == null) {
            return null;
        }
        if (node.getUserObject() instanceof ThreadObject) {
            return (ThreadObject)node.getUserObject();
        }
        return null;
    }

    private void updateToolbarState() {
        if (this.controller == null) {
            this.connectToolBarButton.setEnabled(true);
            this.extendedConnectToolBarButton.setEnabled(true);
            this.suspendToolBarButton.setEnabled(false);
            this.resumeToolBarButton.setEnabled(false);
            this.terminateToolBarButton.setEnabled(false);
            this.disconnectToolBarButton.setEnabled(false);
            this.stepMinToolBarButton.setEnabled(false);
            this.stepIntoToolBarButton.setEnabled(false);
            this.stepOverToolBarButton.setEnabled(false);
            this.stepOutToolBarButton.setEnabled(false);
            this.ignoreLocationToolBarButton.setEnabled(false);
            this.monitorsToolBarButton.setEnabled(false);
            this.systemThreadToolBarButton.setEnabled(false);
            return;
        }
        ThreadObject thread = this.getThreadForPath(this.tree.getSelectionModel().getSelectionPath());
        this.connectToolBarButton.setEnabled(false);
        this.extendedConnectToolBarButton.setEnabled(false);
        this.suspendToolBarButton.setEnabled(true);
        this.resumeToolBarButton.setEnabled(true);
        this.terminateToolBarButton.setEnabled(true);
        this.disconnectToolBarButton.setEnabled(true);
        this.stepMinToolBarButton.setEnabled(false);
        this.stepIntoToolBarButton.setEnabled(false);
        this.stepOverToolBarButton.setEnabled(false);
        this.stepOutToolBarButton.setEnabled(false);
        this.ignoreLocationToolBarButton.setEnabled(false);
        this.monitorsToolBarButton.setEnabled(true);
        this.systemThreadToolBarButton.setEnabled(true);
        if (thread != null) {
            if (thread.suspended) {
                this.suspendToolBarButton.setEnabled(false);
                this.stepMinToolBarButton.setEnabled(true);
                this.stepIntoToolBarButton.setEnabled(true);
                this.stepOverToolBarButton.setEnabled(true);
                this.stepOutToolBarButton.setEnabled(true);
                if (thread.breakpoints.length > 0) {
                    boolean enabled = false;
                    for (ThreadListPacket.ActiveBreakpoint breakpoint : thread.breakpoints) {
                        if ("deleted breakpoint".equals(breakpoint.getName())) continue;
                        enabled = true;
                        break;
                    }
                    this.ignoreLocationToolBarButton.setEnabled(enabled);
                }
            } else {
                this.resumeToolBarButton.setEnabled(false);
            }
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node != null && node != this.root) {
                assert (node.getUserObject() instanceof ThreadListPacket.Frame || node.getUserObject() instanceof MonitorObject);
                this.suspendToolBarButton.setEnabled(false);
                this.resumeToolBarButton.setEnabled(false);
            }
        }
    }

    public void reset() {
        if (this.terminationListener != null) {
            this.controller.removeListener(this.terminationListener);
            this.terminationListener = null;
        }
        try {
            this.controller.stop();
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Error while disconnecting from debuggee");
            JOptionPane.showMessageDialog(null, "Disconnecting from the debugged program failed.", "Disconnection", 1);
        }
        this.controller = null;
        this.current = null;
        this.updateToolbarState();
        for (int i = this.root.getChildCount() - 1; i >= 0; --i) {
            this.model.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(i));
        }
        this.threads.clear();
        this.file = null;
        this.prefix = null;
        this.lineNumber = -1;
        this.bci = -1;
        this.rootSelected = false;
        this.tree.setRootVisible(false);
    }

    private class ThreadTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -3741354646084515800L;
        private final Icon allThreads = ImageRepository.getImage("resources/threads.gif", "Threads");
        private final Icon runningThread = ImageRepository.getImage("resources/thread_running.gif", "Running Thread");
        private final Icon suspendedThread = ImageRepository.getImage("resources/thread_suspended.gif", "Suspended Thread");
        private final Icon frame = ImageRepository.getImage("resources/stackframe.gif", "Stack frame");
        private final Icon ownedMonitor = ImageRepository.getImage("resources/monitor_owned.gif", "Owned Monitor");
        private final Icon contendedMonitor = ImageRepository.getImage("resources/monitor_contended.gif", "Contended Monitor");

        private ThreadTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree t, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(t, value, sel, expanded, leaf, row, focus);
            if (value == ThreadManager.this.root) {
                this.setIcon(this.allThreads);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof ThreadObject) {
                    ThreadObject thread = (ThreadObject)userObject;
                    this.setIcon(thread.suspended ? this.suspendedThread : this.runningThread);
                } else if (userObject instanceof ThreadListPacket.Frame) {
                    this.setIcon(this.frame);
                } else if (userObject instanceof MonitorObject) {
                    if ("owns: ".equals(((MonitorObject)userObject).prefix)) {
                        this.setIcon(this.ownedMonitor);
                    } else {
                        this.setIcon(this.contendedMonitor);
                    }
                }
            }
            return this;
        }
    }

    private class ThreadSelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -8197871987949139004L;

        private ThreadSelectionModel() {
        }

        public void setSelected(TreePath path) {
            this.clearSelection();
            super.setSelectionPaths(new TreePath[]{path});
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            ThreadManager.this.rootSelected = false;
            long threadId = 0L;
            int frameIndex = -1;
            if (paths != null && paths.length >= 1) {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                Object object = selectedNode.getUserObject();
                if (object instanceof ThreadListPacket.Frame) {
                    DefaultMutableTreeNode child;
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selectedNode.getParent();
                    ThreadObject thread = (ThreadObject)parent.getUserObject();
                    threadId = thread.id;
                    frameIndex = parent.getIndex(selectedNode);
                    int monitors = 0;
                    for (int i = 0; i < frameIndex && (child = (DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject() instanceof MonitorObject; ++i) {
                        ++monitors;
                    }
                    frameIndex -= monitors;
                } else if (object instanceof ThreadObject) {
                    ThreadObject thread = (ThreadObject)object;
                    threadId = thread.id;
                } else if (selectedNode == ThreadManager.this.root) {
                    ThreadManager.this.rootSelected = true;
                }
            }
            if (ThreadManager.this.controller == null) {
                assert (ThreadManager.this.rootSelected);
                return;
            }
            ThreadListSelectPacketImpl packet = new ThreadListSelectPacketImpl(threadId, frameIndex);
            QueueHelper.put(ThreadManager.this.controller.getWriteQueue(), packet);
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
        }

        @Override
        public void removeSelectionPaths(TreePath[] paths) {
        }
    }

    private class TreeEventHandler
    extends MouseAdapter
    implements ActionListener,
    TreeSelectionListener {
        private long threadId = -1L;
        private ThreadListPacket.ActiveBreakpoint[] breakpoints = null;

        private TreeEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebuggingPacket packet = null;
            ArrayList<DebuggingPacket> packetList = null;
            if (e.getSource() == ThreadManager.this.suspendContextMenuItem) {
                assert (this.threadId != -1L);
                packet = new SuspendThreadPacketImpl(this.threadId);
            } else if (e.getSource() == ThreadManager.this.resumeContextMenuItem) {
                assert (this.threadId != -1L);
                packet = new ResumeThreadPacketImpl(this.threadId);
            } else if (e.getSource() == ThreadManager.this.stepMinContextMenuItem) {
                assert (this.threadId != -1L);
                packet = new StepThreadPacketImpl(this.threadId, StepThreadPacket.StepPolicy.STEP_MIN_INTO);
            } else if (e.getSource() == ThreadManager.this.stepIntoContextMenuItem) {
                assert (this.threadId != -1L);
                StepThreadPacket.StepPolicy policy = StepThreadPacket.StepPolicy.STEP_INTO;
                if (ThreadManager.this.codeManager.isShowingDisassembly()) {
                    policy = StepThreadPacket.StepPolicy.STEP_MIN_INTO;
                }
                packet = new StepThreadPacketImpl(this.threadId, policy);
            } else if (e.getSource() == ThreadManager.this.stepOverContextMenuItem) {
                assert (this.threadId != -1L);
                StepThreadPacket.StepPolicy policy = StepThreadPacket.StepPolicy.STEP_OVER;
                if (ThreadManager.this.codeManager.isShowingDisassembly()) {
                    policy = StepThreadPacket.StepPolicy.STEP_MIN_OVER;
                }
                packet = new StepThreadPacketImpl(this.threadId, policy);
            } else if (e.getSource() == ThreadManager.this.stepOutContextMenuItem) {
                assert (this.threadId != -1L);
                packet = new StepThreadPacketImpl(this.threadId, StepThreadPacket.StepPolicy.STEP_OUT);
            } else if (e.getSource() == ThreadManager.this.ignoreLocationContextMenuItem) {
                assert (this.threadId != -1L && this.breakpoints != null);
                if (this.breakpoints.length == 1) {
                    assert (!"deleted breakpoint".equals(this.breakpoints[0].getName()));
                    packet = ThreadManager.this.breakpointManager.createIgnoreLocationPacket(this.breakpoints[0].getName(), this.threadId);
                } else {
                    packetList = new ArrayList<DebuggingPacket>();
                    for (int i = 0; i < this.breakpoints.length; ++i) {
                        if ("deleted breakpoint".equals(this.breakpoints[0].getName())) continue;
                        packetList.add(ThreadManager.this.breakpointManager.createIgnoreLocationPacket(this.breakpoints[i].getName(), this.threadId));
                    }
                }
            } else if (e.getSource() == ThreadManager.this.browserConnectMenuItem) {
                JvmDebugger.createControllerUsingBrowser(ThreadManager.this.context);
            } else if (e.getSource() == ThreadManager.this.cloudConnectMenuItem) {
                JvmDebugger.createCloudController(ThreadManager.this.context);
            } else if (e.getSource() == ThreadManager.this.manualConnectMenuItem) {
                JvmDebugger.createManualController(ThreadManager.this.context);
            } else if (e.getSource() == ThreadManager.this.connectToolBarButton) {
                JvmDebugger.createControllerUsingBrowser(ThreadManager.this.context);
            } else if (e.getSource() == ThreadManager.this.extendedConnectToolBarButton) {
                ThreadManager.this.connectMenu.show(ThreadManager.this.connectToolBarButton, 0, ThreadManager.this.connectToolBarButton.getHeight());
            } else if (e.getSource() == ThreadManager.this.suspendToolBarButton) {
                ThreadObject thread;
                assert (ThreadManager.this.tree.getSelectionCount() <= 1);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ThreadManager.this.tree.getLastSelectedPathComponent();
                if (node == null || node == ThreadManager.this.root) {
                    packet = new SuspendAllThreadsPacketImpl();
                } else if (node.getUserObject() instanceof ThreadObject && !(thread = (ThreadObject)node.getUserObject()).suspended) {
                    packet = new SuspendThreadPacketImpl(thread.id);
                }
            } else if (e.getSource() == ThreadManager.this.resumeToolBarButton) {
                assert (ThreadManager.this.tree.getSelectionCount() <= 1);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ThreadManager.this.tree.getLastSelectedPathComponent();
                if (node == null || node == ThreadManager.this.root) {
                    packet = new ResumeAllThreadsPacketImpl();
                } else {
                    ThreadObject thread = ThreadManager.this.getThreadForPath(ThreadManager.this.tree.getSelectionModel().getSelectionPath());
                    if (thread != null && thread.suspended) {
                        packet = new ResumeThreadPacketImpl(thread.id);
                    }
                }
            } else if (e.getSource() == ThreadManager.this.terminateToolBarButton) {
                packet = new ExitVmPacketImpl(0);
            } else if (e.getSource() == ThreadManager.this.disconnectToolBarButton) {
                ThreadManager.this.context.reset();
            } else if (e.getSource() == ThreadManager.this.stepMinToolBarButton) {
                ThreadObject thread = ThreadManager.this.getThreadForPath(ThreadManager.this.tree.getSelectionModel().getSelectionPath());
                packet = new StepThreadPacketImpl(thread.id, StepThreadPacket.StepPolicy.STEP_MIN_INTO);
            } else if (e.getSource() == ThreadManager.this.stepIntoToolBarButton) {
                ThreadObject thread = ThreadManager.this.getThreadForPath(ThreadManager.this.tree.getSelectionModel().getSelectionPath());
                StepThreadPacket.StepPolicy policy = StepThreadPacket.StepPolicy.STEP_INTO;
                if (ThreadManager.this.codeManager.isShowingDisassembly()) {
                    policy = StepThreadPacket.StepPolicy.STEP_MIN_INTO;
                }
                packet = new StepThreadPacketImpl(thread.id, policy);
            } else if (e.getSource() == ThreadManager.this.stepOverToolBarButton) {
                ThreadObject thread = ThreadManager.this.getThreadForPath(ThreadManager.this.tree.getSelectionModel().getSelectionPath());
                StepThreadPacket.StepPolicy policy = StepThreadPacket.StepPolicy.STEP_OVER;
                if (ThreadManager.this.codeManager.isShowingDisassembly()) {
                    policy = StepThreadPacket.StepPolicy.STEP_MIN_OVER;
                }
                packet = new StepThreadPacketImpl(thread.id, policy);
            } else if (e.getSource() == ThreadManager.this.stepOutToolBarButton) {
                ThreadObject thread = ThreadManager.this.getThreadForPath(ThreadManager.this.tree.getSelectionModel().getSelectionPath());
                packet = new StepThreadPacketImpl(thread.id, StepThreadPacket.StepPolicy.STEP_OUT);
            } else if (e.getSource() == ThreadManager.this.ignoreLocationToolBarButton) {
                ThreadObject thread = ThreadManager.this.getThreadForPath(ThreadManager.this.tree.getSelectionModel().getSelectionPath());
                if (thread.breakpoints.length == 1) {
                    assert (!"deleted breakpoint".equals(thread.breakpoints[0].getName()));
                    packet = ThreadManager.this.breakpointManager.createIgnoreLocationPacket(thread.breakpoints[0].getName(), thread.id);
                } else {
                    packetList = new ArrayList();
                    for (int i = 0; i < thread.breakpoints.length; ++i) {
                        if ("deleted breakpoint".equals(thread.breakpoints[0].getName())) continue;
                        packetList.add(ThreadManager.this.breakpointManager.createIgnoreLocationPacket(thread.breakpoints[i].getName(), thread.id));
                    }
                }
            } else if (e.getSource() == ThreadManager.this.monitorsToolBarButton) {
                ThreadManager.this.setThreads(ThreadManager.this.current);
            } else if (e.getSource() == ThreadManager.this.systemThreadToolBarButton) {
                packet = new ThreadListFilterPacketImpl(ThreadManager.this.systemThreadToolBarButton.isSelected(), false);
            }
            if (packet != null) {
                QueueHelper.put(ThreadManager.this.controller.getWriteQueue(), packet);
            }
            if (packetList != null) {
                for (DebuggingPacket dp : packetList) {
                    QueueHelper.put(ThreadManager.this.controller.getWriteQueue(), dp);
                }
            }
            this.threadId = -1L;
            this.breakpoints = null;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        private void handleMouseEvent(MouseEvent e) {
            ThreadObject thread;
            TreePath path;
            if (e.isPopupTrigger() && (path = ThreadManager.this.tree.getPathForLocation(e.getX(), e.getY())) != null && (thread = ThreadManager.this.getThreadForPath(path)) != null) {
                this.threadId = thread.id;
                this.breakpoints = thread.breakpoints;
                ThreadManager.this.suspendContextMenuItem.setEnabled(!thread.suspended);
                ThreadManager.this.resumeContextMenuItem.setEnabled(thread.suspended);
                ThreadManager.this.stepMinContextMenuItem.setEnabled(thread.suspended);
                ThreadManager.this.stepIntoContextMenuItem.setEnabled(thread.suspended);
                ThreadManager.this.stepOverContextMenuItem.setEnabled(thread.suspended);
                ThreadManager.this.stepOutContextMenuItem.setEnabled(thread.suspended);
                ThreadManager.this.ignoreLocationContextMenuItem.setEnabled(thread.suspended);
                boolean visible = false;
                for (ThreadListPacket.ActiveBreakpoint breakpoint : thread.breakpoints) {
                    if ("deleted breakpoint".equals(breakpoint.getName())) continue;
                    visible = true;
                    break;
                }
                ThreadManager.this.ignoreLocationContextMenuItem.setVisible(visible);
                ThreadManager.this.contextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ThreadManager.this.updateToolbarState();
        }
    }

    private static class MonitorObject {
        private static final String OWNED_PREFIX = "owns: ";
        private static final String WAITING_PREFIX = "waiting for: ";
        private static final String CONTENDED_PREFIX = "trying to acquire: ";
        private final String prefix;
        private final ThreadListPacket.ObjectMonitor monitor;

        private MonitorObject(String prefix, ThreadListPacket.ObjectMonitor monitor2) {
            this.prefix = prefix;
            this.monitor = monitor2;
        }

        public int hashCode() {
            return this.prefix.hashCode() ^ this.monitor.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MonitorObject other = (MonitorObject)obj;
            return this.prefix.equals(other.prefix) && this.monitor.equals(other.monitor);
        }

        public String toString() {
            return this.prefix + this.monitor.getText();
        }

        private static MonitorObject createContended(ThreadListPacket.ObjectMonitor monitor2) {
            return new MonitorObject(CONTENDED_PREFIX, monitor2);
        }

        private static MonitorObject createWaiting(ThreadListPacket.ObjectMonitor monitor2) {
            return new MonitorObject(WAITING_PREFIX, monitor2);
        }

        private static MonitorObject createOwned(ThreadListPacket.ObjectMonitor monitor2) {
            return new MonitorObject(OWNED_PREFIX, monitor2);
        }
    }

    private static class ThreadObject {
        private final long id;
        private final String name;
        private final boolean daemon;
        private final boolean system;
        private final boolean suspended;
        private final boolean stepping;
        private final ThreadListPacket.ActiveBreakpoint[] breakpoints;

        public ThreadObject(ThreadListPacket packet, int index) {
            this.id = packet.getThreadId(index);
            this.name = packet.getThreadName(index);
            this.daemon = packet.isDaemon(index);
            this.system = packet.isSystem(index);
            this.suspended = packet.isSuspended(index);
            this.stepping = packet.isStepping(index);
            this.breakpoints = packet.getActiveBreakpoints(index);
        }

        public String toString() {
            String state;
            if (this.stepping) {
                state = "stepping";
            } else if (this.suspended) {
                state = "suspended";
                if (this.breakpoints.length > 0) {
                    state = state + " (" + this.breakpoints[0].getText() + ")";
                }
            } else {
                state = "running";
            }
            return (this.daemon ? "Daemon " : "") + (this.system ? "System " : "") + "Thread [" + this.name + "] (" + state + ")";
        }

        public int hashCode() {
            return (int)(this.id >> 32 ^ this.id) ^ (this.name == null ? 0 : this.name.hashCode()) ^ (this.daemon ? 1 : 0) ^ (this.suspended ? 1 : 0) ^ (this.breakpoints == null ? 0 : Arrays.hashCode(this.breakpoints));
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ThreadObject other = (ThreadObject)obj;
            if (this.breakpoints == null ? other.breakpoints != null : !Arrays.equals(this.breakpoints, other.breakpoints)) {
                return false;
            }
            return this.id == other.id && this.daemon == other.daemon && this.suspended == other.suspended && this.name.equals(other.name);
        }
    }
}

