/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing;

import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointParser;
import com.sap.jvm.debugging.controller.packets.variables.AddDetailFormattersPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.AddLogicalStructuresPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.DetailFormattersListPacket;
import com.sap.jvm.debugging.controller.packets.variables.LogicalStructuresListPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveDetailFormattersPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.RemoveLogicalStructuresPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.VariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreeNodeImpl;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreePacket;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import com.sap.jvm.debugging.presentation.LogicalStructureDefinition;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.ui.swing.BreakpointManager;
import com.sap.jvm.debugging.ui.swing.FrontendController;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.treetable.AbstractTreeTableModel;
import com.sap.jvm.debugging.ui.swing.treetable.TreeTable;
import com.sap.jvm.debugging.ui.swing.treetable.TreeTableModel;
import com.sap.jvm.util.concurrent.QueueHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class VariablesManager {
    private static final NodeValue LOADING_USER_OBJECT = new NodeValue(null, "Loading...", "");
    private static final ImageIcon staticOverlay = ImageRepository.getImage("resources/overlay_static.gif", "Static field");
    private static final ImageIcon finalOverlay = ImageRepository.getImage("resources/overlay_final.gif", "Final field");
    private static final ImageIcon addOverlay = ImageRepository.getImage("resources/overlay_add.gif", "Add");
    private static final ImageIcon removeOverlay = ImageRepository.getImage("resources/overlay_remove.gif", "Remove");
    private FrontendController controller = null;
    private BreakpointManager breakpointManager = null;
    private final JPanel container;
    private final VariablesTreeTableModel model;
    private final VariableTreeRenderer renderer;
    private final TreeTable table;
    private final DefaultMutableTreeNode root;
    private final TreeExpansionListenerImpl expansionListener;
    private final VariableSelectionListener selectionListener;
    private long threadId = 0L;
    private int frameIndex = -1;
    private final JToolBar toolbar;
    private final JToggleButton staticsToolBarButton;
    private final JToggleButton constantsToolBarButton;
    private final JToggleButton syntheticsToolBarButton;
    private final JToggleButton logicalStructureToolBarButton;
    private final JButton addFormatterToolBarButton;
    private final JButton removeFormatterToolBarButton;
    private final JButton addLogicalStructureToolBarButton;
    private final JButton removeLogicalStructureToolBarButton;
    private final ActionListenerImpl buttonListener;
    private final JTextField selectedValue;
    private final JPopupMenu contextMenu;
    private final JMenuItem changeValueContextMenuItem;
    private final JMenuItem addAccessWatchPointContextMenuItem;
    private final JMenuItem addModificationWatchPointContextMenuItem;
    private final JMenuItem addAccessModificationWatchPointContextMenuItem;
    private final Set<JMenuItem> rootContextMenuItems = new LinkedHashSet<JMenuItem>();
    private final Map<String, String> detailFormatters = new HashMap<String, String>();
    private final Map<String, LogicalStructureDefinition> logicalStructureDefinitions = new HashMap<String, LogicalStructureDefinition>();

    public VariablesManager() {
        this.root = new DefaultMutableTreeNode("Variables");
        this.model = new VariablesTreeTableModel(this.root);
        this.renderer = new VariableTreeRenderer();
        this.expansionListener = new TreeExpansionListenerImpl();
        this.selectionListener = new VariableSelectionListener();
        this.table = new TreeTable(this.model);
        this.table.getTree().addTreeExpansionListener(this.expansionListener);
        this.table.getTree().setRootVisible(false);
        this.table.addMouseListener(this.selectionListener);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.getTree().setCellRenderer(this.renderer);
        this.buttonListener = new ActionListenerImpl();
        this.toolbar = new JToolBar();
        ImageIcon fieldIcon = ImageRepository.getImage("resources/field.gif", "Field");
        this.staticsToolBarButton = new JToggleButton(ImageRepository.createIconWithOverlay(fieldIcon, staticOverlay, null, null, null), false);
        this.staticsToolBarButton.setToolTipText("Show Statics");
        this.staticsToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.staticsToolBarButton);
        this.constantsToolBarButton = new JToggleButton(ImageRepository.createIconWithOverlay(fieldIcon, staticOverlay, finalOverlay, null, null), false);
        this.constantsToolBarButton.setToolTipText("Show Constants");
        this.constantsToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.constantsToolBarButton);
        this.syntheticsToolBarButton = new JToggleButton(ImageRepository.getImage("resources/synthetics.gif", "Synthetics"), true);
        this.syntheticsToolBarButton.setToolTipText("Show Synthetic Variables");
        this.syntheticsToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.syntheticsToolBarButton);
        ImageIcon logicalStructureIcon = ImageRepository.getImage("resources/logical_structure.gif", "Logical structure");
        this.logicalStructureToolBarButton = new JToggleButton(logicalStructureIcon, false);
        this.logicalStructureToolBarButton.setToolTipText("Show Logical Structure");
        this.logicalStructureToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.logicalStructureToolBarButton);
        this.toolbar.addSeparator();
        ImageIcon detailFormatter = ImageRepository.getImage("resources/detail_formatter.gif", "Detail Formatter");
        this.addFormatterToolBarButton = new JButton(ImageRepository.createIconWithOverlay(detailFormatter, null, addOverlay, null, null));
        this.addFormatterToolBarButton.setToolTipText("Add Detail Formatter");
        this.addFormatterToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.addFormatterToolBarButton);
        this.removeFormatterToolBarButton = new JButton(ImageRepository.createIconWithOverlay(detailFormatter, null, removeOverlay, null, null));
        this.removeFormatterToolBarButton.setToolTipText("Remove Detail Formatter");
        this.removeFormatterToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.removeFormatterToolBarButton);
        this.toolbar.addSeparator();
        ImageIcon logicalStructureAddIcon = ImageRepository.getImage("resources/logical_structure_add.gif", "Add Logical Structure");
        this.addLogicalStructureToolBarButton = new JButton(logicalStructureAddIcon);
        this.addLogicalStructureToolBarButton.setToolTipText("Add Logical Structure");
        this.addLogicalStructureToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.addLogicalStructureToolBarButton);
        ImageIcon logicalStructureRemoveIcon = ImageRepository.getImage("resources/logical_structure_remove.gif", "Remove Logical Structure");
        this.removeLogicalStructureToolBarButton = new JButton(logicalStructureRemoveIcon);
        this.removeLogicalStructureToolBarButton.setToolTipText("Remove Logical Structure");
        this.removeLogicalStructureToolBarButton.addActionListener(this.buttonListener);
        this.toolbar.add(this.removeLogicalStructureToolBarButton);
        this.selectedValue = new JTextField("");
        this.selectedValue.setEditable(false);
        this.container = new JPanel(new BorderLayout());
        this.container.add((Component)this.toolbar, "First");
        this.container.add((Component)new JScrollPane(this.table), "Center");
        this.container.add((Component)this.selectedValue, "Last");
        this.contextMenu = new JPopupMenu();
        this.changeValueContextMenuItem = new JMenuItem("Change Value...", ImageRepository.getImage("resources/change.gif", "Change"));
        this.changeValueContextMenuItem.addActionListener(this.buttonListener);
        this.contextMenu.add(this.changeValueContextMenuItem);
        this.addAccessWatchPointContextMenuItem = new JMenuItem("Add Access Watch Point", ImageRepository.getImage("resources/watchpoint_read.gif", "Watchpoint read"));
        this.addAccessWatchPointContextMenuItem.addActionListener(this.buttonListener);
        this.contextMenu.add(this.addAccessWatchPointContextMenuItem);
        this.addModificationWatchPointContextMenuItem = new JMenuItem("Add Modification Watch Point", ImageRepository.getImage("resources/watchpoint_write.gif", "Watchpoint write"));
        this.addModificationWatchPointContextMenuItem.addActionListener(this.buttonListener);
        this.contextMenu.add(this.addModificationWatchPointContextMenuItem);
        this.addAccessModificationWatchPointContextMenuItem = new JMenuItem("Add Access/Modification Watch Point", ImageRepository.getImage("resources/watchpoint.gif", "Watchpoint"));
        this.addAccessModificationWatchPointContextMenuItem.addActionListener(this.buttonListener);
        this.contextMenu.add(this.addAccessModificationWatchPointContextMenuItem);
    }

    public JComponent getList() {
        return this.container;
    }

    protected void setVariables(VariableTreePacket packet) {
        this.root.removeAllChildren();
        this.expansionListener.enabled = false;
        this.selectionListener.enabled = false;
        this.threadId = packet.getThreadId();
        this.frameIndex = packet.getFrameIndex();
        HashMap<VariableTreePacket.VariableNode, DefaultMutableTreeNode> map = new HashMap<VariableTreePacket.VariableNode, DefaultMutableTreeNode>();
        for (int i = 0; i < packet.getVariableCount(); ++i) {
            VariableTreePacket.VariableNode var = packet.getVariable(i);
            NodeValue pair = new NodeValue(var, var.getName(), var.getValue());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(pair);
            this.root.add(node);
            map.put(var, node);
        }
        HashSet<DefaultMutableTreeNode> toBeExpanded = new HashSet<DefaultMutableTreeNode>();
        HashSet<DefaultMutableTreeNode> toBeSelected = new HashSet<DefaultMutableTreeNode>();
        while (!map.isEmpty()) {
            HashMap copy = new HashMap(map);
            map.clear();
            for (Map.Entry entry : copy.entrySet()) {
                VariableTreePacket.VariableNode parentVar = (VariableTreePacket.VariableNode)entry.getKey();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)entry.getValue();
                int childCount = parentVar.getFieldCount();
                if (childCount < 0) {
                    parent.add(new DefaultMutableTreeNode(LOADING_USER_OBJECT));
                }
                for (int i = 0; i < childCount; ++i) {
                    VariableTreePacket.VariableNode var = parentVar.getField(i);
                    NodeValue pair = new NodeValue(var, var.getName(), var.getValue());
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(pair);
                    parent.add(node);
                    map.put(var, node);
                }
                if (parentVar.isExpanded() && (parent.getParent() == this.root || toBeExpanded.contains(parent.getParent()))) {
                    toBeExpanded.add(parent);
                }
                if (!parentVar.isSelected()) continue;
                toBeSelected.add(parent);
            }
        }
        this.model.reload();
        JTree tree = this.table.getTree();
        for (DefaultMutableTreeNode defaultMutableTreeNode : toBeExpanded) {
            tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : toBeSelected) {
            final int index = tree.getRowForPath(new TreePath(defaultMutableTreeNode.getPath()));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VariablesManager.this.table.getSelectionModel().addSelectionInterval(index, index);
                }
            });
        }
        this.selectedValue.setText(packet.getStringOfSelection());
        this.expansionListener.enabled = true;
        this.selectionListener.enabled = true;
    }

    public void setController(FrontendController controller) {
        assert (this.controller == null && controller != null);
        this.controller = controller;
        VariableFilterPacket packet = this.createVariableFilterPacket(this.staticsToolBarButton.isSelected(), this.constantsToolBarButton.isSelected(), this.syntheticsToolBarButton.isSelected(), this.logicalStructureToolBarButton.isSelected());
        QueueHelper.put(controller.getWriteQueue(), packet);
        for (Component c : this.toolbar.getComponents()) {
            c.setEnabled(true);
        }
    }

    public void setBreakpointManager(BreakpointManager manager) {
        assert (this.breakpointManager == null);
        this.breakpointManager = manager;
    }

    public void setDetailFormatters(DetailFormattersListPacket packet) {
        this.detailFormatters.clear();
        for (int i = 0; i < packet.getNumberOfFormatters(); ++i) {
            this.detailFormatters.put(packet.getClassName(i), packet.getExpression(i));
        }
    }

    public void setLogicalStructures(LogicalStructuresListPacket packet) {
        this.logicalStructureDefinitions.clear();
        for (int i = 0; i < packet.getNumberOfLogicalStructures(); ++i) {
            LogicalStructureDefinition structure = packet.getStructure(i);
            this.logicalStructureDefinitions.put(packet.getStructure(i).getClassName(), structure);
        }
    }

    public void reset() {
        this.controller = null;
        this.root.removeAllChildren();
        this.model.reload();
        this.threadId = 0L;
        this.frameIndex = -1;
        this.detailFormatters.clear();
        this.logicalStructureDefinitions.clear();
        this.finishedConstruction();
    }

    protected FrontendController getController() {
        return this.controller;
    }

    protected JToolBar getToolbar() {
        return this.toolbar;
    }

    protected long getThreadId() {
        return this.threadId;
    }

    protected int getFrameIndex() {
        return this.frameIndex;
    }

    protected void addRootContextMenuItem(JMenuItem item) {
        this.rootContextMenuItems.add(item);
        item.addActionListener(this.buttonListener);
        this.contextMenu.add(item);
    }

    protected abstract void rootContextMenuItemSelected(JMenuItem var1, String var2, int var3);

    protected abstract VariableSetPacket createVariableSetPacket(long var1, int var3, String var4, VariableTreeNodeImpl[] var5);

    protected abstract VariableSetExpressionPacket createVariableSetExpressionPacket(long var1, int var3, String var4, VariableTreeNodeImpl[] var5);

    protected abstract VariableExpansionPacket createVariableExpansionPacket(long var1, int var3, boolean var4, VariableTreeNodeImpl[] var5);

    protected abstract VariableFilterPacket createVariableFilterPacket(boolean var1, boolean var2, boolean var3, boolean var4);

    protected VariableFilterPacket createVariableFilterPacket() {
        return this.createVariableFilterPacket(this.staticsToolBarButton.isSelected(), this.constantsToolBarButton.isSelected(), this.syntheticsToolBarButton.isSelected(), this.logicalStructureToolBarButton.isSelected());
    }

    protected abstract VariableSelectPacket createVariableSelectPacket(long var1, int var3, boolean var4, VariableTreeNodeImpl[][] var5);

    protected abstract boolean rootNodeEditable();

    private VariableTreeNodeImpl[] getPath(DefaultMutableTreeNode node) {
        ArrayList<VariableTreeNodeImpl> reversePath = new ArrayList<VariableTreeNodeImpl>();
        DefaultMutableTreeNode current = node;
        while (current != this.root) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)current.getParent();
            if (parent == null) {
                throw new IllegalStateException("Inconsistent hierarchy");
            }
            NodeValue value = (NodeValue)current.getUserObject();
            reversePath.add(new VariableTreeNodeImpl(parent.getIndex(current), value.name, value.node.getObjectId(), value.node.isSynthetic()));
            current = parent;
        }
        Collections.reverse(reversePath);
        return reversePath.toArray(new VariableTreeNodeImpl[reversePath.size()]);
    }

    protected void finishedConstruction() {
        for (Component c : this.toolbar.getComponents()) {
            c.setEnabled(false);
        }
    }

    protected String[] getRootNames() {
        String[] names = new String[this.root.getChildCount()];
        for (int i = 0; i < names.length; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            NodeValue nodeValue = (NodeValue)node.getUserObject();
            names[i] = nodeValue.name;
        }
        return names;
    }

    private class VariableTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 5002023249767246715L;
        private final ImageIcon locals = ImageRepository.getImage("resources/variable_local.gif", "Local variable");
        private final ImageIcon expressions = ImageRepository.getImage("resources/variable_expression.gif", "Expression variable");
        private final ImageIcon publicField = ImageRepository.getImage("resources/variable_public.gif", "Public field");
        private final ImageIcon protectedField = ImageRepository.getImage("resources/variable_protected.gif", "Protected field");
        private final ImageIcon packagePrivateField = ImageRepository.getImage("resources/variable_default.gif", "Default field");
        private final ImageIcon privateField = ImageRepository.getImage("resources/variable_private.gif", "Private field");
        private final ImageIcon returnValue = ImageRepository.getImage("resources/return_value.png", "Return Value");
        private final Map<VisibilityType, ImageIcon> defaultIcons = new HashMap<VisibilityType, ImageIcon>();
        private final Map<VisibilityType, ImageIcon> staticIcons = new HashMap<VisibilityType, ImageIcon>();
        private final Map<VisibilityType, ImageIcon> finalIcons = new HashMap<VisibilityType, ImageIcon>();
        private final Map<VisibilityType, ImageIcon> staticFinalIcons = new HashMap<VisibilityType, ImageIcon>();

        private VariableTreeRenderer() {
            this.defaultIcons.put(VisibilityType.LOCAL_VARIABLE, this.locals);
            this.defaultIcons.put(VisibilityType.EXPRESSION_VARIABLE, this.expressions);
            this.defaultIcons.put(VisibilityType.PUBLIC, this.publicField);
            this.defaultIcons.put(VisibilityType.PROTECTED, this.protectedField);
            this.defaultIcons.put(VisibilityType.PACKAGE_PRIVATE, this.packagePrivateField);
            this.defaultIcons.put(VisibilityType.PRIVATE, this.privateField);
            this.staticIcons.put(VisibilityType.LOCAL_VARIABLE, this.locals);
            this.staticIcons.put(VisibilityType.EXPRESSION_VARIABLE, this.expressions);
            this.finalIcons.put(VisibilityType.LOCAL_VARIABLE, this.locals);
            this.finalIcons.put(VisibilityType.EXPRESSION_VARIABLE, this.expressions);
            this.staticFinalIcons.put(VisibilityType.LOCAL_VARIABLE, this.locals);
            this.staticFinalIcons.put(VisibilityType.EXPRESSION_VARIABLE, this.expressions);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree t, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            NodeValue n;
            this.setBackgroundNonSelectionColor(t.getBackground());
            super.getTreeCellRendererComponent(t, value, sel, expanded, leaf, row, focus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof NodeValue && (n = (NodeValue)userObject).node != null) {
                this.setIcon(this.getIcon(n.node));
            }
            return this;
        }

        private Icon getIcon(VariableTreePacket.VariableNode node) {
            boolean isFinal;
            boolean isStatic;
            Map<VisibilityType, ImageIcon> mapping;
            if (node.getName().startsWith("<") && node.getName().endsWith(" returns>")) {
                return this.returnValue;
            }
            if (node.isStatic() && node.isFinal()) {
                mapping = this.staticFinalIcons;
                isStatic = true;
                isFinal = true;
            } else if (node.isStatic()) {
                mapping = this.staticIcons;
                isStatic = true;
                isFinal = false;
            } else if (node.isFinal()) {
                mapping = this.finalIcons;
                isStatic = false;
                isFinal = true;
            } else {
                mapping = this.defaultIcons;
                isStatic = false;
                isFinal = false;
            }
            ImageIcon icon = mapping.get((Object)node.getVisibility());
            if (icon != null) {
                return icon;
            }
            icon = this.createIcon(node.getVisibility(), isStatic, isFinal);
            mapping.put(node.getVisibility(), icon);
            return icon;
        }

        private ImageIcon createIcon(VisibilityType type, boolean isStatic, boolean isFinal) {
            assert (isStatic || isFinal);
            return ImageRepository.createIconWithOverlay(this.defaultIcons.get((Object)type), isStatic ? staticOverlay : null, isFinal ? finalOverlay : null, null, null);
        }
    }

    private class VariableSelectionListener
    extends MouseAdapter {
        private boolean enabled = true;

        private VariableSelectionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.enabled) {
                return;
            }
            int[] selectedRows = VariablesManager.this.table.getSelectedRows();
            HashSet<Integer> selection = new HashSet<Integer>();
            for (int i = 0; i < selectedRows.length; ++i) {
                selection.add(selectedRows[i]);
            }
            int row = VariablesManager.this.table.rowAtPoint(e.getPoint());
            TreePath path = VariablesManager.this.table.getTree().getPathForRow(row);
            if (path != null) {
                VariableSelectPacket packet;
                assert (row >= 0);
                if (selection.contains(row)) {
                    ArrayList<VariableTreeNodeImpl[]> vars = new ArrayList<VariableTreeNodeImpl[]>();
                    for (int r : selectedRows) {
                        path = VariablesManager.this.table.getTree().getPathForRow(r);
                        if (path == null) continue;
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        vars.add(VariablesManager.this.getPath(node));
                    }
                    assert (vars.size() > 0);
                    packet = VariablesManager.this.createVariableSelectPacket(VariablesManager.this.threadId, VariablesManager.this.frameIndex, VariablesManager.this.table.getSelectionModel().isSelectedIndex(row), (VariableTreeNodeImpl[][])vars.toArray((T[])new VariableTreeNodeImpl[vars.size()][]));
                } else {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    packet = VariablesManager.this.createVariableSelectPacket(VariablesManager.this.threadId, VariablesManager.this.frameIndex, VariablesManager.this.table.getSelectionModel().isSelectedIndex(row), new VariableTreeNodeImpl[][]{VariablesManager.this.getPath(node)});
                }
                QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), packet);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        private void handleMouseEvent(MouseEvent e) {
            if (!this.enabled) {
                return;
            }
            if (e.isPopupTrigger()) {
                int row = VariablesManager.this.table.rowAtPoint(e.getPoint());
                TreePath path = VariablesManager.this.table.getTree().getPathForRow(row);
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    NodeValue nodeValue = (NodeValue)node.getUserObject();
                    ActionListenerImpl.access$3202(VariablesManager.this.buttonListener, VariablesManager.this.getPath(node));
                    if (node.getParent() != VariablesManager.this.root) {
                        if (nodeValue != LOADING_USER_OBJECT && !nodeValue.name.contains("..")) {
                            NodeValue parentValue = (NodeValue)parent.getUserObject();
                            VariablesManager.this.buttonListener.watchPointField = parentValue.node.getConcreteTypeName() + "." + nodeValue.name;
                            this.setContextMenuVisibility(false, !nodeValue.name.startsWith("["));
                            VariablesManager.this.contextMenu.show(e.getComponent(), e.getX(), e.getY());
                        }
                    } else if (!VariablesManager.this.rootContextMenuItems.isEmpty() || VariablesManager.this.rootNodeEditable()) {
                        VariablesManager.this.buttonListener.rootIndex = parent.getIndex(node);
                        VariablesManager.this.buttonListener.rootName = nodeValue.name;
                        this.setContextMenuVisibility(true, false);
                        VariablesManager.this.contextMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        }

        private void setContextMenuVisibility(boolean isRoot, boolean isWatch) {
            VariablesManager.this.changeValueContextMenuItem.setVisible(!isRoot || VariablesManager.this.rootNodeEditable());
            VariablesManager.this.addAccessWatchPointContextMenuItem.setVisible(isWatch);
            VariablesManager.this.addModificationWatchPointContextMenuItem.setVisible(isWatch);
            VariablesManager.this.addAccessModificationWatchPointContextMenuItem.setVisible(isWatch);
            for (JMenuItem item : VariablesManager.this.rootContextMenuItems) {
                item.setVisible(isRoot);
            }
        }
    }

    private class ActionListenerImpl
    implements ActionListener {
        private String watchPointField = null;
        private int rootIndex = -1;
        private String rootName = null;
        private VariableTreeNodeImpl[] path = null;

        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == VariablesManager.this.staticsToolBarButton || e.getSource() == VariablesManager.this.constantsToolBarButton || e.getSource() == VariablesManager.this.syntheticsToolBarButton || e.getSource() == VariablesManager.this.logicalStructureToolBarButton) {
                VariableFilterPacket packet = VariablesManager.this.createVariableFilterPacket(VariablesManager.this.staticsToolBarButton.isSelected(), VariablesManager.this.constantsToolBarButton.isSelected(), VariablesManager.this.syntheticsToolBarButton.isSelected(), VariablesManager.this.logicalStructureToolBarButton.isSelected());
                QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), packet);
            } else if (e.getSource() == VariablesManager.this.changeValueContextMenuItem) {
                assert (this.path != null && this.path.length > 0);
                String expression = JOptionPane.showInputDialog(null, "Enter an expression for " + this.path[this.path.length - 1].getName() + ". Valid expressions can be either a single expression (e.g.\n\"new java.lang.Object()\") or a series of statements that return a value.", "Change Value", 3);
                if (expression != null) {
                    VariableSetExpressionPacket packet = VariablesManager.this.createVariableSetExpressionPacket(VariablesManager.this.threadId, VariablesManager.this.frameIndex, expression, this.path);
                    QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), packet);
                }
            } else if ((e.getSource() == VariablesManager.this.addAccessModificationWatchPointContextMenuItem || e.getSource() == VariablesManager.this.addModificationWatchPointContextMenuItem || e.getSource() == VariablesManager.this.addAccessWatchPointContextMenuItem) && this.watchPointField != null) {
                String name = this.watchPointField;
                if (e.getSource() == VariablesManager.this.addAccessModificationWatchPointContextMenuItem) {
                    name = name + ",access=true,modification=true";
                } else if (e.getSource() == VariablesManager.this.addModificationWatchPointContextMenuItem) {
                    name = name + ",access=false,modification=true";
                } else if (e.getSource() == VariablesManager.this.addAccessWatchPointContextMenuItem) {
                    name = name + ",access=true,modification=false";
                }
                BreakpointSpecification spec = BreakpointParser.deserialize(BreakpointType.WATCH_POINT, name);
                VariablesManager.this.breakpointManager.addBreakpoint(spec);
            } else if (VariablesManager.this.rootContextMenuItems.contains(e.getSource())) {
                assert (this.rootName != null && this.rootIndex >= 0);
                VariablesManager.this.rootContextMenuItemSelected((JMenuItem)e.getSource(), this.rootName, this.rootIndex);
            } else if (e.getSource() == VariablesManager.this.addFormatterToolBarButton) {
                String className = (String)JOptionPane.showInputDialog(null, "Enter the fully qualified class name for which you want to specify a formatting expression:", "Add Detail Formatter", 3, null, null, "<package>.<class>");
                String expression = null;
                if (className != null) {
                    expression = (String)JOptionPane.showInputDialog(null, "Enter a formatting  expression for '" + className + "':", "Add Detail Formatter", 3, null, null, "toString()");
                }
                if (className != null && expression != null) {
                    QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), new AddDetailFormattersPacketImpl(new String[]{className}, new String[]{expression}));
                }
            } else if (e.getSource() == VariablesManager.this.removeFormatterToolBarButton) {
                if (VariablesManager.this.detailFormatters.size() == 0) {
                    JOptionPane.showMessageDialog(null, "No detail formatters configured.", "Remove Detail Formatter", 1);
                } else {
                    Object[] formatters = VariablesManager.this.detailFormatters.keySet().toArray(new String[VariablesManager.this.detailFormatters.size()]);
                    Arrays.sort(formatters);
                    String className = (String)JOptionPane.showInputDialog(null, "Enter the fully qualified class name for which you want to remove a formatting expression:", "Remove Detail Formatter", 3, null, formatters, null);
                    if (className != null) {
                        QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), new RemoveDetailFormattersPacketImpl(new String[]{className}));
                    }
                }
            } else if (e.getSource() == VariablesManager.this.addLogicalStructureToolBarButton) {
                String className = (String)JOptionPane.showInputDialog(null, "Enter the fully qualified class name for which you want to specify a logical structure:", "Add Logical Structure Definition", 3, null, null, "<package>.<class>");
                boolean appliesToSubtypes = false;
                if (className != null) {
                    Object[] options = new String[]{"Applies to '" + className + "' only", "Applies to '" + className + "' and its subtypes"};
                    String choice = (String)JOptionPane.showInputDialog(null, "Choose whether the logical structure definition should apply to only one class or also its subtypes:", "Add Logical Structure Definition", 3, null, options, null);
                    if (choice == null) {
                        className = null;
                    } else {
                        appliesToSubtypes = choice == options[1];
                    }
                }
                int expressionCount = -1;
                if (className != null) {
                    String count;
                    while ((count = (String)JOptionPane.showInputDialog(null, "Enter the number of expressions used for the logical structure:", "Add Logical Structure Definition", 3, null, null, "1")) != null) {
                        try {
                            expressionCount = Integer.parseInt(count);
                            break;
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(null, "Yout input '" + count + "' is not a number.\nPlease try again.", "Incorrect Expression Count Format", 0);
                        }
                    }
                }
                LinkedHashMap<String, String> expressions = new LinkedHashMap<String, String>();
                if (className != null) {
                    for (int i = 0; i < expressionCount; ++i) {
                        String name = "";
                        if (expressionCount != 1) {
                            name = (String)JOptionPane.showInputDialog(null, "Enter the name of the " + (i + 1) + ". expression used for the logical structure:", "Add Logical Structure Definition", 3, null, null, "<name>");
                        }
                        String expr = null;
                        if (name != null) {
                            expr = (String)JOptionPane.showInputDialog(null, "Enter the " + (expressionCount == 1 ? "" : i + 1 + ". ") + "expression used for the logical structure:", "Add Logical Structure Definition", 3, null, null, "<expression>");
                        }
                        if (name == null || expr == null) {
                            expressions.clear();
                            break;
                        }
                        expressions.put(name, expr);
                    }
                }
                if (className != null && expressions.size() > 0) {
                    String[] names = new String[expressions.size()];
                    String[] expr = new String[expressions.size()];
                    int i = 0;
                    for (Map.Entry entry : expressions.entrySet()) {
                        names[i] = (String)entry.getKey();
                        expr[i] = (String)entry.getValue();
                        ++i;
                    }
                    LogicalStructureDefinition[] definition = new LogicalStructureDefinition[]{new LogicalStructureDefinition(className, appliesToSubtypes, names, expr)};
                    QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), new AddLogicalStructuresPacketImpl(definition));
                }
            } else if (e.getSource() == VariablesManager.this.removeLogicalStructureToolBarButton) {
                if (VariablesManager.this.logicalStructureDefinitions.size() == 0) {
                    JOptionPane.showMessageDialog(null, "No logical structure definitions configured.", "Remove Logical Structure Definition", 1);
                } else {
                    Object[] definitions = VariablesManager.this.logicalStructureDefinitions.keySet().toArray(new String[VariablesManager.this.logicalStructureDefinitions.size()]);
                    Arrays.sort(definitions);
                    String className = (String)JOptionPane.showInputDialog(null, "Enter the fully qualified class name for which you want to remove a logical structure definition:", "Remove Logical Structure Definition", 3, null, definitions, null);
                    if (className != null) {
                        QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), new RemoveLogicalStructuresPacketImpl(new String[]{className}));
                    }
                }
            }
            this.watchPointField = null;
            this.rootName = null;
            this.rootIndex = -1;
            this.path = null;
        }

        static /* synthetic */ VariableTreeNodeImpl[] access$3202(ActionListenerImpl x0, VariableTreeNodeImpl[] x1) {
            x0.path = x1;
            return x1;
        }
    }

    private class TreeExpansionListenerImpl
    implements TreeExpansionListener {
        private boolean enabled = true;

        private TreeExpansionListenerImpl() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (!this.enabled) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            VariableExpansionPacket packet = VariablesManager.this.createVariableExpansionPacket(VariablesManager.this.threadId, VariablesManager.this.frameIndex, true, VariablesManager.this.getPath(node));
            QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), packet);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (!this.enabled) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            VariableExpansionPacket packet = VariablesManager.this.createVariableExpansionPacket(VariablesManager.this.threadId, VariablesManager.this.frameIndex, false, VariablesManager.this.getPath(node));
            QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), packet);
        }
    }

    private static class NodeValue {
        private final VariableTreePacket.VariableNode node;
        private final String name;
        private final String value;

        public NodeValue(VariableTreePacket.VariableNode node, String name, String value) {
            this.node = node;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }

    private class VariablesTreeTableModel
    extends AbstractTreeTableModel {
        private static final int NAME_COLUMN = 0;
        private static final int VALUE_COLUMN = 1;
        private final String[] columnNames;
        private final Class<?>[] columnTypes;

        public VariablesTreeTableModel(Object r) {
            super(r);
            this.columnNames = new String[]{"Name", "Value"};
            this.columnTypes = new Class[]{TreeTableModel.class, String.class};
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.columnTypes[column];
        }

        @Override
        public Object getValueAt(Object node, int column) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            Object value = treeNode.getUserObject();
            if (value instanceof NodeValue) {
                NodeValue pair = (NodeValue)value;
                if (column == 0) {
                    return pair.name;
                }
                if (column == 1) {
                    return pair.value;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, Object node, int column) {
            if (column == 1) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                NodeValue value = (NodeValue)treeNode.getUserObject();
                if (!value.value.equals(aValue)) {
                    VariableSetPacket packet = VariablesManager.this.createVariableSetPacket(VariablesManager.this.threadId, VariablesManager.this.frameIndex, (String)aValue, VariablesManager.this.getPath(treeNode));
                    QueueHelper.put(VariablesManager.this.controller.getWriteQueue(), packet);
                    treeNode.setUserObject(new NodeValue(value.node, value.name, "Modifying..."));
                }
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getChild(Object parent, int index) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)parent;
            return treeNode.getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)parent;
            return treeNode.getChildCount();
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            DefaultMutableTreeNode treeNode;
            if (column == 1 && ((treeNode = (DefaultMutableTreeNode)node).getParent() != VariablesManager.this.root || VariablesManager.this.rootNodeEditable())) {
                NodeValue value = (NodeValue)treeNode.getUserObject();
                return value != null && value.node.isDirectlySettable();
            }
            return super.isCellEditable(node, column);
        }
    }
}

