/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 3052002107195969630L;

    public static void show(Frame owner) {
        AboutDialog ad = new AboutDialog(owner, "About SAP JVM Debugger", "SAP JVM Debugger", "Version: 2.4.14", "Copyright \u00a9 SAP SE 2018.  All rights reserved.");
        ad.setVisible(true);
    }

    public AboutDialog(Frame owner, String title, String name, String version, String text) {
        super(owner, title, true);
        JPanel contentPanel = new JPanel();
        contentPanel.setBackground(Color.WHITE);
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        ImageIcon image = ImageRepository.getImage("resources/debugger.png", "title image");
        JLabel imageLabel = new JLabel(image);
        imageLabel.setAlignmentX(0.5f);
        contentPanel.add(imageLabel);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel nameLabel = new JLabel(name);
        Font defaultFont = nameLabel.getFont();
        int fontSize = defaultFont.getSize();
        nameLabel.setAlignmentX(0.5f);
        nameLabel.setFont(defaultFont.deriveFont(1, (float)fontSize * 1.5f));
        contentPanel.add(nameLabel);
        JLabel versionLabel = new JLabel(version);
        versionLabel.setAlignmentX(0.5f);
        contentPanel.add(versionLabel);
        if (text != null) {
            String[] lines;
            contentPanel.add(Box.createRigidArea(new Dimension(0, 20)));
            for (String line : lines = text.split("\\\n")) {
                JLabel label = new JLabel(line);
                label.setAlignmentX(0.5f);
                contentPanel.add(label);
            }
        }
        contentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        Box b = Box.createVerticalBox();
        b.add(new JSeparator());
        b.add(Box.createRigidArea(new Dimension(0, 5)));
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AboutDialog.this.dispose();
            }
        });
        close.setAlignmentX(0.5f);
        b.add(close);
        b.add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add((Component)b, "South");
        this.setDefaultCloseOperation(2);
        Dimension size = this.getPreferredSize();
        size.height += 50;
        size.width += 50;
        this.setSize(size);
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rPane = super.createRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        }, stroke, 2);
        return rPane;
    }
}

