/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public abstract class CheckboxBreakpointDialog
implements ActionListener {
    private static final String HIDE_ON_ESCAPE = "hide-on-escape";
    private final JButton okButton;
    private final JButton cancelButton;
    private final JCheckBox[] checkboxButtons;
    private final JTextField textField = new JTextField(30);
    private final JDialog dialog;
    private String breakpointResult = null;

    protected CheckboxBreakpointDialog(JFrame frame, String title, JCheckBox ... checkboxButtons) {
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.checkboxButtons = checkboxButtons;
        this.dialog = new JDialog(frame, title, true);
    }

    protected boolean show(String fieldLabel, String message, String defaultInput) {
        JPanel main = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel(message);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        main.add((Component)label, "First");
        JPanel labels = new JPanel(new GridLayout(1, 1));
        JLabel textLabel = new JLabel(fieldLabel);
        textLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(textLabel);
        JPanel fields = new JPanel(new GridLayout(1, 1));
        fields.add(this.textField);
        JPanel textLine = new JPanel(new BorderLayout());
        textLine.add((Component)labels, "Before");
        textLine.add((Component)fields, "Center");
        main.add((Component)textLine, "Center");
        JPanel options = new JPanel(new GridLayout(this.checkboxButtons.length, 1));
        for (int i = 0; i < this.checkboxButtons.length; ++i) {
            options.add(this.checkboxButtons[i]);
        }
        main.add((Component)options, "Last");
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        JLabel icon = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        icon.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel horizontalPane = new JPanel(new BorderLayout(5, 5));
        horizontalPane.add((Component)icon, "Before");
        horizontalPane.add((Component)main, "Center");
        horizontalPane.add((Component)new JLabel(""), "After");
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        this.dialog.getContentPane().add((Component)horizontalPane, "First");
        this.dialog.getContentPane().add((Component)buttons, "Last");
        this.dialog.getContentPane().setFocusTraversalPolicy(new FocusTraversalPolicy(){
            private final List<Component> inputFields = new ArrayList<Component>();
            {
                this.inputFields.add(CheckboxBreakpointDialog.this.textField);
                for (int i = 0; i < CheckboxBreakpointDialog.this.checkboxButtons.length; ++i) {
                    this.inputFields.add(CheckboxBreakpointDialog.this.checkboxButtons[i]);
                }
                this.inputFields.add(CheckboxBreakpointDialog.this.okButton);
                this.inputFields.add(CheckboxBreakpointDialog.this.cancelButton);
            }

            @Override
            public Component getLastComponent(Container container) {
                return this.inputFields.get(this.inputFields.size() - 1);
            }

            @Override
            public Component getFirstComponent(Container container) {
                return this.inputFields.get(0);
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return this.getFirstComponent(container);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int index;
                Component previous = component;
                while (!(previous = this.inputFields.get(index = (this.inputFields.indexOf(previous) - 1 + this.inputFields.size()) % this.inputFields.size())).isEnabled()) {
                }
                return previous;
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int index;
                Component next = component;
                while (!(next = this.inputFields.get(index = (this.inputFields.indexOf(next) + 1) % this.inputFields.size())).isEnabled()) {
                }
                return next;
            }
        });
        this.dialog.getContentPane().setFocusTraversalPolicyProvider(true);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), HIDE_ON_ESCAPE);
        this.dialog.getRootPane().getActionMap().put(HIDE_ON_ESCAPE, new AbstractAction(){
            private static final long serialVersionUID = -382411802560663789L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckboxBreakpointDialog.this.actionPerformed(e);
            }
        });
        this.dialog.pack();
        this.textField.setText(defaultInput);
        this.textField.selectAll();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.breakpointResult != null;
    }

    public String getBreakpointResult() {
        return this.breakpointResult;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.textField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter a non-empty value.", "Data Missing", 0);
                return;
            }
            boolean[] options = new boolean[this.checkboxButtons.length];
            for (int i = 0; i < this.checkboxButtons.length; ++i) {
                options[i] = this.checkboxButtons[i].isSelected();
            }
            this.breakpointResult = this.getBreakpoint(this.textField.getText(), options);
        } else assert (e.getSource() == this.cancelButton || e.getSource() == this.dialog.getRootPane());
        this.dialog.setVisible(false);
    }

    protected abstract String getBreakpoint(String var1, boolean ... var2);
}

