/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public final class CloudConnectionDialog
implements ActionListener {
    private static final String HIDE_ON_ESCAPE = "hide-on-escape";
    private static final String CLOUD_ACCOUNT_KEY = "cloud_account";
    private static final String CLOUD_APPLICATION_KEY = "cloud_application";
    private static final String CLOUD_COMPONENT_KEY = "cloud_component";
    private static final String CLOUD_LANDSCAPE_KEY = "cloud_landscape";
    private static final String CLOUD_USER_KEY = "cloud_user";
    private static final String PROXY_KEY = "proxy";
    private static final String PROXY_HOST_KEY = "proxy_host";
    private static final String PROXY_PORT_KEY = "proxy_port";
    private static final String SAPJVM_CODELINE = System.getProperty("com.sap.vm.codeline", "_REL");
    private static final String[] CLOUD_LANDSCAPES;
    private final JButton okButton;
    private final JButton cancelButton;
    private final JTextField applicationField = new JTextField(30);
    private final JTextField accountField = new JTextField(30);
    private final JTextField componentField = new JTextField("web", 30);
    private final JComboBox<String> landscapeField = new JComboBox<String>(CLOUD_LANDSCAPES);
    private final JTextField userField = new JTextField(30);
    private final JPasswordField passwordField = new JPasswordField(30);
    private final JTextField proxyHostField = new JTextField(System.getProperty("http.proxyHost", ""), 30);
    private final JTextField proxyPortField = new JTextField(System.getProperty("http.proxyPort", ""), 30);
    private final JCheckBox proxyButton;
    private final JDialog dialog;
    private final JvmDebugger.SwingDebugger context;
    private boolean finished = false;

    public CloudConnectionDialog(JFrame frame, JvmDebugger.SwingDebugger context) {
        this.context = context;
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.proxyButton = new JCheckBox("Use Proxy", true);
        this.proxyButton.addActionListener(this);
        this.proxyButton.doClick();
        if (this.proxyHostField.getText().length() > 0 && this.proxyPortField.getText().length() > 0) {
            this.proxyButton.doClick();
        }
        this.landscapeField.setEditable(true);
        this.dialog = new JDialog(frame, "Debugging Cloud Connection Setup", true);
        this.loadProperties();
    }

    public boolean show() {
        JPanel main = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel("Please enter the cloud debugging connection details:");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        main.add((Component)label, "First");
        JPanel labels = new JPanel(new GridLayout(8, 1));
        JLabel applicationLabel = new JLabel("Application Name:");
        applicationLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(applicationLabel);
        JLabel accountLabel = new JLabel("Account Name:");
        accountLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(accountLabel);
        JLabel componentLabel = new JLabel("Component Name:");
        componentLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(componentLabel);
        JLabel landscapeLabel = new JLabel("Cloud Landscape URL:");
        landscapeLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(landscapeLabel);
        JLabel userLabel = new JLabel("User Name:");
        userLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(userLabel);
        JLabel passwordLabel = new JLabel("Password:");
        passwordLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(passwordLabel);
        JLabel proxyHostLabel = new JLabel("Proxy Host:");
        proxyHostLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(proxyHostLabel);
        JLabel proxyPortLabel = new JLabel("Proxy Port:");
        proxyPortLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        labels.add(proxyPortLabel);
        JPanel fields = new JPanel(new GridLayout(8, 1));
        fields.add(this.applicationField);
        fields.add(this.accountField);
        fields.add(this.componentField);
        fields.add(this.landscapeField);
        fields.add(this.userField);
        fields.add(this.passwordField);
        fields.add(this.proxyHostField);
        fields.add(this.proxyPortField);
        main.add((Component)labels, "Center");
        main.add((Component)fields, "After");
        main.add((Component)this.proxyButton, "Last");
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        JLabel icon = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        icon.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel horizontalPane = new JPanel(new BorderLayout(5, 5));
        horizontalPane.add((Component)icon, "Before");
        horizontalPane.add((Component)main, "Center");
        horizontalPane.add((Component)new JLabel(""), "After");
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        this.dialog.getContentPane().add((Component)horizontalPane, "First");
        this.dialog.getContentPane().add((Component)buttons, "Last");
        this.dialog.getContentPane().setFocusTraversalPolicy(new FocusTraversalPolicy(){
            private final List<Component> inputFields;
            {
                this.inputFields = Arrays.asList(CloudConnectionDialog.this.applicationField, CloudConnectionDialog.this.accountField, CloudConnectionDialog.this.componentField, CloudConnectionDialog.this.landscapeField, CloudConnectionDialog.this.userField, CloudConnectionDialog.this.passwordField, CloudConnectionDialog.this.proxyHostField, CloudConnectionDialog.this.proxyPortField, CloudConnectionDialog.this.proxyButton, CloudConnectionDialog.this.okButton, CloudConnectionDialog.this.cancelButton);
            }

            @Override
            public Component getLastComponent(Container container) {
                return this.inputFields.get(this.inputFields.size() - 1);
            }

            @Override
            public Component getFirstComponent(Container container) {
                return this.inputFields.get(0);
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return this.getFirstComponent(container);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int index;
                Component previous = component;
                while (!(previous = this.inputFields.get(index = (this.inputFields.indexOf(previous) - 1 + this.inputFields.size()) % this.inputFields.size())).isEnabled()) {
                }
                return previous;
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int index;
                Component next = component;
                while (!(next = this.inputFields.get(index = (this.inputFields.indexOf(next) + 1) % this.inputFields.size())).isEnabled()) {
                }
                return next;
            }
        });
        this.dialog.getContentPane().setFocusTraversalPolicyProvider(true);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), HIDE_ON_ESCAPE);
        this.dialog.getRootPane().getActionMap().put(HIDE_ON_ESCAPE, new AbstractAction(){
            private static final long serialVersionUID = -5644685039689411703L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudConnectionDialog.this.actionPerformed(e);
            }
        });
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.finished;
    }

    public String getApplicationName() {
        return this.applicationField.getText();
    }

    public String getAccountName() {
        return this.accountField.getText();
    }

    public String getComponentName() {
        return this.componentField.getText();
    }

    public String getLandscapeUrl() {
        return this.landscapeField.getSelectedItem().toString();
    }

    public String getUserName() {
        return this.userField.getText();
    }

    public String getPassword() {
        return this.passwordField.getText();
    }

    public Proxy getProxy() {
        if (this.proxyButton.isSelected()) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHostField.getText(), Integer.parseInt(this.proxyPortField.getText())));
        }
        return new Proxy(Proxy.Type.DIRECT, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.proxyButton) {
            this.proxyHostField.setEnabled(this.proxyButton.isSelected());
            this.proxyPortField.setEnabled(this.proxyButton.isSelected());
            return;
        }
        if (e.getSource() == this.okButton) {
            if (this.applicationField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter an application name.", "Cloud Application Missing", 0);
                return;
            }
            if (this.accountField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter an account name.", "Cloud Account Missing", 0);
                return;
            }
            if (this.componentField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter a component name.", "Cloud Component Missing", 0);
                return;
            }
            if (this.landscapeField.getSelectedItem().toString().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter a cloud landscape URL.", "Cloud Landscape URL Missing", 0);
                return;
            }
            if (this.userField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter a user name.", "Cloud User Missing", 0);
                return;
            }
            if (this.passwordField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter a password.", "Cloud Password Missing", 0);
                return;
            }
            if (this.proxyButton.isSelected() && this.proxyHostField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter a proxy host.", "Proxy Host Missing", 0);
                return;
            }
            if (this.proxyButton.isSelected() && this.proxyPortField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.dialog, "Please enter a proxy port.", "Proxy Port Missing", 0);
                return;
            }
            if (this.proxyButton.isSelected()) {
                try {
                    int port = Integer.parseInt(this.proxyPortField.getText());
                    if (port <= 0 || port > 65535) {
                        JOptionPane.showMessageDialog(this.dialog, "Please enter a valid proxy port.", "Proxy Port Invalid", 0);
                        return;
                    }
                }
                catch (NumberFormatException exc) {
                    JOptionPane.showMessageDialog(this.dialog, "Please enter a valid proxy port.", "Proxy Port Invalid", 0);
                    return;
                }
            }
            this.finished = true;
        } else assert (e.getSource() == this.cancelButton || e.getSource() == this.dialog.getRootPane());
        this.dialog.setVisible(false);
        this.updateProperties();
    }

    private void loadProperties() {
        Properties properties = this.context.getProperties();
        this.accountField.setText(properties.getProperty(CLOUD_ACCOUNT_KEY, this.accountField.getText()));
        this.applicationField.setText(properties.getProperty(CLOUD_APPLICATION_KEY, this.applicationField.getText()));
        this.componentField.setText(properties.getProperty(CLOUD_COMPONENT_KEY, this.componentField.getText()));
        String landscape = properties.getProperty(CLOUD_LANDSCAPE_KEY);
        if (landscape != null) {
            if (!Arrays.asList(CLOUD_LANDSCAPES).contains(landscape)) {
                this.landscapeField.addItem(landscape);
            }
            this.landscapeField.setSelectedItem(landscape);
        }
        this.userField.setText(properties.getProperty(CLOUD_USER_KEY, this.userField.getText()));
        this.proxyHostField.setText(properties.getProperty(PROXY_HOST_KEY, this.proxyHostField.getText()));
        this.proxyPortField.setText(properties.getProperty(PROXY_PORT_KEY, this.proxyPortField.getText()));
        String hasProxy = properties.getProperty(PROXY_KEY, "false");
        this.proxyButton.setSelected(Boolean.parseBoolean(hasProxy));
        this.actionPerformed(new ActionEvent(this.proxyButton, 0, "load-properties"));
    }

    private void updateProperties() {
        Properties properties = this.context.getProperties();
        properties.setProperty(CLOUD_ACCOUNT_KEY, this.accountField.getText());
        properties.setProperty(CLOUD_APPLICATION_KEY, this.applicationField.getText());
        properties.setProperty(CLOUD_COMPONENT_KEY, this.componentField.getText());
        properties.setProperty(CLOUD_LANDSCAPE_KEY, this.landscapeField.getSelectedItem().toString());
        properties.setProperty(CLOUD_USER_KEY, this.userField.getText());
        properties.setProperty(PROXY_HOST_KEY, this.proxyHostField.getText());
        properties.setProperty(PROXY_PORT_KEY, this.proxyPortField.getText());
        properties.setProperty(PROXY_KEY, Boolean.toString(this.proxyButton.isSelected()));
    }

    public static void clearProperties(JvmDebugger.SwingDebugger context) {
        Properties properties = context.getProperties();
        properties.remove(CLOUD_ACCOUNT_KEY);
        properties.remove(CLOUD_APPLICATION_KEY);
        properties.remove(CLOUD_COMPONENT_KEY);
        properties.remove(CLOUD_LANDSCAPE_KEY);
        properties.remove(CLOUD_USER_KEY);
        properties.remove(PROXY_HOST_KEY);
        properties.remove(PROXY_PORT_KEY);
        properties.remove(PROXY_KEY);
    }

    static {
        ArrayList<String> landscapes = new ArrayList<String>();
        landscapes.add("https://debugging.ae1.hana.ondemand.com");
        landscapes.add("https://debugging.ap1.hana.ondemand.com");
        landscapes.add("https://debugging.br1.hana.ondemand.com");
        landscapes.add("https://debugging.ca1.hana.ondemand.com");
        landscapes.add("https://debugging.cn1.hana.ondemand.com");
        landscapes.add("https://debugging.hana.ondemand.com");
        landscapes.add("https://debugging.eu2.hana.ondemand.com");
        landscapes.add("https://debugging.eu3.hana.ondemand.com");
        landscapes.add("https://debugging.jp1.hana.ondemand.com");
        landscapes.add("https://debugging.ru1.hana.ondemand.com");
        landscapes.add("https://debugging.sa1.hana.ondemand.com");
        landscapes.add("https://debugging.us1.hana.ondemand.com");
        landscapes.add("https://debugging.us2.hana.ondemand.com");
        landscapes.add("https://debugging.us3.hana.ondemand.com");
        landscapes.add("https://debugging.us4.hana.ondemand.com");
        if (!SAPJVM_CODELINE.endsWith("_REL")) {
            landscapes.add("https://debugging.int.sap.eu2.hana.ondemand.com");
            landscapes.add("https://debugging.staging.hanavlab.ondemand.com");
            landscapes.add("https://debugging.hanavlab.ondemand.com");
        }
        CLOUD_LANDSCAPES = landscapes.toArray(new String[landscapes.size()]);
    }
}

