/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public final class ConnectionDialog
implements ActionListener {
    private static final String HIDE_ON_ESCAPE = "hide-on-escape";
    private static final String DEBUGGEE_HOST_KEY = "debuggee_host";
    private static final String DEBUGGEE_PORT_KEY = "debuggee_port";
    private static final String BACKEND_HOST_KEY = "backend_host";
    private static final String BACKEND_PORT_KEY = "backend_port";
    private static final String JDWP_CONNECTION_KEY = "direct_jdwp_connection";
    private static final String ONLY_BACKEND_CONNECTION_KEY = "only_backend_connection";
    private final JButton okButton;
    private final JButton cancelButton;
    private final JCheckBox jdwpConnectionButton;
    private final JCheckBox onlyBackendButton;
    private final JTextField debuggeeHostField = new JTextField(15);
    private final JTextField debuggeePortField = new JTextField(5);
    private final JTextField backendHostField = new JTextField(15);
    private final JTextField backendPortField = new JTextField(5);
    private final JDialog dialog;
    private final JvmDebugger.SwingDebugger context;
    private boolean spawnBackend = false;
    private String debuggee = null;
    private String backend = null;

    public ConnectionDialog(JFrame frame, JvmDebugger.SwingDebugger context) {
        this.context = context;
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.jdwpConnectionButton = new JCheckBox("Direct JDWP Connection");
        this.jdwpConnectionButton.addActionListener(this);
        this.onlyBackendButton = new JCheckBox("Debuggee details already specified to jvmdebugger-daemon");
        this.onlyBackendButton.addActionListener(this);
        this.dialog = new JDialog(frame, "Debugging Connection Setup", true);
        this.loadProperties();
    }

    public boolean show() {
        JPanel main = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel("Please enter the debugging connection details:");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        main.add((Component)label, "First");
        JPanel hostLabels = new JPanel(new GridLayout(2, 1));
        JLabel debugeeHostlabel = new JLabel("Debuggee Host:");
        debugeeHostlabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        hostLabels.add(debugeeHostlabel);
        JLabel backendHostlabel = new JLabel("Backend Host:");
        backendHostlabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        hostLabels.add(backendHostlabel);
        JPanel hostFields = new JPanel(new GridLayout(2, 1));
        hostFields.add(this.debuggeeHostField);
        hostFields.add(this.backendHostField);
        JPanel portLabels = new JPanel(new GridLayout(2, 1));
        JLabel debugeePortLabel = new JLabel("Debuggee Port:");
        debugeePortLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        portLabels.add(debugeePortLabel);
        JLabel backendPortLabel = new JLabel("Backend Port:");
        backendPortLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        portLabels.add(backendPortLabel);
        JPanel portFields = new JPanel(new GridLayout(2, 1));
        portFields.add(this.debuggeePortField);
        portFields.add(this.backendPortField);
        JPanel hosts = new JPanel(new BorderLayout());
        hosts.add((Component)hostLabels, "Before");
        hosts.add((Component)hostFields, "Center");
        JPanel ports = new JPanel(new BorderLayout());
        ports.add((Component)portLabels, "Before");
        ports.add((Component)portFields, "Center");
        JPanel checkBoxes = new JPanel(new GridLayout(2, 1));
        checkBoxes.add(this.jdwpConnectionButton);
        checkBoxes.add(this.onlyBackendButton);
        main.add((Component)hosts, "Center");
        main.add((Component)ports, "After");
        main.add((Component)checkBoxes, "Last");
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        JLabel icon = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        icon.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel horizontalPane = new JPanel(new BorderLayout(5, 5));
        horizontalPane.add((Component)icon, "Before");
        horizontalPane.add((Component)main, "Center");
        horizontalPane.add((Component)new JLabel(""), "After");
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        this.dialog.getContentPane().add((Component)horizontalPane, "First");
        this.dialog.getContentPane().add((Component)buttons, "Last");
        this.dialog.getContentPane().setFocusTraversalPolicy(new FocusTraversalPolicy(){
            private final List<Component> inputFields;
            {
                this.inputFields = Arrays.asList(ConnectionDialog.this.debuggeeHostField, ConnectionDialog.this.debuggeePortField, ConnectionDialog.this.backendHostField, ConnectionDialog.this.backendPortField, ConnectionDialog.this.jdwpConnectionButton, ConnectionDialog.this.onlyBackendButton, ConnectionDialog.this.okButton, ConnectionDialog.this.cancelButton);
            }

            @Override
            public Component getLastComponent(Container container) {
                return this.inputFields.get(this.inputFields.size() - 1);
            }

            @Override
            public Component getFirstComponent(Container container) {
                return this.inputFields.get(0);
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return this.getFirstComponent(container);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int index;
                Component previous = component;
                while (!(previous = this.inputFields.get(index = (this.inputFields.indexOf(previous) - 1 + this.inputFields.size()) % this.inputFields.size())).isEnabled()) {
                }
                return previous;
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int index;
                Component next = component;
                while (!(next = this.inputFields.get(index = (this.inputFields.indexOf(next) + 1) % this.inputFields.size())).isEnabled()) {
                }
                return next;
            }
        });
        this.dialog.getContentPane().setFocusTraversalPolicyProvider(true);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), HIDE_ON_ESCAPE);
        this.dialog.getRootPane().getActionMap().put(HIDE_ON_ESCAPE, new AbstractAction(){
            private static final long serialVersionUID = -1105187410205366010L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.actionPerformed(e);
            }
        });
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.debuggee != null || this.backend != null;
    }

    public String getDebuggeeAddress() {
        return this.debuggee;
    }

    public String getBackendAddress() {
        return this.backend;
    }

    public boolean spawnBackend() {
        return this.spawnBackend;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jdwpConnectionButton) {
            this.backendHostField.setEnabled(!this.jdwpConnectionButton.isSelected());
            this.backendPortField.setEnabled(!this.jdwpConnectionButton.isSelected());
            this.onlyBackendButton.setEnabled(!this.jdwpConnectionButton.isSelected());
            return;
        }
        if (e.getSource() == this.onlyBackendButton) {
            this.debuggeeHostField.setEnabled(!this.onlyBackendButton.isSelected());
            this.debuggeePortField.setEnabled(!this.onlyBackendButton.isSelected());
            this.jdwpConnectionButton.setEnabled(!this.onlyBackendButton.isSelected());
            return;
        }
        if (e.getSource() == this.okButton) {
            if (!this.onlyBackendButton.isEnabled() || !this.onlyBackendButton.isSelected()) {
                if (this.debuggeeHostField.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.dialog, "Please enter a debuggee host.", "Debuggee Host Missing", 0);
                    return;
                }
                if (this.debuggeePortField.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.dialog, "Please enter a debuggee port.", "Debuggee Port Missing", 0);
                    return;
                }
            }
            if (!this.jdwpConnectionButton.isEnabled() || !this.jdwpConnectionButton.isSelected()) {
                if (this.backendHostField.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.dialog, "Please enter a backend host.", "Backend Host Missing", 0);
                    return;
                }
                if (!"-".equals(this.backendHostField.getText().trim()) && this.backendPortField.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.dialog, "Please enter a backend port.", "Backend Port Missing", 0);
                    return;
                }
            }
            boolean bl = this.spawnBackend = this.jdwpConnectionButton.isEnabled() && this.jdwpConnectionButton.isSelected();
            if (!this.onlyBackendButton.isEnabled() || !this.onlyBackendButton.isSelected()) {
                this.debuggee = this.debuggeeHostField.getText() + ":" + this.debuggeePortField.getText();
            }
            if (!this.spawnBackend) {
                this.backend = this.backendHostField.getText() + ":" + this.backendPortField.getText();
            }
        } else assert (e.getSource() == this.cancelButton || e.getSource() == this.dialog.getRootPane());
        this.dialog.setVisible(false);
        this.updateProperties();
    }

    private void loadProperties() {
        Properties properties = this.context.getProperties();
        this.debuggeeHostField.setText(properties.getProperty(DEBUGGEE_HOST_KEY, ""));
        this.debuggeePortField.setText(properties.getProperty(DEBUGGEE_PORT_KEY, ""));
        this.backendHostField.setText(properties.getProperty(BACKEND_HOST_KEY, ""));
        this.backendPortField.setText(properties.getProperty(BACKEND_PORT_KEY, ""));
        String jdwp = properties.getProperty(JDWP_CONNECTION_KEY, "false");
        this.jdwpConnectionButton.setSelected(Boolean.parseBoolean(jdwp));
        this.actionPerformed(new ActionEvent(this.jdwpConnectionButton, 0, "load-properties"));
        String only = properties.getProperty(ONLY_BACKEND_CONNECTION_KEY, "false");
        this.onlyBackendButton.setSelected(Boolean.parseBoolean(only));
        this.actionPerformed(new ActionEvent(this.onlyBackendButton, 0, "load-properties"));
    }

    private void updateProperties() {
        Properties properties = this.context.getProperties();
        properties.setProperty(DEBUGGEE_HOST_KEY, this.debuggeeHostField.getText());
        properties.setProperty(DEBUGGEE_PORT_KEY, this.debuggeePortField.getText());
        properties.setProperty(BACKEND_HOST_KEY, this.backendHostField.getText());
        properties.setProperty(BACKEND_PORT_KEY, this.backendPortField.getText());
        properties.setProperty(JDWP_CONNECTION_KEY, Boolean.toString(this.jdwpConnectionButton.isSelected()));
        properties.setProperty(ONLY_BACKEND_CONNECTION_KEY, Boolean.toString(this.onlyBackendButton.isSelected()));
    }

    public static void clearProperties(JvmDebugger.SwingDebugger context) {
        Properties properties = context.getProperties();
        properties.remove(DEBUGGEE_HOST_KEY);
        properties.remove(DEBUGGEE_PORT_KEY);
        properties.remove(BACKEND_HOST_KEY);
        properties.remove(BACKEND_PORT_KEY);
        properties.remove(JDWP_CONNECTION_KEY);
        properties.remove(ONLY_BACKEND_CONNECTION_KEY);
    }
}

