/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public abstract class MultiLineBreakpointDialog
implements ActionListener {
    private static final String HIDE_ON_ESCAPE = "hide-on-escape";
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton;
    private final JTextField[] textFields;
    private final JDialog dialog;
    private String breakpointResult = null;

    protected MultiLineBreakpointDialog(JFrame frame, String title, JTextField ... textFields) {
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.textFields = textFields;
        this.dialog = new JDialog(frame, title, true);
    }

    public boolean show(String[] fieldLabels, String message, String[] defaultInputs) {
        int i;
        if (this.textFields.length != fieldLabels.length || fieldLabels.length != defaultInputs.length) {
            throw new IllegalArgumentException(this.textFields.length + " fields, " + fieldLabels.length + " labels, " + defaultInputs.length + " inputs");
        }
        JPanel main = new JPanel(new BorderLayout(5, 5));
        String[] messages = message.split("\n");
        if (messages.length <= 1) {
            JLabel label = new JLabel(message);
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            main.add((Component)label, "First");
        } else {
            JPanel labelPanel = new JPanel(new GridLayout(messages.length, 1));
            labelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            for (i = 0; i < messages.length; ++i) {
                JLabel label = new JLabel(messages[i]);
                labelPanel.add(label);
            }
            main.add((Component)labelPanel, "First");
        }
        JPanel labels = new JPanel(new GridLayout(fieldLabels.length, 1));
        for (i = 0; i < fieldLabels.length; ++i) {
            JLabel l = new JLabel(fieldLabels[i]);
            l.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            labels.add(l);
        }
        JPanel fields = new JPanel(new GridLayout(this.textFields.length, 1));
        for (int i2 = 0; i2 < this.textFields.length; ++i2) {
            fields.add(this.textFields[i2]);
        }
        main.add((Component)labels, "Center");
        main.add((Component)fields, "After");
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        JLabel icon = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        icon.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel horizontalPane = new JPanel(new BorderLayout(5, 5));
        horizontalPane.add((Component)icon, "Before");
        horizontalPane.add((Component)main, "Center");
        horizontalPane.add((Component)new JLabel(""), "After");
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        this.dialog.getContentPane().add((Component)horizontalPane, "First");
        this.dialog.getContentPane().add((Component)buttons, "Last");
        this.dialog.getContentPane().setFocusTraversalPolicy(new FocusTraversalPolicy(){
            private final List<Component> inputFields = new ArrayList<Component>();
            {
                for (int i = 0; i < MultiLineBreakpointDialog.this.textFields.length; ++i) {
                    this.inputFields.add(MultiLineBreakpointDialog.this.textFields[i]);
                }
                this.inputFields.add(MultiLineBreakpointDialog.this.okButton);
                this.inputFields.add(MultiLineBreakpointDialog.this.cancelButton);
            }

            @Override
            public Component getLastComponent(Container container) {
                return this.inputFields.get(this.inputFields.size() - 1);
            }

            @Override
            public Component getFirstComponent(Container container) {
                return this.inputFields.get(0);
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return this.getFirstComponent(container);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int index;
                Component previous = component;
                while (!(previous = this.inputFields.get(index = (this.inputFields.indexOf(previous) - 1 + this.inputFields.size()) % this.inputFields.size())).isEnabled()) {
                }
                return previous;
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int index;
                Component next = component;
                while (!(next = this.inputFields.get(index = (this.inputFields.indexOf(next) + 1) % this.inputFields.size())).isEnabled()) {
                }
                return next;
            }
        });
        this.dialog.getContentPane().setFocusTraversalPolicyProvider(true);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), HIDE_ON_ESCAPE);
        this.dialog.getRootPane().getActionMap().put(HIDE_ON_ESCAPE, new AbstractAction(){
            private static final long serialVersionUID = 8938596337843579007L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiLineBreakpointDialog.this.actionPerformed(e);
            }
        });
        this.dialog.pack();
        for (int i3 = 0; i3 < this.textFields.length; ++i3) {
            this.textFields[i3].setText(defaultInputs[i3]);
        }
        this.textFields[0].selectAll();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.breakpointResult != null;
    }

    public String getBreakpointResult() {
        return this.breakpointResult;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String[] input = new String[this.textFields.length];
            for (int i = 0; i < this.textFields.length; ++i) {
                input[i] = this.textFields[i].getText();
            }
            this.breakpointResult = this.getBreakpoint(input);
            if (this.breakpointResult == null) {
                return;
            }
        } else assert (e.getSource() == this.cancelButton || e.getSource() == this.dialog.getRootPane());
        this.dialog.setVisible(false);
    }

    protected JDialog getDialog() {
        return this.dialog;
    }

    protected abstract String getBreakpoint(String ... var1);
}

