/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import com.sap.jvm.tracing.Trace;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public final class ReturnValueConfigurationDialog
implements ActionListener {
    private static final String RETURN_VALUES_ENABLED_KEY = "return_values_enabled";
    private static final String IGNORE_RETURN_VALUES_STORED_IN_LOCALS_KEY = "ignore_return_values_stored_in_locals";
    private static final String IGNORE_RETURN_VALUES_USED_AS_PARAMETERS_KEY = "ignore_return_values_used_as_parameters";
    private static final String IGNORE_RETURN_VALUES_USED_AS_RECEIVER_KEY = "ignore_return_values_used_as_receiver";
    private static final String IGNORED_RETURN_VALUES_METHODS_KEY = "ignored_return_values_methods";
    private static final String IGNORED_RETURN_VALUES_METHODS_NAME_PREFIX = "ignored_return_values_method_name_";
    private static final String IGNORED_RETURN_VALUES_METHODS_VALUE_PREFIX = "ignored_return_values_method_value_";
    private static final String RETURN_VALUES_METHODS_KEY = "return_values_methods";
    private static final String RETURN_VALUES_METHODS_NAME_PREFIX = "return_values_method_name_";
    private static final String RETURN_VALUES_METHODS_VALUE_PREFIX = "return_values_method_value_";
    private final JCheckBox enabledButton;
    private final JCheckBox ignoreLocalsButton;
    private final JCheckBox ignoreParametersButton;
    private final JCheckBox ignoreReceiverButton;
    private final JButton addButton;
    private final JButton removeButton;
    private final JButton editButton;
    private final Map<String, String> ignoredMethods = new LinkedHashMap<String, String>();
    private final Set<String> enabledIgnoredMethods = new LinkedHashSet<String>();
    private final List<String> ignoredMethodOrder = new ArrayList<String>();
    private final JvmDebugger.SwingDebugger context;
    private final JFrame frame;
    private final JTable ignoredMethodsTable;
    private final IgnoredMethodModel tableModel;

    public ReturnValueConfigurationDialog(JFrame frame, JvmDebugger.SwingDebugger context) {
        this.context = context;
        this.frame = frame;
        this.enabledButton = new JCheckBox("Show Return Values");
        this.enabledButton.setToolTipText("If checked the SAP JVM debugger will shown return values when stepping.");
        this.ignoreLocalsButton = new JCheckBox("Ignore return values directly stored in local variables");
        this.ignoreLocalsButton.setToolTipText("If checked no return values will be shown, if the return value is\ndirectly stored in a local variable, so it can be accessed by that\nvariable.");
        this.ignoreParametersButton = new JCheckBox("Ignore return values directly used as a parameter of another method");
        this.ignoreParametersButton.setToolTipText("If checked no return values will be shown, if the return value is\ndirectly used in another method call.");
        this.ignoreReceiverButton = new JCheckBox("Ignore return values directly used as the receiver of a method call");
        this.ignoreReceiverButton.setToolTipText("If checked no return values will be shown, if the return value is\ndirectly used as the receiver another method call (meaning a method\nis directy called on the return value).");
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(this);
        this.editButton.setEnabled(false);
        this.ignoredMethodsTable = new JTable();
        this.tableModel = new IgnoredMethodModel();
        this.loadProperties();
    }

    public boolean show() {
        boolean okPressed;
        Box main = Box.createVerticalBox();
        JLabel title = new JLabel("Specify if return values should be shown in the variables view when stepping in the debugger.");
        main.add(title);
        main.add(Box.createVerticalStrut(5));
        main.add(new JSeparator(0));
        main.add(Box.createVerticalStrut(5));
        main.add(this.enabledButton);
        main.add(this.ignoreLocalsButton);
        main.add(this.ignoreParametersButton);
        main.add(this.ignoreReceiverButton);
        main.add(Box.createVerticalStrut(20));
        JLabel listTitle = new JLabel("Methods for which not to report the return values");
        main.add(listTitle);
        Box listBox = Box.createHorizontalBox();
        this.ignoredMethodsTable.setModel(this.tableModel);
        this.ignoredMethodsTable.setTableHeader(null);
        TableCellRenderer renderer = this.ignoredMethodsTable.getCellRenderer(0, 0);
        Component component = this.ignoredMethodsTable.prepareRenderer(renderer, 0, 0);
        this.ignoredMethodsTable.getColumnModel().getColumn(0).setMaxWidth(component.getPreferredSize().width + 5);
        this.ignoredMethodsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ReturnValueConfigurationDialog.this.editButton.setEnabled(ReturnValueConfigurationDialog.this.ignoredMethodsTable.getSelectedRowCount() == 1);
                ReturnValueConfigurationDialog.this.removeButton.setEnabled(ReturnValueConfigurationDialog.this.ignoredMethodsTable.getSelectedRowCount() > 0);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.ignoredMethodsTable);
        scrollPane.setPreferredSize(this.ignoredMethodsTable.getPreferredSize());
        listBox.add(scrollPane);
        listBox.add(Box.createHorizontalStrut(5));
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(this.addButton);
        buttonBox.add(this.removeButton);
        buttonBox.add(this.editButton);
        listBox.add(buttonBox);
        listBox.setAlignmentX(0.0f);
        main.add(listBox);
        boolean bl = okPressed = JOptionPane.showConfirmDialog(this.frame, main, "Return Value Configuration", 2, -1) == 0;
        if (okPressed) {
            this.updateProperties();
        }
        return okPressed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block11: {
            block12: {
                int result;
                if (e.getSource() != this.addButton && e.getSource() != this.editButton) break block12;
                boolean isEdit = e.getSource() == this.editButton;
                String key = "";
                String value = "";
                if (isEdit) {
                    key = this.ignoredMethodOrder.get(this.ignoredMethodsTable.getSelectedRow());
                    value = this.ignoredMethods.get(key);
                }
                final Box dialogBox = Box.createVerticalBox();
                dialogBox.add(new JLabel("Specify a name and a regular expression to match methods for which no return values should be reported."));
                dialogBox.add(Box.createVerticalStrut(5));
                dialogBox.add(new JSeparator(0));
                dialogBox.add(Box.createVerticalStrut(5));
                dialogBox.add(new JLabel("Name:"));
                final JTextField nameField = new JTextField();
                nameField.setText(key);
                dialogBox.add(nameField);
                dialogBox.add(Box.createVerticalStrut(20));
                dialogBox.add(new JLabel("Regular expression (must match a method including the signature and return type):"));
                JTextField expressionField = new JTextField();
                expressionField.setText(value);
                dialogBox.add(expressionField);
                dialogBox.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                nameField.requestFocusInWindow();
                            }
                        });
                        dialogBox.removeAncestorListener(this);
                    }
                });
                while ((result = JOptionPane.showOptionDialog(this.frame, dialogBox, "Specify a name and regular expression", 2, -1, null, null, null)) == 0) {
                    int index;
                    String newKey = nameField.getText();
                    String newValue = expressionField.getText();
                    if ("".equals(newKey.trim()) || "".equals(newValue.trim())) {
                        JOptionPane.showMessageDialog(this.frame, "No empty values allowed. Please fill the text fields.", "No empty values allowed", 0);
                        continue;
                    }
                    if (!isEdit) {
                        if (this.ignoredMethods.containsKey(newKey)) {
                            JOptionPane.showMessageDialog(this.frame, "Name '" + newKey + "' already exists. Please choose a different name.", "Name already exists", 0);
                            continue;
                        }
                        this.ignoredMethodOrder.add(newKey);
                        this.ignoredMethods.put(newKey, newValue);
                        this.enabledIgnoredMethods.add(newKey);
                        index = this.ignoredMethodOrder.size() - 1;
                        this.tableModel.fireTableRowsInserted(index, index);
                    } else {
                        index = this.ignoredMethodsTable.getSelectedRow();
                        if (key.equals(newKey)) {
                            this.ignoredMethods.put(key, newValue);
                        } else {
                            if (this.ignoredMethods.containsKey(newKey)) {
                                JOptionPane.showMessageDialog(this.frame, "Name '" + newKey + "' already exists. Please choose a different name.", "Name already exists", 0);
                                continue;
                            }
                            this.ignoredMethods.remove(key);
                            if (this.enabledIgnoredMethods.remove(key)) {
                                this.enabledIgnoredMethods.add(newKey);
                            }
                            this.ignoredMethods.put(newKey, newValue);
                            this.ignoredMethodOrder.set(index, newKey);
                        }
                        this.tableModel.fireTableRowsUpdated(index, index);
                    }
                    break block11;
                }
                break block11;
            }
            if (e.getSource() != this.removeButton) break block11;
            int[] selectedRows = this.ignoredMethodsTable.getSelectedRows();
            Arrays.sort(selectedRows);
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int index = selectedRows[i];
                String key = this.ignoredMethodOrder.remove(index);
                this.ignoredMethods.remove(key);
                this.enabledIgnoredMethods.remove(key);
                this.tableModel.fireTableRowsDeleted(index, index);
            }
        }
    }

    private void loadProperties() {
        String value;
        String name;
        Properties properties = this.context.getProperties();
        this.enabledButton.setSelected(Boolean.parseBoolean(properties.getProperty(RETURN_VALUES_ENABLED_KEY, "true")));
        this.ignoreLocalsButton.setSelected(Boolean.parseBoolean(properties.getProperty(IGNORE_RETURN_VALUES_STORED_IN_LOCALS_KEY, "false")));
        this.ignoreParametersButton.setSelected(Boolean.parseBoolean(properties.getProperty(IGNORE_RETURN_VALUES_USED_AS_PARAMETERS_KEY, "false")));
        this.ignoreReceiverButton.setSelected(Boolean.parseBoolean(properties.getProperty(IGNORE_RETURN_VALUES_USED_AS_RECEIVER_KEY, "false")));
        String methodsNumber = properties.getProperty(RETURN_VALUES_METHODS_KEY, "0");
        int methods = 0;
        try {
            methods = Integer.parseInt(methodsNumber);
        }
        catch (NumberFormatException e) {
            Trace.warn((Throwable)e, (String)"Error while parsing the number of return value methods");
        }
        for (int i = 0; i < methods; ++i) {
            name = properties.getProperty(RETURN_VALUES_METHODS_NAME_PREFIX + i);
            value = properties.getProperty(RETURN_VALUES_METHODS_VALUE_PREFIX + i);
            if (name == null || value == null) continue;
            this.ignoredMethods.put(name, value);
        }
        methodsNumber = properties.getProperty(IGNORED_RETURN_VALUES_METHODS_KEY, "0");
        methods = 0;
        try {
            methods = Integer.parseInt(methodsNumber);
        }
        catch (NumberFormatException e) {
            Trace.warn((Throwable)e, (String)"Error while parsing the number of ignored return value methods");
        }
        for (int i = 0; i < methods; ++i) {
            name = properties.getProperty(IGNORED_RETURN_VALUES_METHODS_NAME_PREFIX + i);
            value = properties.getProperty(IGNORED_RETURN_VALUES_METHODS_VALUE_PREFIX + i);
            if (name == null || value == null) continue;
            this.ignoredMethods.put(name, value);
            this.enabledIgnoredMethods.add(name);
        }
        if (this.ignoredMethods.isEmpty()) {
            String appendName = "StringBuffer/StringBuilder append operations";
            String appendValue = "java[.]lang[.]String(Builder|Buffer)[.]append[(].*";
            this.ignoredMethods.put(appendName, appendValue);
            this.enabledIgnoredMethods.add(appendName);
            String accessorName = "Synthetic access methods for private fields";
            String accessorValue = ".*access[$][0-9]+[(][)].*";
            this.ignoredMethods.put(accessorName, accessorValue);
            this.enabledIgnoredMethods.add(accessorName);
        }
        this.ignoredMethodOrder.clear();
        this.ignoredMethodOrder.addAll(this.ignoredMethods.keySet());
    }

    private void updateProperties() {
        Properties properties = this.context.getProperties();
        properties.setProperty(RETURN_VALUES_ENABLED_KEY, Boolean.toString(this.enabledButton.isSelected()));
        properties.setProperty(IGNORE_RETURN_VALUES_STORED_IN_LOCALS_KEY, Boolean.toString(this.ignoreLocalsButton.isSelected()));
        properties.setProperty(IGNORE_RETURN_VALUES_USED_AS_PARAMETERS_KEY, Boolean.toString(this.ignoreParametersButton.isSelected()));
        properties.setProperty(IGNORE_RETURN_VALUES_USED_AS_RECEIVER_KEY, Boolean.toString(this.ignoreReceiverButton.isSelected()));
        properties.setProperty(IGNORED_RETURN_VALUES_METHODS_KEY, Integer.toString(this.enabledIgnoredMethods.size()));
        int i = 0;
        for (String string : this.enabledIgnoredMethods) {
            String value = this.ignoredMethods.get(string);
            if (value == null) continue;
            properties.setProperty(IGNORED_RETURN_VALUES_METHODS_NAME_PREFIX + i, string);
            properties.setProperty(IGNORED_RETURN_VALUES_METHODS_VALUE_PREFIX + i, value);
            ++i;
        }
        properties.setProperty(RETURN_VALUES_METHODS_KEY, Integer.toString(this.ignoredMethods.size()));
        i = 0;
        for (Map.Entry entry : this.ignoredMethods.entrySet()) {
            properties.setProperty(RETURN_VALUES_METHODS_NAME_PREFIX + i, (String)entry.getKey());
            properties.setProperty(RETURN_VALUES_METHODS_VALUE_PREFIX + i, (String)entry.getValue());
            ++i;
        }
    }

    public static void clearProperties(JvmDebugger.SwingDebugger context) {
        Properties properties = context.getProperties();
        properties.remove(RETURN_VALUES_ENABLED_KEY);
        properties.remove(IGNORE_RETURN_VALUES_STORED_IN_LOCALS_KEY);
        properties.remove(IGNORE_RETURN_VALUES_USED_AS_PARAMETERS_KEY);
        properties.remove(IGNORE_RETURN_VALUES_USED_AS_RECEIVER_KEY);
        properties.remove(RETURN_VALUES_METHODS_KEY);
        properties.remove(IGNORED_RETURN_VALUES_METHODS_KEY);
    }

    public static boolean showReturnValues(JvmDebugger.SwingDebugger context) {
        return Boolean.parseBoolean(context.getProperties().getProperty(RETURN_VALUES_ENABLED_KEY, "true"));
    }

    public static void setShowReturnValues(JvmDebugger.SwingDebugger context, boolean showReturnValues) {
        context.getProperties().setProperty(RETURN_VALUES_ENABLED_KEY, Boolean.toString(showReturnValues));
    }

    public static boolean ignoreReturnValuesStoredInLocals(JvmDebugger.SwingDebugger context) {
        return Boolean.parseBoolean(context.getProperties().getProperty(IGNORE_RETURN_VALUES_STORED_IN_LOCALS_KEY, "false"));
    }

    public static boolean ignoreReturnValuesUsedAsParameters(JvmDebugger.SwingDebugger context) {
        return Boolean.parseBoolean(context.getProperties().getProperty(IGNORE_RETURN_VALUES_USED_AS_PARAMETERS_KEY, "false"));
    }

    public static boolean ignoreReturnValuesUsedAsReceivers(JvmDebugger.SwingDebugger context) {
        return Boolean.parseBoolean(context.getProperties().getProperty(IGNORE_RETURN_VALUES_USED_AS_RECEIVER_KEY, "false"));
    }

    public static String[] ignoredMethods(JvmDebugger.SwingDebugger context) {
        Properties properties = context.getProperties();
        String methodsString = properties.getProperty(RETURN_VALUES_METHODS_KEY, "0");
        int methods = 0;
        try {
            methods = Integer.parseInt(methodsString);
        }
        catch (NumberFormatException e) {
            Trace.warn((Throwable)e, (String)"Error while parsing the number of ignored return value methods");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < methods; ++i) {
            String value = properties.getProperty(RETURN_VALUES_METHODS_VALUE_PREFIX + i);
            if (value == null) continue;
            result.add(value);
        }
        return result.toArray(new String[result.size()]);
    }

    private final class IgnoredMethodModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 7158071291665723867L;

        private IgnoredMethodModel() {
        }

        @Override
        public int getRowCount() {
            return ReturnValueConfigurationDialog.this.ignoredMethodOrder.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String key = (String)ReturnValueConfigurationDialog.this.ignoredMethodOrder.get(rowIndex);
            if (columnIndex == 0) {
                return ReturnValueConfigurationDialog.this.enabledIgnoredMethods.contains(key);
            }
            return key;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 0) {
                return;
            }
            String key = (String)ReturnValueConfigurationDialog.this.ignoredMethodOrder.get(rowIndex);
            boolean isSelected = (Boolean)aValue;
            if (isSelected) {
                ReturnValueConfigurationDialog.this.enabledIgnoredMethods.add(key);
            } else {
                ReturnValueConfigurationDialog.this.enabledIgnoredMethods.remove(key);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }
    }
}

