/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.tracing.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public final class RunningJvmDialog {
    private static final String HIDE_ON_ESCAPE = "hide-on-escape";
    private static final String LOCALHOST = "localhost";
    private static final String HOST_COUNT_KEY = "hosts";
    private static final String HOST_PREFIX = "host_";
    private static final int JVMMOND_PORT = 1099;
    private final JButton okButton;
    private final JButton cancelButton;
    private final JButton refreshButton;
    private final JTable table;
    private final JLabel hostLabel;
    private final JComboBox<String> hostComboBox;
    private final String hostComboBoxCommand;
    private final Set<String> hostEntries = new HashSet<String>();
    private final JTable detailsTable;
    private final JDialog dialog;
    private final JvmDebugger.SwingDebugger context;
    private String host = null;
    private int port = 0;
    private int pid = 0;
    private int instanceId = -1;
    private int vmIndex = 0;
    private String lastSelectedHost = "localhost";
    private boolean supportsFileSockets = false;

    public RunningJvmDialog(JFrame frame, JvmDebugger.SwingDebugger context) {
        this.context = context;
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningJvmDialog.this.dialogButtonsPressed(e);
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningJvmDialog.this.dialogButtonsPressed(e);
            }
        });
        this.detailsTable = new JTable();
        this.detailsTable.setRowSelectionAllowed(false);
        this.detailsTable.setColumnSelectionAllowed(false);
        this.detailsTable.setCellSelectionEnabled(false);
        this.detailsTable.setDefaultRenderer(DetailTableModel.COLUMN_CLASSES[0], new DetailHeaderRenderer());
        this.detailsTable.setDefaultRenderer(DetailTableModel.COLUMN_CLASSES[1], new DetailContentRenderer());
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(JvmTableModel.COLUMN_CLASSES[0], new JvmNameRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RunningJvmDialog.this.okButton.setEnabled(RunningJvmDialog.this.table.getSelectedRow() >= 0);
                DetailTableModel details = (DetailTableModel)RunningJvmDialog.this.detailsTable.getModel();
                details.rowSelected(RunningJvmDialog.this.table.getSelectedRow());
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && RunningJvmDialog.this.okButton.isEnabled()) {
                    RunningJvmDialog.this.dialogButtonsPressed(new ActionEvent(RunningJvmDialog.this.okButton, 1001, null));
                }
            }
        });
        String command = "jvmTableEnterCommand";
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), command);
        this.table.getActionMap().put(command, new AbstractAction(){
            private static final long serialVersionUID = -6807423965890732813L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RunningJvmDialog.this.okButton.isEnabled()) {
                    RunningJvmDialog.this.okButton.doClick();
                }
            }
        });
        this.hostLabel = new JLabel("Hosts:");
        this.hostComboBox = new JComboBox();
        this.hostComboBox.addItem(LOCALHOST);
        this.hostEntries.add(LOCALHOST);
        RunningJvmDialog.loadProperties(context == null ? null : context.getProperties(), this.hostComboBox, this.hostEntries);
        this.hostComboBox.setEditable(true);
        this.hostComboBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.hostComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitoringController controller;
                if (!RunningJvmDialog.this.hostComboBoxCommand.equals(e.getActionCommand())) {
                    return;
                }
                String value = RunningJvmDialog.this.hostComboBox.getSelectedItem().toString();
                if (value.equals(RunningJvmDialog.this.lastSelectedHost)) {
                    RunningJvmDialog.this.refresh();
                    return;
                }
                RunningJvmDialog.this.lastSelectedHost = value;
                if (!RunningJvmDialog.this.hostEntries.contains(value)) {
                    RunningJvmDialog.this.hostComboBox.addItem(value);
                    RunningJvmDialog.this.hostEntries.add(value);
                }
                try {
                    if (RunningJvmDialog.LOCALHOST.equals(value)) {
                        controller = new MonitoringController();
                        RunningJvmDialog.this.dialog.setTitle("SAP JVMs running locally");
                    } else {
                        int index = value.indexOf(58);
                        String remoteHost = value;
                        int remotePort = 1099;
                        if (index >= 0) {
                            remoteHost = value.substring(0, index);
                            remotePort = Integer.parseInt(value.substring(index + 1));
                        }
                        controller = new MonitoringController(remoteHost, remotePort, null, true);
                        RunningJvmDialog.this.dialog.setTitle("SAP JVMs running on " + remoteHost);
                    }
                }
                catch (IOException ioe) {
                    Trace.get(this.getClass()).error((Throwable)ioe);
                    return;
                }
                RunningJvmDialog.this.updateTable(controller);
            }
        });
        this.hostComboBoxCommand = this.hostComboBox.getActionCommand();
        this.refreshButton = new JButton(ImageRepository.getImage("resources/refresh.gif", "Refresh"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningJvmDialog.this.refresh();
            }
        });
        this.dialog = new JDialog(frame, "SAP JVMs running locally", true);
    }

    public boolean show() {
        try {
            this.updateTable(new MonitoringController());
        }
        catch (IOException ioe) {
            Trace.get(this.getClass()).error((Throwable)ioe);
            return false;
        }
        JScrollPane jvmScrollPane = new JScrollPane(this.table);
        Dimension preferredSize = this.table.getPreferredSize();
        Dimension size = this.table.getMinimumSize();
        Dimension header = this.table.getTableHeader().getMinimumSize();
        size.height += 2 * header.height;
        size.width = Math.max(preferredSize.width, header.width) + 300;
        jvmScrollPane.setPreferredSize(size);
        JPanel jvmPane = new JPanel(new BorderLayout(5, 5));
        jvmPane.add((Component)jvmScrollPane, "Center");
        jvmPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane detailScrollPane = new JScrollPane(this.detailsTable);
        detailScrollPane.setPreferredSize(size);
        JPanel detailPane = new JPanel(new BorderLayout(5, 5));
        detailPane.add((Component)detailScrollPane, "Center");
        detailPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JSplitPane mainPane = new JSplitPane(0, jvmPane, detailPane);
        mainPane.setResizeWeight(0.5);
        JPanel hostPanel = new JPanel(new FlowLayout(0));
        hostPanel.add(this.hostLabel);
        hostPanel.add(this.hostComboBox);
        hostPanel.add(this.refreshButton);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        this.dialog.getContentPane().add((Component)hostPanel, "First");
        this.dialog.getContentPane().add((Component)mainPane, "Center");
        this.dialog.getContentPane().add((Component)buttons, "Last");
        this.dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), HIDE_ON_ESCAPE);
        this.dialog.getRootPane().getActionMap().put(HIDE_ON_ESCAPE, new AbstractAction(){
            private static final long serialVersionUID = 9022639465723410371L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningJvmDialog.this.dialogButtonsPressed(e);
            }
        });
        this.dialog.pack();
        this.dialog.setSize(2 * this.dialog.getWidth(), 2 * this.dialog.getHeight());
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.table.requestFocusInWindow();
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.pid != 0;
    }

    public String getSelectedHost() {
        return this.host;
    }

    public int getSelectedPort() {
        return this.port;
    }

    public int getSelectedProcessId() {
        return this.pid;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public int getVmIndex() {
        return this.vmIndex;
    }

    public boolean supportsFileSockets() {
        return this.supportsFileSockets;
    }

    private void dialogButtonsPressed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.lastSelectedHost == LOCALHOST) {
                assert (this.host == null && this.port == 0);
            } else {
                int index = this.lastSelectedHost.indexOf(58);
                this.host = index < 0 ? this.lastSelectedHost : this.lastSelectedHost.substring(0, index);
                this.port = index < 0 ? 1099 : Integer.parseInt(this.lastSelectedHost.substring(index + 1));
            }
            this.pid = (Integer)this.table.getValueAt(this.table.getSelectedRow(), 1);
            this.instanceId = (Integer)this.table.getModel().getValueAt(this.table.getSelectedRow(), 2);
            this.vmIndex = (Integer)this.table.getModel().getValueAt(this.table.getSelectedRow(), 3);
            this.supportsFileSockets = (Boolean)this.table.getModel().getValueAt(this.table.getSelectedRow(), 4);
        } else {
            assert (e.getSource() == this.cancelButton || e.getSource() == this.dialog.getRootPane());
            assert (this.host == null && this.port == 0 && this.pid == 0 && this.instanceId == -1 && this.vmIndex == 0 && !this.supportsFileSockets);
        }
        this.dialog.setVisible(false);
        RunningJvmDialog.updateProperties(this.context, this.hostComboBox);
    }

    private void refresh() {
        JvmTableModel model = (JvmTableModel)this.table.getModel();
        model.refresh();
        this.selectFirstRowIfAvailable();
    }

    private void updateTable(MonitoringController controller) {
        JvmTableModel jvmTableModel = new JvmTableModel(controller);
        if (!controller.isConnected()) {
            JOptionPane.showMessageDialog(this.dialog, "The connection to host '" + controller.getHost() + "' (port " + controller.getPort() + ") failed. Please start jvmmond on the host to see the JVM instances running there.", "No jvmmond found", 1);
        }
        this.detailsTable.setModel(new DetailTableModel(jvmTableModel));
        this.detailsTable.setTableHeader(null);
        this.detailsTable.getColumnModel().getColumn(0).setMinWidth(130);
        this.detailsTable.getColumnModel().getColumn(0).setMaxWidth(200);
        this.table.setModel(jvmTableModel);
        this.table.getColumnModel().getColumn(1).setMinWidth(10);
        this.table.getColumnModel().getColumn(1).setMaxWidth(100);
        this.table.removeColumn(this.table.getColumnModel().getColumn(4));
        this.table.removeColumn(this.table.getColumnModel().getColumn(3));
        this.table.removeColumn(this.table.getColumnModel().getColumn(2));
        this.selectFirstRowIfAvailable();
    }

    private void selectFirstRowIfAvailable() {
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public static void main(String[] args) {
        new RunningJvmDialog(null, null).show();
    }

    private static void loadProperties(Properties properties, JComboBox<String> hosts, Set<String> entries) {
        if (properties == null) {
            return;
        }
        int count = Integer.parseInt(properties.getProperty(HOST_COUNT_KEY, "0"));
        for (int i = 0; i < count; ++i) {
            String h = properties.getProperty(HOST_PREFIX + i);
            if (h == null || entries.contains(h)) continue;
            hosts.addItem(h);
            entries.add(h);
        }
    }

    private static void updateProperties(JvmDebugger.SwingDebugger context, JComboBox<String> hosts) {
        int i;
        if (context == null) {
            return;
        }
        Properties properties = context.getProperties();
        int oldCount = Integer.parseInt(properties.getProperty(HOST_COUNT_KEY, "0"));
        int newCount = hosts == null ? 0 : hosts.getItemCount();
        properties.setProperty(HOST_COUNT_KEY, Integer.toString(newCount));
        for (i = newCount; i < oldCount; ++i) {
            properties.remove(HOST_PREFIX + i);
        }
        for (i = 0; i < newCount; ++i) {
            properties.setProperty(HOST_PREFIX + i, hosts.getItemAt(i));
        }
    }

    public static void clearProperties(JvmDebugger.SwingDebugger context) {
        RunningJvmDialog.updateProperties(context, null);
    }

    public static void propertiesChanged(JvmDebugger.SwingDebugger context, Properties before) {
        HashSet<String> entries = new HashSet<String>();
        JComboBox<String> dummy = new JComboBox<String>();
        RunningJvmDialog.loadProperties(before, dummy, entries);
        RunningJvmDialog.loadProperties(context.getProperties(), dummy, entries);
        RunningJvmDialog.updateProperties(context, dummy);
    }

    private static class DetailContentRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5883808652734805792L;

        private DetailContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setToolTipText(value.toString());
            return result;
        }
    }

    private static class DetailHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8134039808368922760L;

        private DetailHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ImageIcon icon = null;
            DetailTableModel model = (DetailTableModel)table.getModel();
            MonitoredVm vm = model.getCurrentVm();
            if (vm == null) {
                return result;
            }
            if (row == 0) {
                icon = JvmNameRenderer.getStateIcon(vm.getBoard());
            } else if (row == 1) {
                icon = ImageRepository.getImage("resources/default_config.gif", "Version");
            } else if (row == 2) {
                icon = ImageRepository.getImage("resources/dir.gif", "Directory");
            } else if (row == 3) {
                icon = ImageRepository.getImage("resources/java_args.gif", "Java Arguments");
            } else if (row == 3 + model.getNrOfJavaArguments(vm.getBoard())) {
                icon = ImageRepository.getImage("resources/vm_args.gif", "VM Arguments");
            }
            result.setIcon(icon);
            return result;
        }
    }

    private static class DetailTableModel
    implements TableModel {
        private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Object.class};
        private static final String[] COLUMN_NAMES = new String[]{"Header", "Content"};
        private static final int HEADER_COLUMN = 0;
        private static final int CONTENT_COLUMN = 1;
        private final List<TableModelListener> listeners = Collections.synchronizedList(new ArrayList());
        private final JvmTableModel model;
        private int selectedRowIndex = -1;
        private int nrOfJavaArguments = -1;
        private int nrOfJvmArguments = -1;

        private DetailTableModel(JvmTableModel model) {
            this.model = model;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_CLASSES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public int getRowCount() {
            MonitoredVm vm = this.getCurrentVm();
            if (vm == null) {
                return 0;
            }
            int javaRows = this.getNrOfJavaArguments(vm.getBoard());
            int jvmRows = this.getNrOfJvmArguments(vm.getBoard());
            return 3 + javaRows + jvmRows;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MonitoredVm vm = this.getCurrentVm();
            if (vm == null) {
                return "";
            }
            BoardWrapper board = vm.getBoard();
            if (columnIndex == 0) {
                switch (rowIndex) {
                    case 0: {
                        return "VM State";
                    }
                    case 1: {
                        return "Version";
                    }
                    case 2: {
                        return "Working Directory";
                    }
                    case 3: {
                        return "Java Arguments";
                    }
                }
                if (rowIndex == 3 + this.getNrOfJavaArguments(board)) {
                    return "VM Arguments";
                }
                return "";
            }
            if (columnIndex == 1) {
                switch (rowIndex) {
                    case 0: {
                        return this.getDebuggingString(board);
                    }
                    case 1: {
                        return board.getString("VM_VERSION_STRING", "<unknown>");
                    }
                    case 2: {
                        return board.getString("WORKINGDIR", "<unknown>");
                    }
                }
                int argIndex = rowIndex - 3;
                if (argIndex < this.getNrOfJavaArguments(board)) {
                    return board.getString("JAVA_ARGUMENT" + argIndex, "<unknown>");
                }
                return board.getString("JVM_ARGUMENT" + (argIndex - this.getNrOfJavaArguments(board)), "<unknown>");
            }
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " out of range [0.." + (COLUMN_CLASSES.length - 1));
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        private void rowSelected(int row) {
            if (row != this.selectedRowIndex) {
                this.selectedRowIndex = row;
                this.nrOfJavaArguments = -1;
                this.nrOfJvmArguments = -1;
                TableModelEvent event = new TableModelEvent(this);
                for (TableModelListener l : this.listeners.toArray(new TableModelListener[0])) {
                    l.tableChanged(event);
                }
            }
        }

        private int getNrOfJavaArguments(BoardWrapper vm) {
            if (this.nrOfJavaArguments >= 0) {
                return this.nrOfJavaArguments;
            }
            this.nrOfJavaArguments = DetailTableModel.getNrOfArguments("JAVA_ARGUMENT", vm);
            return this.nrOfJavaArguments;
        }

        private int getNrOfJvmArguments(BoardWrapper vm) {
            if (this.nrOfJvmArguments >= 0) {
                return this.nrOfJvmArguments;
            }
            this.nrOfJvmArguments = DetailTableModel.getNrOfArguments("JVM_ARGUMENT", vm);
            return this.nrOfJvmArguments;
        }

        private static int getNrOfArguments(String name, BoardWrapper vm) {
            int i = 0;
            while (true) {
                if (vm.getAttribute(name + i) == null) {
                    int result = Math.max(1, i);
                    return result;
                }
                ++i;
            }
        }

        private MonitoredVm getCurrentVm() {
            if (this.selectedRowIndex < 0) {
                return null;
            }
            MonitoredVm[] vms = this.model.data;
            if (this.selectedRowIndex >= vms.length) {
                return null;
            }
            return vms[this.selectedRowIndex];
        }

        private String getDebuggingString(BoardWrapper vm) {
            short mode = vm.getShort("DEBUGGING_MODE", (short)-1);
            boolean onDemand = vm.getBoolean("DEBUGGING_ON_DEMAND_ENABLED", true);
            String client = vm.getString("DEBUGGING_CLIENT", "");
            if (mode == 0) {
                if (onDemand) {
                    return "VM is running";
                }
                return "Debugging not supported (maybe another JVMTI agent is running)";
            }
            if (mode > 0) {
                if ("".equals(client)) {
                    int port = vm.getInt("DEBUGGING_PORT", -1);
                    return "Waiting for debugger on port [" + port + "]";
                }
                String debugger = vm.getString("DEBUGGING_CLIENT", "<unknown>");
                return "A debugger is attached to the VM from " + debugger;
            }
            return "unknown";
        }
    }

    private static class JvmNameRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5988457877786217154L;

        private JvmNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JvmTableModel model = (JvmTableModel)table.getModel();
            MonitoredVm vm = model.data[row];
            result.setIcon(JvmNameRenderer.getStateIcon(vm.getBoard()));
            return result;
        }

        private static ImageIcon getStateIcon(BoardWrapper vm) {
            short mode = vm.getShort("DEBUGGING_MODE", (short)-1);
            boolean onDemand = vm.getBoolean("DEBUGGING_ON_DEMAND_ENABLED", true);
            String client = vm.getString("DEBUGGING_CLIENT", "");
            ImageIcon overlay = null;
            if (mode == 0 && !onDemand) {
                overlay = ImageRepository.getImage("resources/dec_warning.gif", "warning decorator");
            } else if (mode > 0) {
                overlay = "".equals(client) ? ImageRepository.getImage("resources/dec_warning.gif", "warning decorator") : (onDemand ? ImageRepository.getImage("resources/dec_debug.gif", "debug decorator") : ImageRepository.getImage("resources/dec_canceled.gif", "canceled decorator"));
            }
            int sapSystem = vm.getInt("SAP_SYSTEM", -1);
            ImageIcon icon = sapSystem >= 0 ? ImageRepository.getImage("resources/cluster.gif", "Cluster") : ImageRepository.getImage("resources/vm.gif", "JVM");
            if (overlay != null) {
                icon = ImageRepository.createIconWithOverlay(icon, null, overlay, null, null);
            }
            return icon;
        }
    }

    private static class JvmTableModel
    implements TableModel {
        private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Integer.class, Integer.class, Integer.class, Boolean.class};
        private static final String[] COLUMN_NAMES = new String[]{"VM", "Process ID", "Instance ID", "VM Index", "File Socket Support"};
        private static final int JVM_COLUMN = 0;
        private static final int PID_COLUMN = 1;
        private static final int CLUSTER_COLUMN = 2;
        private static final int VM_INDEX_COLUMN = 3;
        private static final int FILE_SOCKET_SUPPORT_COLUMN = 4;
        private final List<TableModelListener> listeners = Collections.synchronizedList(new ArrayList());
        private final MonitoringController controller;
        private MonitoredVm[] data;

        public JvmTableModel(MonitoringController controller) {
            this.controller = controller;
            this.data = controller.getAllMonitoredVms(true);
        }

        public void refresh() {
            this.data = this.controller.getAllMonitoredVms(true);
            TableModelEvent event = new TableModelEvent(this);
            for (TableModelListener l : this.listeners.toArray(new TableModelListener[0])) {
                l.tableChanged(event);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_CLASSES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            BoardWrapper vm = this.data[rowIndex].getBoard();
            if (columnIndex == 0) {
                return this.getVmName(vm);
            }
            if (columnIndex == 1) {
                return vm.getPid();
            }
            if (columnIndex == 2) {
                return vm.getInt("SAP_SYSTEM", -1);
            }
            if (columnIndex == 3) {
                return vm.getInt("JVM_INDEX", 0);
            }
            if (columnIndex == 4) {
                return vm.getBoolean("DEBUGGING_ON_DEMAND_VIA_PROFILING_SERVER_ENABLED", false);
            }
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " out of range [0.." + (COLUMN_CLASSES.length - 1));
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        private String getVmName(BoardWrapper vm) {
            String result = vm.getString("JAVA_MAINCLASS", "<unknown>");
            if (!"".equals(result)) {
                return result;
            }
            String classpath = vm.getString("JAVA_CLASS_PATH", "");
            if (classpath.matches(".*org[.]eclipse[.]equinox[.]launcher_([0-9.]*.*)")) {
                String workspace = vm.getString("ECLIPSE_WORKSPACE", "");
                if ("".equals(workspace)) {
                    return "Equinox";
                }
                return "Eclipse [" + workspace + "]";
            }
            return vm.getString("EXECUTABLE", "<unknown>");
        }
    }
}

