/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.dialog;

import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public final class SourcePathMaintenanceDialog
implements ActionListener {
    private static final String HIDE_ON_ESCAPE = "hide-on-escape";
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton;
    private final JButton removeButton;
    private final JButton removeAllButton;
    private final JButton upButton;
    private final JButton downButton;
    private final JDialog dialog;
    private final JTabbedPane tabbedPane;
    private final SourceConfiguration[] configs;
    private final List<SourceListModel<String>> models;
    private final List<JList<String>> lists;
    private final JButton[] toolbarButtons;
    private final JButton[] additionalButtons;

    public SourcePathMaintenanceDialog(JFrame frame, SourceConfiguration[] configs, final SourceCodeProperties sourceProperties, JButton ... additionalButtons) {
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.removeButton = new JButton(ImageRepository.getImage("resources/remove_grey.gif", "Remove Config"));
        this.removeButton.setToolTipText("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.removeAllButton = new JButton(ImageRepository.getImage("resources/remove_grey_all.gif", "Remove All Configs"));
        this.removeAllButton.setToolTipText("Remove All");
        this.removeAllButton.addActionListener(this);
        this.removeAllButton.setEnabled(false);
        this.upButton = new JButton(ImageRepository.getImage("resources/arrow_up.gif", "Move Config Up"));
        this.upButton.setToolTipText("Move Up");
        this.upButton.addActionListener(this);
        this.upButton.setEnabled(false);
        this.downButton = new JButton(ImageRepository.getImage("resources/arrow_down.gif", "Move Config Down"));
        this.downButton.setToolTipText("Move Down");
        this.downButton.addActionListener(this);
        this.downButton.setEnabled(false);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = SourcePathMaintenanceDialog.this.tabbedPane.getSelectedIndex();
                if (index >= 0) {
                    SourcePathMaintenanceDialog.this.enableContextSensitiveButtons(((JList)SourcePathMaintenanceDialog.this.lists.get(index)).getModel().getSize(), ((JList)SourcePathMaintenanceDialog.this.lists.get(index)).getSelectedIndex());
                }
            }
        });
        this.dialog = new JDialog(frame, "Source Code Lookup", true);
        this.configs = configs;
        this.models = new ArrayList<SourceListModel<String>>(configs.length);
        this.lists = new ArrayList<JList<String>>(configs.length);
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        for (int i = 0; i < configs.length; ++i) {
            final SourceConfiguration sc = configs[i];
            final SourceListModel m = new SourceListModel(sc.entries);
            this.models.add(m);
            if (sc.allowAdd) {
                JButton b = new JButton(sc.addIcon);
                b.setToolTipText(sc.tooltip);
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!sc.allowAdd) {
                            return;
                        }
                        JFileChooser chooser = new JFileChooser(sourceProperties.getLastUsedDirectory());
                        chooser.setMultiSelectionEnabled(true);
                        if (sc.filter != null) {
                            chooser.setFileFilter(sc.filter);
                        }
                        chooser.setFileSelectionMode(sc.fileSelectionMode);
                        int result = chooser.showOpenDialog(SourcePathMaintenanceDialog.this.dialog);
                        if (result == 0) {
                            for (File f : chooser.getSelectedFiles()) {
                                m.add(f.getPath());
                            }
                        }
                        sourceProperties.setLastUsedDirectory(chooser.getCurrentDirectory().toString());
                    }
                });
                buttons.add(b);
            }
            final JList l = new JList(m);
            this.lists.add(l);
            l.setSelectionMode(0);
            l.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SourcePathMaintenanceDialog.this.enableContextSensitiveButtons(l.getModel().getSize(), l.getSelectedIndex());
                }
            });
            l.getModel().addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    SourcePathMaintenanceDialog.this.enableContextSensitiveButtons(l.getModel().getSize(), l.getSelectedIndex());
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    SourcePathMaintenanceDialog.this.enableContextSensitiveButtons(l.getModel().getSize(), l.getSelectedIndex());
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    SourcePathMaintenanceDialog.this.enableContextSensitiveButtons(l.getModel().getSize(), l.getSelectedIndex());
                }
            });
            l.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 3186280009485463925L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setIcon(sc.addIcon);
                    return this;
                }
            });
            this.tabbedPane.addTab(configs[i].title, new JScrollPane(l));
        }
        this.toolbarButtons = buttons.toArray(new JButton[buttons.size()]);
        this.additionalButtons = (JButton[])additionalButtons.clone();
    }

    public void show() {
        JPanel bar = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        bar.add((Component)toolBar, "Center");
        for (JButton button : this.toolbarButtons) {
            toolBar.add(button);
        }
        toolBar.addSeparator();
        toolBar.add(this.removeButton);
        toolBar.add(this.removeAllButton);
        toolBar.addSeparator();
        toolBar.add(this.upButton);
        toolBar.add(this.downButton);
        toolBar.addSeparator();
        for (JButton button : this.additionalButtons) {
            toolBar.add(button);
        }
        JPanel buttons = new JPanel(new FlowLayout(2));
        JPanel main = new JPanel(new BorderLayout(5, 5));
        main.add((Component)this.tabbedPane, "Center");
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        this.dialog.getContentPane().add((Component)bar, "First");
        this.dialog.getContentPane().add((Component)main, "Center");
        this.dialog.getContentPane().add((Component)buttons, "Last");
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), HIDE_ON_ESCAPE);
        this.dialog.getRootPane().getActionMap().put(HIDE_ON_ESCAPE, new AbstractAction(){
            private static final long serialVersionUID = -3259947008762671494L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcePathMaintenanceDialog.this.actionPerformed(e);
            }
        });
        this.dialog.setSize(600, 400);
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
        this.dialog.dispose();
    }

    public void add(int index, String value) {
        this.models.get(index).add(value);
    }

    public String[] getEntries(int index) {
        return ((SourceListModel)this.models.get(index)).entries.toArray(new String[((SourceListModel)this.models.get(index)).entries.size()]);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.removeButton) {
            int selectedIndex;
            int index = this.tabbedPane.getSelectedIndex();
            if (index >= 0 && (selectedIndex = this.lists.get(index).getSelectedIndex()) >= 0) {
                this.models.get(index).remove(selectedIndex);
            }
            return;
        }
        if (e.getSource() == this.removeAllButton) {
            int index = this.tabbedPane.getSelectedIndex();
            if (index >= 0) {
                this.models.get(index).removeAll();
            }
            return;
        }
        if (e.getSource() == this.upButton || e.getSource() == this.downButton) {
            int selectedIndex;
            int index = this.tabbedPane.getSelectedIndex();
            if (index >= 0 && (selectedIndex = this.lists.get(index).getSelectedIndex()) >= 0) {
                int offset;
                int n = offset = e.getSource() == this.upButton ? -1 : 1;
                if (this.models.get(index).swap(selectedIndex, selectedIndex + offset)) {
                    this.lists.get(index).setSelectedIndex(selectedIndex + offset);
                }
            }
            return;
        }
        if (e.getSource() == this.okButton) {
            for (SourceConfiguration sc : this.configs) {
                sc.commitChanges();
            }
        } else assert (e.getSource() == this.cancelButton || e.getSource() == this.dialog.getRootPane());
        this.dialog.setVisible(false);
    }

    private void enableContextSensitiveButtons(int size, int selection) {
        this.removeButton.setEnabled(selection >= 0);
        this.removeAllButton.setEnabled(size > 0);
        this.upButton.setEnabled(selection >= 1);
        this.downButton.setEnabled(selection >= 0 && selection < size - 1);
    }

    private static class SourceListModel<T>
    extends AbstractListModel<T> {
        private static final long serialVersionUID = 6981932125285918021L;
        private final List<T> entries;

        private SourceListModel(List<T> entries) {
            this.entries = entries;
        }

        @Override
        public T getElementAt(int index) {
            return this.entries.get(index);
        }

        @Override
        public int getSize() {
            return this.entries.size();
        }

        public void add(T e) {
            this.entries.add(e);
            this.fireIntervalAdded(this, this.entries.size() - 1, this.entries.size() - 1);
        }

        public void remove(int index) {
            this.entries.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        public void removeAll() {
            int size = this.entries.size();
            this.entries.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        public boolean swap(int index1, int index2) {
            int higher;
            int lower;
            if (index1 < 0 || index1 >= this.entries.size() || index2 < 0 || index2 >= this.entries.size()) {
                return false;
            }
            T value1 = this.entries.get(index1);
            this.entries.set(index1, this.entries.get(index2));
            this.entries.set(index2, value1);
            if (index1 < index2) {
                lower = index1;
                higher = index2;
            } else {
                lower = index2;
                higher = index1;
            }
            this.fireContentsChanged(this, lower, higher);
            return true;
        }
    }

    public static class SourceConfiguration {
        private final String title;
        private final String tooltip;
        private final boolean allowAdd;
        private final Icon addIcon;
        private final FileFilter filter;
        private final int fileSelectionMode;
        private final List<String> entries;
        private final List<String> initialEntries;

        public SourceConfiguration(String title, String tooltip, boolean allowAdd, Icon addIcon, FileFilter filter, int fileSelectionMode, List<String> entries) {
            this.title = title;
            this.tooltip = tooltip;
            this.allowAdd = allowAdd;
            this.addIcon = addIcon;
            this.filter = filter;
            this.fileSelectionMode = fileSelectionMode;
            this.initialEntries = entries;
            this.entries = new ArrayList<String>(entries);
        }

        private void commitChanges() {
            this.initialEntries.clear();
            this.initialEntries.addAll(this.entries);
        }
    }
}

