/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.icons;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class ImageRepository {
    public static ImageIcon getImage(String key, String description) {
        return new ImageIcon(ImageRepository.getImageUrl(key), description);
    }

    public static URL getImageUrl(String key) {
        return ImageRepository.class.getResource(key);
    }

    public static ImageIcon createIconWithOverlay(ImageIcon baseIcon, ImageIcon topLeft, ImageIcon topRight, ImageIcon bottomLeft, ImageIcon bottomRight) {
        int offset;
        BufferedImage buffer = new BufferedImage(baseIcon.getIconWidth(), baseIcon.getIconHeight(), 2);
        Graphics2D graphics = buffer.createGraphics();
        graphics.drawImage(baseIcon.getImage(), 0, 0, null);
        if (topLeft != null) {
            graphics.drawImage(topLeft.getImage(), 0, 0, null);
        }
        if (topRight != null) {
            offset = baseIcon.getIconWidth() - topRight.getIconWidth();
            graphics.drawImage(topRight.getImage(), offset, 0, null);
        }
        if (bottomLeft != null) {
            offset = baseIcon.getIconHeight() - bottomLeft.getIconHeight();
            graphics.drawImage(bottomLeft.getImage(), 0, offset, null);
        }
        if (bottomRight != null) {
            int offsetX = baseIcon.getIconWidth() - bottomRight.getIconWidth();
            int offsetY = baseIcon.getIconHeight() - bottomRight.getIconHeight();
            graphics.drawImage(bottomRight.getImage(), offsetX, offsetY, null);
        }
        graphics.dispose();
        return new ImageIcon(buffer);
    }
}

