/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public final class CancelableTextField
extends JTextField {
    private static final long serialVersionUID = -6935297157357070746L;
    private static final int BUTTON_SIZE = 14;
    private boolean isMouseOverButton = false;
    private boolean isMouseButtonPressed = false;
    private boolean isShowingOverlay = false;
    private final String overlayText;
    private String textCache;
    private Color colorCache;

    public CancelableTextField(int columns, String overlayText) {
        super(columns);
        this.overlayText = overlayText;
        this.setBorder(new CompoundBorder(this.getBorder(), new CancelButtonBorder()));
        MouseInputAdapter mouseListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkEvent(e, false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (CancelableTextField.this.isMouseOverButton) {
                    CancelableTextField.this.cancel();
                }
                this.checkEvent(e, true);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.checkEvent(e, false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.checkEvent(e, false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.checkEvent(e, true);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.checkEvent(e, false);
            }

            private void checkEvent(MouseEvent e, boolean forceReset) {
                Rectangle innerArea = SwingUtilities.calculateInnerArea(CancelableTextField.this, null);
                int buttonOffset = innerArea.width - 14;
                boolean wasOverButton = CancelableTextField.this.isMouseOverButton;
                CancelableTextField.this.isMouseOverButton = !forceReset && CancelableTextField.this.contains(e.getPoint()) && !innerArea.contains(e.getPoint()) && e.getPoint().x >= buttonOffset;
                CancelableTextField.this.isMouseButtonPressed = SwingUtilities.isLeftMouseButton(e);
                if (wasOverButton != CancelableTextField.this.isMouseOverButton) {
                    if (wasOverButton) {
                        CancelableTextField.this.setCursor(new Cursor(2));
                    } else {
                        CancelableTextField.this.setCursor(new Cursor(0));
                    }
                }
                CancelableTextField.this.repaint();
            }
        };
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.addFocusListener(new FocusListener(){
            {
                this.focusLost(null);
            }

            @Override
            public void focusLost(FocusEvent e) {
                CancelableTextField.this.textCache = CancelableTextField.this.getText();
                CancelableTextField.this.colorCache = CancelableTextField.this.getForeground();
                if (CancelableTextField.this.textCache == null || CancelableTextField.this.textCache.length() == 0) {
                    CancelableTextField.this.isShowingOverlay = true;
                    CancelableTextField.this.setForeground(Color.GRAY);
                    CancelableTextField.this.setText(CancelableTextField.this.overlayText);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                CancelableTextField.this.setForeground(CancelableTextField.this.colorCache);
                CancelableTextField.this.setText(CancelableTextField.this.textCache);
                CancelableTextField.this.isShowingOverlay = false;
            }
        });
    }

    public void cancel() {
        this.setText("");
        this.postActionEvent();
    }

    public String getRealText() {
        if (this.isShowingOverlay) {
            return this.textCache;
        }
        return this.getText();
    }

    private static final class CancelButtonBorder
    extends EmptyBorder {
        private static final long serialVersionUID = -4104768356882637746L;

        public CancelButtonBorder() {
            super(0, 0, 0, 15);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!(c instanceof CancelableTextField)) {
                return;
            }
            CancelableTextField textField = (CancelableTextField)c;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color buttonColor = textField.isMouseOverButton ? (textField.isMouseButtonPressed ? Color.DARK_GRAY : Color.GRAY) : Color.LIGHT_GRAY;
            int buttonDiameter = 14;
            int offsetX = x + width - buttonDiameter;
            int offsetY = y + (height - 1 - buttonDiameter) / 2;
            g2d.setColor(buttonColor);
            g2d.fillOval(offsetX, offsetY, buttonDiameter, buttonDiameter);
            int crossSize = buttonDiameter - 8;
            g2d.setColor(Color.WHITE);
            g2d.drawLine(offsetX += 4, offsetY += 4, offsetX + crossSize, offsetY + crossSize);
            g2d.drawLine(offsetX, offsetY + crossSize, offsetX + crossSize, offsetY);
        }
    }
}

