/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.DisassembledClassPacket;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByNamePacketImpl;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByThreadPacketImpl;
import com.sap.jvm.debugging.ui.swing.source.EditorType;
import java.util.HashMap;
import java.util.Map;

public final class DisassemblyManager {
    private final Map<String, DisassembledClassPacket> class2Packet = new HashMap<String, DisassembledClassPacket>();
    private final Map<String, DisassemblyLocation> pendingClass2Location = new HashMap<String, DisassemblyLocation>();
    private final boolean REQUEST_DISASSEMBLY = DisassemblyManager.getSystemProperty("com.sap.jvm.debugging.ui.support.disassembly", true);
    private final boolean REQUEST_DECOMPILATION = DisassemblyManager.getSystemProperty("com.sap.jvm.debugging.ui.support.decompilation", false);

    public int getLine(String className, String methodName, EditorType type, int bci) {
        DisassembledClassPacket packet = this.class2Packet.get(className);
        if (packet == null) {
            return -1;
        }
        switch (type) {
            case DISASSEMBLED_SOURCE: {
                return packet.getLineOfDisassemblyBci(methodName, bci);
            }
            case DECOMPILED_SOURCE: {
                return packet.getLineOfDecompiledCode(methodName, bci);
            }
        }
        throw new IllegalArgumentException("Incorrect editor type: " + (Object)((Object)type));
    }

    public DebuggingPacket requestDisassembly(String className, int bci, long threadId, int frameIndex, String methodName) {
        this.pendingClass2Location.put(className, new DisassemblyLocation(bci, methodName));
        if (methodName != null) {
            return new RequestDisassemblyByThreadPacketImpl(threadId, frameIndex, this.REQUEST_DISASSEMBLY, this.REQUEST_DECOMPILATION);
        }
        return new RequestDisassemblyByNamePacketImpl(className, 0L, this.REQUEST_DISASSEMBLY, this.REQUEST_DECOMPILATION);
    }

    public DisassemblyLocation handleDisassembly(DisassembledClassPacket packet) {
        this.class2Packet.put(packet.getClassName(), packet);
        return this.pendingClass2Location.get(packet.getClassName());
    }

    public void reset() {
        this.class2Packet.clear();
        this.pendingClass2Location.clear();
    }

    public String getContent(String className, EditorType type) {
        String[] lines;
        if (type != EditorType.DISASSEMBLED_SOURCE && type != EditorType.DECOMPILED_SOURCE) {
            throw new IllegalArgumentException("Incorrect editor type: " + (Object)((Object)type));
        }
        DisassembledClassPacket packet = this.class2Packet.get(className);
        if (packet == null) {
            return "Content for class '" + className + "' not found.";
        }
        if (type == EditorType.DISASSEMBLED_SOURCE) {
            lines = packet.getDisassembly();
        } else {
            assert (type == EditorType.DECOMPILED_SOURCE);
            lines = packet.getDecompiledCode();
        }
        StringBuilder text = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (String str : lines) {
            text.append(str);
            text.append(lineSeparator);
        }
        return text.toString();
    }

    public DisassembledClassPacket.MethodByteCodeIndex getMethodByteCodeIndex(String className, EditorType type, int line) {
        DisassembledClassPacket packet = this.class2Packet.get(className);
        if (packet == null) {
            return null;
        }
        if (type != EditorType.DISASSEMBLED_SOURCE && type != EditorType.DECOMPILED_SOURCE) {
            throw new IllegalArgumentException("Incorrect editor type: " + (Object)((Object)type));
        }
        if (type == EditorType.DISASSEMBLED_SOURCE) {
            return packet.getDisassemblyMethodByteCodeIndexOfLine(line);
        }
        assert (type == EditorType.DECOMPILED_SOURCE);
        return packet.getDecompiledCodeMethodByteCodeIndexOfLine(line);
    }

    public DisassembledClassPacket getPacket(String className) {
        return this.class2Packet.get(className);
    }

    private static boolean getSystemProperty(String property, boolean defaultValue) {
        return Boolean.parseBoolean(System.getProperty(property, Boolean.toString(defaultValue)));
    }

    public static final class DisassemblyLocation {
        private final int bci;
        private final String method;

        private DisassemblyLocation(int bci, String method) {
            this.bci = bci;
            this.method = method;
        }

        public int getByteCodeIndex() {
            return this.bci;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

