/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.tracing.Trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;

public final class LineNumberPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = -3563942338734929464L;
    private static final int PREFERRED_HEIGHT = 2146483647;
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private final JEditorPane pane;
    private final Color currentLineColor;
    private final ImageIcon enabledBreakpointIcon;
    private final ImageIcon disabledBreakpointIcon;
    private int lastHeight;
    private int lastDigits;
    private int lastLine;
    private int minDisplayedDigits;
    private Map<String, FontMetrics> fonts = new HashMap<String, FontMetrics>();
    private int[] lineBreakpoints = new int[0];
    private final Map<Integer, Boolean> breakpointStates = new HashMap<Integer, Boolean>();

    public LineNumberPanel(SourceCodeManager.SourceCodeManagerInternal internal, JEditorPane pane) {
        this.internal = internal;
        this.pane = pane;
        this.currentLineColor = Color.RED;
        this.setFont(pane.getFont());
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.lastDigits = 0;
        this.minDisplayedDigits = 3;
        this.enabledBreakpointIcon = ImageRepository.getImage("resources/breakpoint.gif", "enabled breakpoint");
        this.disabledBreakpointIcon = ImageRepository.getImage("resources/ignore_breakpoint.gif", "disabled breakpoint");
        this.setPreferredWidth();
        pane.getDocument().addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    public void update() {
        if (!this.internal.isCurrentEditor(this.pane)) {
            if (this.lastLine != -1) {
                this.repaint();
                this.lastLine = -1;
            }
            return;
        }
        Element root = this.pane.getDocument().getDefaultRootElement();
        int currentLine = this.internal.getCurrentLine(this.pane);
        if (currentLine > 0 && currentLine < root.getElementCount()) {
            int offset = root.getElement(currentLine - 1).getStartOffset();
            if (offset != this.lastLine) {
                this.repaint();
                this.lastLine = offset;
            }
        } else if (this.lastLine != -1) {
            this.repaint();
            this.lastLine = -1;
        }
    }

    public void updateBreakpoints(int[] breakpoints, boolean[] enablement) {
        assert (breakpoints.length == enablement.length);
        this.lineBreakpoints = (int[])breakpoints.clone();
        this.breakpointStates.clear();
        for (int i = 0; i < this.lineBreakpoints.length; ++i) {
            this.breakpointStates.put(breakpoints[i], enablement[i]);
        }
        Arrays.sort(this.lineBreakpoints);
        this.repaint();
    }

    private boolean isBreakpointEnabled(int line) {
        return this.breakpointStates.get(line) == Boolean.TRUE;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics metrics = this.pane.getFontMetrics(this.pane.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.pane.viewToModel(new Point(0, clip.y));
        int endOffset = this.pane.viewToModel(new Point(0, clip.y + clip.height));
        int breakpointIndex = 0;
        try {
            while (rowStartOffset <= endOffset) {
                g.setColor(this.isCurrentLine(rowStartOffset) ? this.currentLineColor : this.getForeground());
                int lineNumber = this.getTextLineNumber(rowStartOffset);
                String lineNumberString = lineNumber >= 0 ? String.valueOf(lineNumber) : "";
                int stringWidth = metrics.stringWidth(lineNumberString);
                int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                int y = this.getOffsetY(rowStartOffset, metrics);
                g.drawString(lineNumberString, x, y);
                while (breakpointIndex < this.lineBreakpoints.length && lineNumber > this.lineBreakpoints[breakpointIndex]) {
                    ++breakpointIndex;
                }
                while (breakpointIndex < this.lineBreakpoints.length && lineNumber == this.lineBreakpoints[breakpointIndex]) {
                    ++breakpointIndex;
                    ImageIcon breakpointIcon = this.isBreakpointEnabled(lineNumber) ? this.enabledBreakpointIcon : this.disabledBreakpointIcon;
                    int yOffset = y - breakpointIcon.getIconHeight() + 4;
                    g.drawImage(breakpointIcon.getImage(), 0, yOffset, null);
                }
                rowStartOffset = Utilities.getRowEnd(this.pane, rowStartOffset) + 1;
            }
        }
        catch (BadLocationException e) {
            Trace.warn((Throwable)e, (String)"Bad location");
        }
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int height = ((LineNumberPanel)LineNumberPanel.this).pane.getPreferredSize().height;
                if (height != LineNumberPanel.this.lastHeight) {
                    LineNumberPanel.this.setPreferredWidth();
                    LineNumberPanel.this.repaint();
                    LineNumberPanel.this.lastHeight = height;
                }
            }
        });
    }

    private void setPreferredWidth() {
        Element root = this.pane.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), this.minDisplayedDigits);
        if (digits != this.lastDigits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width + Math.max(this.enabledBreakpointIcon.getIconWidth(), this.disabledBreakpointIcon.getIconWidth());
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, 2146483647);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    private boolean isCurrentLine(int offset) {
        if (!this.internal.isCurrentEditor(this.pane)) {
            return false;
        }
        Element root = this.pane.getDocument().getDefaultRootElement();
        int currentLine = this.internal.getCurrentLine(this.pane);
        if (currentLine > 0 && currentLine < root.getElementCount()) {
            int position = root.getElement(currentLine - 1).getStartOffset();
            return root.getElementIndex(offset) == root.getElementIndex(position);
        }
        return false;
    }

    private int getTextLineNumber(int offset) {
        int index;
        Element root = this.pane.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(offset));
        if (line.getStartOffset() == offset) {
            return index + 1;
        }
        return -1;
    }

    private int getOffsetX(int availableWidth, int stringWidth) {
        return availableWidth - stringWidth;
    }

    private int getOffsetY(int offset, FontMetrics metrics) throws BadLocationException {
        Rectangle r = this.pane.modelToView(offset);
        int lineHeight = metrics.getHeight();
        int y = r.y + r.height;
        int descent = 0;
        if (r.height == lineHeight) {
            descent = metrics.getDescent();
        } else {
            Element root = this.pane.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(offset);
            Element line = root.getElement(index);
            for (int i = 0; i < line.getElementCount(); ++i) {
                Element child = line.getElement(i);
                AttributeSet as = child.getAttributes();
                String family = (String)as.getAttribute(StyleConstants.FontFamily);
                Integer fontSize = (Integer)as.getAttribute(StyleConstants.FontSize);
                if (fontSize == null) continue;
                String key = family + fontSize;
                FontMetrics fm = this.fonts.get(key);
                if (fm == null) {
                    Font font = new Font(family, 0, fontSize);
                    fm = this.pane.getFontMetrics(font);
                    this.fonts.put(key, fm);
                }
                descent = Math.max(descent, fm.getDescent());
            }
        }
        return y - descent;
    }
}

